/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.ext.LexicalHandler;
import org.xml.sax.helpers.DefaultHandler;

public class SxValidate {
    static int numXMLFiles = 0;
    static int numValidFiles = 0;
    static int numInvalidFiles = 0;
    static int numFilesMissingDoctype = 0;
    static int numMalformedFiles = 0;
    static boolean useSchema = false;
    static StringBuffer buff = new StringBuffer();

    public static void main(String[] args) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        if (args.length == 0 || args.length > 2) {
            System.out.println("\nGeben Sie 'sx_validate.x -help' f\u00fcr Information \u00fcber SxValidate");
            return;
        }
        if (args[0].toLowerCase().equals("-help")) {
            String sep = "\n====================================================\n";
            String a = "sx_validate <Datei oder Pfad> [SCHEMA] \nValidate nutzt Xerces um einen einzelnen XML-File zu validieren bzw. die xml Files in dem  Verzeichnis das Sie spezifizieren. Der Parser validiert jedes Dokument (Konformit\u00e4t zum DOCTYPE oder XMLSchema).\n";
            String b = "Jede xml Datei sollte eine DOCTYPE declaration oder einen XMLSchema-Verweis enthalten.\n\n";
            String c = "SxValidate nimmt 1 oder 2 Argumente:\n";
            String d = " Argument 1 spezifiziert das Verzeichnis oder die Datei.\n";
            String e = " Argument 2 (einfach 'SCHEMA') spezifiziert, ob nach XML-Schema validiert werden soll.\n";
            System.out.println(sep + a + b + c + d + e + sep);
            return;
        }
        try {
            SxValidate v = new SxValidate();
            v.validate(args);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    void validate(String[] args) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        File dir = new File(args[0]);
        useSchema = false;
        if (args.length == 2 && args[1].equalsIgnoreCase("SCHEMA")) {
            useSchema = true;
        }
        if (dir.isFile()) {
            this.parse(null, args[0], useSchema);
        } else if (dir.isDirectory()) {
            XMLFileFilter filter = new XMLFileFilter();
            String[] files = dir.list(filter);
            for (int i = 0; i < files.length; ++i) {
                this.parse(dir.toString(), files[i], useSchema);
                System.out.print(buff.toString());
                buff = new StringBuffer();
            }
        } else {
            System.out.println(args[0] + " not found!");
            return;
        }
        buff.append("================SUMMARY=============================\n");
        if (numXMLFiles > 1) {
            buff.append("Parsed " + numXMLFiles + " .xml files in " + args[0] + ".\n");
        }
        if (numValidFiles > 1) {
            buff.append(numValidFiles + " files are valid.\n");
        } else if (numValidFiles == 1) {
            buff.append(numValidFiles + " file is valid.\n");
        }
        if (numInvalidFiles > 1) {
            buff.append(numInvalidFiles + " files are not valid.\n");
        } else if (numInvalidFiles == 1) {
            buff.append(numInvalidFiles + " file is not valid.\n");
        }
        if (numMalformedFiles > 1) {
            buff.append(numMalformedFiles + " files are not well-formed.\n");
        } else if (numMalformedFiles == 1) {
            buff.append(numMalformedFiles + " file is not well-formed.\n");
        }
        if (numFilesMissingDoctype > 1) {
            buff.append(numFilesMissingDoctype + " files do not contain a DOCTYPE declaration.\n");
        } else if (numFilesMissingDoctype == 1) {
            buff.append(numFilesMissingDoctype + " file does not contain a DOCTYPE declaration.\n");
        }
        System.out.print(buff.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void parse(String dir, String filename, boolean useSchema) throws FileNotFoundException, IOException, ParserConfigurationException, SAXException {
        try {
            File f = new File(dir, filename);
            StringBuffer errorBuff = new StringBuffer();
            InputSource input = new InputSource(new FileInputStream(f));
            input.setSystemId(f.toString());
            SAXParserFactory spfact = SAXParserFactory.newInstance();
            spfact.setValidating(true);
            spfact.setNamespaceAware(true);
            SAXParser parser = spfact.newSAXParser();
            XMLReader reader = parser.getXMLReader();
            Handler handler = new Handler(filename, errorBuff);
            reader.setProperty("http://xml.org/sax/properties/lexical-handler", handler);
            if (useSchema) {
                parser.setProperty("http://java.sun.com/xml/jaxp/properties/schemaLanguage", "http://www.w3.org/2001/XMLSchema");
                buff.append("Nutze XML-Schema Validierung\n");
            }
            parser.parse(input, (DefaultHandler)handler);
            if (handler.containsDTD && !handler.errorOrWarning) {
                buff.append("VALID " + filename + "\n");
                ++numValidFiles;
            } else if (handler.containsDTD) {
                buff.append("NOT VALID " + filename + "\n");
                buff.append(errorBuff.toString());
                ++numInvalidFiles;
            } else if (handler.errorOrWarning) {
                buff.append("Datei " + filename + " wurde validiert:\n" + errorBuff.toString());
                ++numInvalidFiles;
            } else {
                buff.append("Datei " + filename + " wurde validiert:\n" + errorBuff.toString());
                ++numValidFiles;
            }
        }
        catch (Exception e) {
            buff.append("NOT WELL-FORMED " + filename + ". " + e.getMessage() + "\n");
            ++numMalformedFiles;
        }
        finally {
            ++numXMLFiles;
        }
    }

    class XMLFileFilter
    implements FilenameFilter {
        XMLFileFilter() {
        }

        @Override
        public boolean accept(File dir, String fileName) {
            return fileName.toLowerCase().endsWith(".xml") && new File(dir.toString(), fileName).isFile();
        }
    }

    class Handler
    extends DefaultHandler
    implements LexicalHandler {
        boolean errorOrWarning;
        boolean containsDTD;
        String sourceFile;
        StringBuffer errorBuff;

        Handler(String sourceFile, StringBuffer errorBuff) {
            this.sourceFile = sourceFile;
            this.errorBuff = errorBuff;
            this.errorOrWarning = false;
            this.containsDTD = false;
        }

        @Override
        public void error(SAXParseException exc) {
            this.errorBuff.append(this.sourceFile + " Error: " + exc.getMessage() + "\n");
            this.errorOrWarning = true;
        }

        @Override
        public void warning(SAXParseException exc) {
            this.errorBuff.append(this.sourceFile + " Warning:" + exc.getMessage() + "\n");
            this.errorOrWarning = true;
        }

        @Override
        public void startDTD(String name, String publicId, String systemId) throws SAXException {
            this.containsDTD = true;
        }

        @Override
        public void endDTD() throws SAXException {
        }

        @Override
        public void startEntity(String name) throws SAXException {
        }

        @Override
        public void endEntity(String name) throws SAXException {
        }

        @Override
        public void startCDATA() throws SAXException {
        }

        @Override
        public void endCDATA() throws SAXException {
        }

        @Override
        public void comment(char[] ch, int start, int length) throws SAXException {
        }
    }
}

