/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.memtext.util.XMLUtils;
import de.superx.bin.Doquery;
import de.superx.bin.Dosql;
import de.superx.bin.SxDBUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.logging.LogManager;
import java.util.logging.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class SxExtractor {
    String delim = "^";
    String header = "false";
    String logfile = "../conf/logging.properties";
    String tabelle = "";
    String dbpropfile = "../conf/db.properties";
    String myElement = "table";
    String myAttrib = "name";
    String outformat = "txt";
    String outfile = "";
    String _dateiPfad = "";
    private static final String extraction_table = "extraction-table";
    private static final String extraction_script = "extraction-script";
    private static final String extraction_sql = "extraction-sql";
    private static final String database_name = "database";
    private static final String version_name = "version";
    private static final String transfer_unload_file = "transfer-unload-file";
    private static Document document;
    public Logger logger = Logger.getLogger(SxExtractor.class.toString());
    private static String usage;

    public SxExtractor(String[] args) throws IOException, SAXException {
        File f;
        FileInputStream is;
        String name = "";
        String unl_file = "";
        Object params = "";
        String database = "";
        String version = "";
        String p_database = "";
        String p_version = "";
        String unload_params = "unload_params.txt";
        String sourcesystem = "";
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_logger, GetOpts.Options.opt_dbprops, GetOpts.Options.opt_xml});
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        Properties props = new Properties();
        if (GetOpts.isPresent(GetOpts.Options.opt_logger)) {
            this.logfile = GetOpts.getValue(GetOpts.Options.opt_logger);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
            this.dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_xml)) {
            this._dateiPfad = GetOpts.getValue(GetOpts.Options.opt_xml);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_xml)) {
            params = GetOpts.getValue(GetOpts.Options.opt_xml);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_outFormat)) {
            this.outformat = GetOpts.getValue(GetOpts.Options.opt_outFormat);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_delim)) {
            this.delim = GetOpts.getValue(GetOpts.Options.opt_delim);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_header)) {
            this.header = GetOpts.getValue(GetOpts.Options.opt_header);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_db)) {
            p_database = GetOpts.getValue(GetOpts.Options.opt_db);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_version)) {
            p_version = GetOpts.getValue(GetOpts.Options.opt_version);
        }
        if (GetOpts.isPresent(GetOpts.Options.opt_unlParams)) {
            unload_params = GetOpts.getValue(GetOpts.Options.opt_unlParams);
        }
        if (new File(unload_params).exists() && (is = new FileInputStream(unload_params)) != null) {
            props.load(is);
            is.close();
            Enumeration<?> propnames = props.propertyNames();
            if (propnames != null) {
                params = "";
                while (propnames.hasMoreElements()) {
                    String propname = (String)propnames.nextElement();
                    params = (String)params + propname + "=" + props.getProperty(propname) + "^";
                    if (!propname.equals("$SOURCESYSTEM")) continue;
                    sourcesystem = props.getProperty(propname);
                }
            }
        }
        if (!(f = new File(this.logfile)).exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        if (this.delim.equals("")) {
            this.delim = "^";
        }
        document = XMLUtils.buildDocument(new File(this._dateiPfad), false);
        NodeList myNodes = document.getElementsByTagName("unload-job");
        for (int i = 0; i < myNodes.getLength(); ++i) {
            Node myNode = myNodes.item(i);
            if (myNode.getNodeType() == 3) continue;
            unl_file = XMLUtils.hasAttrib(myNode, transfer_unload_file) ? XMLUtils.getAttribValue(myNode, transfer_unload_file) : "";
            name = XMLUtils.hasAttrib(myNode, extraction_table) ? XMLUtils.getAttribValue(myNode, extraction_table) : "";
            version = XMLUtils.hasAttrib(myNode, version_name) ? XMLUtils.getAttribValue(myNode, version_name) : "";
            database = XMLUtils.hasAttrib(myNode, database_name) ? XMLUtils.getAttribValue(myNode, database_name) : "";
            if (!name.equals("")) {
                this.extractTable(name, unl_file, database, version, p_database, p_version);
            }
            if (!(name = XMLUtils.hasAttrib(myNode, extraction_script) ? XMLUtils.getAttribValue(myNode, extraction_script) : "").equals("") && (!XMLUtils.hasAttrib(myNode, "sourcesystem") || XMLUtils.getAttribValue(myNode, "sourcesystem").equals("") || XMLUtils.hasAttrib(myNode, "sourcesystem") && XMLUtils.getAttribValue(myNode, "sourcesystem").equals(sourcesystem))) {
                this.extractionScript(name, unl_file, (String)params, database, version, p_database, p_version);
            }
            NodeList mySqls = myNode.getChildNodes();
            String sql = "";
            for (int k = 0; k < mySqls.getLength(); ++k) {
                Node mySqlNode = mySqls.item(k);
                if (!mySqlNode.getNodeName().equals(extraction_sql) || XMLUtils.hasAttrib(mySqlNode, "sourcesystem") && !XMLUtils.getAttribValue(mySqlNode, "sourcesystem").equals("") && (!XMLUtils.hasAttrib(mySqlNode, "sourcesystem") || !XMLUtils.getAttribValue(mySqlNode, "sourcesystem").equals(sourcesystem))) continue;
                params = this.extractionSql(unl_file, (String)params, p_database, p_version, mySqlNode);
            }
        }
    }

    private String extractionSql(String unl_file, String params, String p_database, String p_version, Node mySqlNode) {
        String sql;
        String version;
        String database = XMLUtils.hasAttrib(mySqlNode, database_name) ? XMLUtils.getAttribValue(mySqlNode, database_name) : "";
        if (this.isDatabaseAndVersionOk(p_database, p_version, database, version = XMLUtils.hasAttrib(mySqlNode, version_name) ? XMLUtils.getAttribValue(mySqlNode, version_name) : "") && !(sql = XMLUtils.getChildNodeValues(mySqlNode)).equals("")) {
            if (!((String)params).equals("")) {
                if (!((String)params).endsWith("^")) {
                    params = (String)params + "^";
                }
                StringTokenizer st = new StringTokenizer((String)params, "^");
                while (st.hasMoreTokens()) {
                    String param = st.nextToken();
                    if (param.equals("")) continue;
                    String paramname = param.substring(0, param.indexOf("="));
                    String paramvalue = param.substring(param.indexOf("=") + 1, param.length());
                    sql = SxDBUtils.replaceString(sql, paramname, paramvalue);
                }
            }
            String[] myArgs = new String[]{this.logfile, this.dbpropfile, sql, this.outformat, this.delim, this.header, unl_file};
            try {
                Doquery.go(myArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.info("Executed sql:\n " + sql);
        }
        return params;
    }

    private boolean isDatabaseAndVersionOk(String p_database, String p_version, String database, String version) {
        boolean version_ok = false;
        StringTokenizer st = new StringTokenizer(version, ",");
        while (st.hasMoreTokens()) {
            String m_version = st.nextToken();
            if (!m_version.trim().equals(p_version)) continue;
            version_ok = true;
        }
        return !(database.indexOf(p_database) <= -1 && !database.equals("") || !version_ok && !version.equals(""));
    }

    private void extractionScript(String name, String unl_file, String params, String database, String version, String p_database, String p_version) {
        if (this.isDatabaseAndVersionOk(p_database, p_version, database, version)) {
            String[] myArgs = new String[8];
            myArgs[0] = "-logger:" + this.logfile;
            myArgs[1] = "-dbproperties:" + this.dbpropfile;
            myArgs[2] = "-sqlfile:" + name;
            myArgs[3] = "-outFormat:" + this.outformat;
            myArgs[4] = "-delim:" + this.delim;
            myArgs[5] = "-header:" + this.header;
            myArgs[6] = "-params:" + params;
            myArgs[7] = unl_file.equals("") ? (this.outformat.equals("txt") ? "-outfile:" + name + ".unl" : "-outfile:" + name + "." + this.outformat) : "-outfile:" + unl_file;
            try {
                Dosql.execute(myArgs);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.logger.info("Executed sqlFile: " + name);
        }
    }

    private void extractTable(String name, String unl_file, String database, String version, String p_database, String p_version) {
        if (this.isDatabaseAndVersionOk(p_database, p_version, database, version)) {
            String[] myArgs = new String[7];
            myArgs[0] = this.logfile;
            myArgs[1] = this.dbpropfile;
            myArgs[2] = "select * from " + name;
            myArgs[3] = this.outformat;
            myArgs[4] = this.delim;
            myArgs[5] = this.header;
            myArgs[6] = unl_file.equals("") ? (this.outformat.equals("txt") ? name + ".unl" : name + "." + this.outformat) : unl_file;
            try {
                Doquery.go(myArgs);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            catch (ClassNotFoundException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            this.logger.info("Unloaded Table " + name);
        }
    }

    public static void main(String[] args) {
        try {
            SxExtractor sxExtractor = new SxExtractor(args);
        }
        catch (Exception ex) {
            System.err.println("Fehler: " + ex);
            ex.printStackTrace();
        }
    }

    static {
        usage = "-------------------------------------\nDieses Script analysiert eine vorgegebene XML-Datei auf Attribute extraction-table, extraction-script und extraction-sql. Wess es ein Attribur findet, startet es die entsprechende DB-Verbindung und entl\u00e4dt das Ergebnis nach dem Wert des Attributs transfer-unload-file\nGebrauch: java de.superx.bin.SxExtractor -logger=<<Pfad zu logging.properties>> -dbproperties=<<Pfad zu db.properties>> -xml:<xml-Datei> -params:<Parameter, die in sql- oder Script-Dateien ersetzt werden; Syntax:param1=wert1|param2=wert2 etc> -outFormat:<Ausgabeformat (txt | html | xml)>(optional)  -delim:<delimiter> -header:<mit Spalten\u00fcberschriften (true | false)>(optional) -outfile:<Ausgabedatei>(optional) \n---------------------------------------------------";
    }
}

