/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import com.martiansoftware.jsap.Switch;
import jakarta.activation.DataHandler;
import jakarta.activation.DataSource;
import jakarta.activation.FileDataSource;
import jakarta.mail.Address;
import jakarta.mail.BodyPart;
import jakarta.mail.Message;
import jakarta.mail.Multipart;
import jakarta.mail.PasswordAuthentication;
import jakarta.mail.Session;
import jakarta.mail.Transport;
import jakarta.mail.internet.InternetAddress;
import jakarta.mail.internet.MimeBodyPart;
import jakarta.mail.internet.MimeMessage;
import jakarta.mail.internet.MimeMultipart;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;
import java.util.Properties;

public class SendMail {
    private static final String port = "25";
    private String to;
    private String from;
    private String smtphost;
    private String username;
    private String password;
    private String subject;
    private String msg;
    private String msgfile;
    private String attach;
    private boolean sslWanted = false;

    public void send(String[] args) {
        this.readArgs(args);
        Session session = this.getSession();
        try {
            MimeMessage message = new MimeMessage(session);
            message.setFrom((Address)new InternetAddress(this.from));
            InternetAddress[] address = new InternetAddress[]{new InternetAddress(this.to)};
            message.setRecipients(Message.RecipientType.TO, (Address[])address);
            message.setSubject(this.subject);
            String content = this.getContent();
            if (this.attach != null) {
                MimeBodyPart mbp1 = new MimeBodyPart();
                mbp1.setText(content);
                MimeBodyPart mbp2 = new MimeBodyPart();
                FileDataSource fds = new FileDataSource(this.attach);
                mbp2.setDataHandler(new DataHandler((DataSource)fds));
                mbp2.setFileName(fds.getName());
                MimeMultipart mp = new MimeMultipart();
                mp.addBodyPart((BodyPart)mbp1);
                mp.addBodyPart((BodyPart)mbp2);
                message.setContent((Multipart)mp);
            } else {
                message.setContent((Object)content, "text/html");
            }
            message.setSentDate(new Date());
            Transport.send((Message)message);
            System.out.println("Email verschickt");
        }
        catch (Exception mex) {
            mex.printStackTrace();
            System.out.println("Es ist ein Fehler aufgetreten: " + mex);
            System.exit(-1);
        }
    }

    private String getContent() throws IOException {
        String content = this.msg;
        if (this.msgfile != null) {
            content = SendMail.readFile(new File(this.msgfile));
        }
        return content;
    }

    private void readArgs(String[] args) {
        JSAP jsap = new JSAP();
        FlaggedOption fto = new FlaggedOption("to").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setLongFlag("to");
        FlaggedOption ffrom = new FlaggedOption("from").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setLongFlag("from");
        FlaggedOption fhost = new FlaggedOption("host").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setLongFlag("host");
        FlaggedOption fusername = new FlaggedOption("username").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setLongFlag("username");
        FlaggedOption fpassword = new FlaggedOption("password").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setLongFlag("password");
        FlaggedOption fsubject = new FlaggedOption("subject").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(true).setLongFlag("subject");
        FlaggedOption fmsg = new FlaggedOption("msg").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setLongFlag("msg");
        FlaggedOption fmsgfile = new FlaggedOption("msgfile").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setLongFlag("msgfile");
        FlaggedOption fattach = new FlaggedOption("attach").setStringParser((StringParser)JSAP.STRING_PARSER).setRequired(false).setLongFlag("attach");
        Switch sw1 = new Switch("ssl").setLongFlag("ssl");
        sw1.setHelp("ssl aktivieren");
        JSAPResult config = null;
        try {
            jsap.registerParameter((Parameter)fto);
            jsap.registerParameter((Parameter)ffrom);
            jsap.registerParameter((Parameter)fhost);
            jsap.registerParameter((Parameter)sw1);
            jsap.registerParameter((Parameter)fusername);
            jsap.registerParameter((Parameter)fpassword);
            jsap.registerParameter((Parameter)fsubject);
            jsap.registerParameter((Parameter)fmsg);
            jsap.registerParameter((Parameter)fmsgfile);
            jsap.registerParameter((Parameter)fattach);
            config = jsap.parse(args);
            if (!config.success()) {
                Iterator errs = config.getErrorMessageIterator();
                while (errs.hasNext()) {
                    System.out.println("Error: " + errs.next());
                }
                SendMail.printUsage();
            }
            this.to = config.getString("to");
            this.from = config.getString("from");
            this.smtphost = config.getString("host");
            this.sslWanted = config.getBoolean("ssl");
            this.subject = config.getString("subject");
            this.username = config.getString("username");
            this.password = config.getString("password");
            this.msg = config.getString("msg");
            this.msgfile = config.getString("msgfile");
            this.attach = config.getString("attach");
        }
        catch (JSAPException e) {
            System.out.println("Fehler: " + e);
            SendMail.printUsage();
        }
    }

    private Session getSession() {
        Authenticator authenticator = new Authenticator();
        Properties properties = new Properties();
        properties.setProperty("mail.smtp.submitter", authenticator.getPasswordAuthentication().getUserName());
        properties.setProperty("mail.smtp.auth", "true");
        if (this.sslWanted) {
            properties.put("mail.smtp.starttls.enable", "true");
            System.out.println("SSL aktiviert");
        }
        properties.setProperty("mail.smtp.host", this.smtphost);
        properties.setProperty("mail.smtp.port", port);
        return Session.getInstance((Properties)properties, (jakarta.mail.Authenticator)authenticator);
    }

    private static void printUsage() {
        System.out.println("usage: java de.superx.bin.SendMail --to test@test.de --from system@super-ics.de --host smtp.strato.de --ssl (optional) --username system --password geheim --subject \"Ihre Dokumente\"  --msg \"Hier erhalten Sie Ihre Protokolle\" (optional) --msgfile c:\\nachricht.txt (optional) --attach c:\\protokoll.xls (optinal)");
        System.exit(1);
    }

    public static String readFile(File f) throws IOException {
        String line;
        FileReader fr = new FileReader(f);
        BufferedReader bfr = new BufferedReader(fr);
        StringBuffer result = new StringBuffer();
        while ((line = bfr.readLine()) != null) {
            result.append(line + "\n");
        }
        bfr.close();
        fr.close();
        return result.toString();
    }

    public static void main(String[] args) {
        SendMail sm = new SendMail();
        sm.send(args);
    }

    private class Authenticator
    extends jakarta.mail.Authenticator {
        private PasswordAuthentication authentication;

        public Authenticator() {
            this.authentication = new PasswordAuthentication(SendMail.this.username, SendMail.this.password);
        }

        protected PasswordAuthentication getPasswordAuthentication() {
            return this.authentication;
        }
    }
}

