/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.DSAHandler;
import de.memtext.util.GetOpts;
import de.superx.bin.SxConnection;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;
import java.util.Hashtable;

public class PublicPrivateKeyManager {
    public static void main(String[] args) {
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_function});
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.exit(1);
        }
        SxConnection sxcon = new SxConnection();
        sxcon.setPropfile(GetOpts.getValue(GetOpts.Options.opt_dbprops));
        String function = GetOpts.getValue(GetOpts.Options.opt_function);
        try {
            if (function.equals("install")) {
                PublicPrivateKeyManager.install(sxcon);
                PublicPrivateKeyManager.check(sxcon);
            }
            if (function.equals("delete")) {
                PublicPrivateKeyManager.delete(sxcon);
                System.out.println("public/private key entfernt");
            }
            if (function.equals("check")) {
                System.out.println("Suche keys ...");
                PublicPrivateKeyManager.check(sxcon);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void check(SxConnection sxcon) throws Exception {
        Connection con = sxcon.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("select count(*) from sx_repository where id='privatekey'");
        int countprivate = 0;
        while (rs.next()) {
            countprivate = rs.getInt(1);
        }
        rs.close();
        rs = st.executeQuery("select count(*) from sx_repository where id='publickey'");
        int countpublic = 0;
        while (rs.next()) {
            countpublic = rs.getInt(1);
        }
        rs.close();
        st.close();
        con.close();
        if (countprivate == 0) {
            System.out.println("private key nicht installiert");
        }
        if (countprivate == 1) {
            System.out.println("private key installiert");
        }
        if (countprivate > 1) {
            System.out.println("mehr als ein private key gefunden - alle keys werden gel\u00f6scht");
            PublicPrivateKeyManager.delete(sxcon);
        }
        if (countpublic == 0) {
            System.out.println("public key nicht installiert");
        }
        if (countpublic == 1) {
            System.out.println("public key installiert");
        }
        if (countpublic > 1) {
            System.out.println("mehr als ein public key gefunden - alle keys werden gel\u00f6scht");
            PublicPrivateKeyManager.delete(sxcon);
        }
    }

    private static void delete(SxConnection sxcon) throws Exception {
        Connection con = sxcon.getConnection();
        Statement st = con.createStatement();
        st.executeUpdate("delete from sx_repository where id in ('privatekey','publickey')");
        st.close();
        con.close();
    }

    private static void install(SxConnection sxcon) throws Exception {
        PublicPrivateKeyManager.delete(sxcon);
        Connection con = sxcon.getConnection();
        Statement st = con.createStatement();
        ResultSet rs = st.executeQuery("select max(tid) from sx_repository");
        int tid = 0;
        while (rs.next()) {
            tid = rs.getInt(1);
        }
        rs.close();
        Hashtable table = DSAHandler.generateKeyPair();
        PreparedStatement pst = con.prepareStatement("insert into sx_repository (tid,id,content,aktiv) values (?,?,?,2)");
        pst.setInt(1, ++tid);
        pst.setString(2, "privatekey");
        pst.setString(3, table.get("privatekey").toString());
        pst.execute();
        pst.setInt(1, ++tid);
        pst.setString(2, "publickey");
        pst.setString(3, table.get("publickey").toString());
        pst.execute();
        pst.close();
        con.close();
    }
}

