/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.memtext.util.XMLUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.DriverManager;
import java.util.Base64;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.Scanner;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.io.FileUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public class PropAdmin {
    private static File dbpropfile;
    private static Properties props;
    private static String fileEncoding;

    public static void main(String[] args) {
        GetOpts.setOpts(args);
        if (!GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
            System.out.println("Usage propadmin.x DB-PROPERTIES-FILE");
            System.exit(1);
        } else {
            try {
                boolean noGui = GetOpts.isPresent(GetOpts.Options.opt_noguiVar0);
                System.out.println("PropAdmin V2.0");
                PropAdmin.initFileEncoding();
                PropAdmin.run(noGui);
            }
            catch (IOException e) {
                System.out.println("Fehler bei Properties-Bearbeitung: " + e);
                e.printStackTrace();
            }
        }
    }

    private static void initFileEncoding() throws IOException {
        System.out.println("");
        fileEncoding = System.getProperty("file.encoding");
        if (fileEncoding == null || fileEncoding.isEmpty()) {
            throw new IOException("Umgebungsvariable file.encoding muss gesetzt sein!");
        }
        System.out.println("  Umgebungsvariable file.encoding gesetzt auf: " + fileEncoding);
    }

    private static void run(boolean noGui) throws IOException {
        String propfileParam = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        if (propfileParam.indexOf("..") > -1) {
            System.out.println("  INFO: Relative Pfadangabe (" + propfileParam + ") wird konvertiert");
        }
        dbpropfile = new File(propfileParam).getCanonicalFile();
        PropAdmin.properties_einlesen();
        if (!noGui) {
            System.out.println("");
            PropAdmin.confirmOrUpdateProperty("Datenbanktreiber", "driverName");
            PropAdmin.confirmOrUpdateProperty("connectionURL", "connectionURL");
            PropAdmin.confirmOrUpdateProperty("connectionName (User)", "connectionName");
            PropAdmin.updatePassword("connectionURL", "connectionName", "connectionPassword");
            if (props.getProperty("restrictedConnectionName") != null) {
                PropAdmin.confirmOrUpdateProperty("restrictedConnectionName", "restrictedConnectionName");
                PropAdmin.updatePassword("connectionURL", "restrictedConnectionName", "restrictedConnectionPassword");
            }
            PropAdmin.saveProps();
            System.out.println("\nDie anderen Parameter in der " + dbpropfile + " koennen Sie ggfs. mit einem Texteditor \u00e4ndern\n");
        }
        PropAdmin.configSuperXSaiku(props.getProperty("connectionName"), props.getProperty("connectionPassword"), props.getProperty("driverName"), props.getProperty("connectionURL"));
    }

    private static void configSuperXSaiku(String user, String passwd, String driver, String url) throws IOException {
        System.out.println("\n\u00dcbertragung auf Saiku/Spring Dateien");
        PropAdmin.configSaikuDatasource("classes", user, passwd, driver, url);
        PropAdmin.configSaikuDatasource("src", user, passwd, driver, url);
        PropAdmin.configSaikuBeans(user, passwd, driver, url);
        PropAdmin.checkSaikuJCRRepositoryConfiguration(user, passwd, driver, url);
        PropAdmin.checkSaikuJCRRepositoryDefaultWorkspace(user, passwd, driver, url);
        PropAdmin.checkSaikuJCRRepositorySecurityWorkspace(user, passwd, driver, url);
    }

    private static void checkSaikuJCRRepositoryConfiguration(String user, String passwd, String driver, String url) throws IOException {
        File configFile = new File(dbpropfile.getParentFile().getAbsolutePath() + File.separator + "saiku" + File.separator + "repository" + File.separator + "configuration.xml");
        if (configFile.exists()) {
            System.out.print("Saiku Repository Konfiguration: " + configFile + " ..");
            try {
                PropAdmin.doAdaptation(configFile, user, PropAdmin.base64encode(passwd), driver, url);
                System.out.println("  OK");
            }
            catch (IOException e) {
                throw new IOException(" Fehler beim Einlesen/Speichern von " + configFile + " :" + e);
            }
        }
    }

    private static void checkSaikuJCRRepositoryDefaultWorkspace(String user, String passwd, String driver, String url) throws IOException {
        File configFile = new File(dbpropfile.getParentFile().getAbsolutePath() + File.separator + "saiku" + File.separator + "repository" + File.separator + "data" + File.separator + "workspaces" + File.separator + "default" + File.separator + "workspace.xml");
        if (configFile.exists()) {
            System.out.print("Saiku Repository Default Workspace: " + configFile + " ..");
            try {
                PropAdmin.doAdaptation(configFile, user, PropAdmin.base64encode(passwd), driver, url);
                System.out.println("  OK");
            }
            catch (IOException e) {
                throw new IOException(" Fehler beim Einlesen/Speichern von " + configFile + " :" + e);
            }
        }
    }

    private static void checkSaikuJCRRepositorySecurityWorkspace(String user, String passwd, String driver, String url) throws IOException {
        File configFile = new File(dbpropfile.getParentFile().getAbsolutePath() + File.separator + "saiku" + File.separator + "repository" + File.separator + "data" + File.separator + "workspaces" + File.separator + "security" + File.separator + "workspace.xml");
        if (configFile.exists()) {
            System.out.print("Saiku Repository Security Workspace: " + configFile + "..");
            try {
                PropAdmin.doAdaptation(configFile, user, PropAdmin.base64encode(passwd), driver, url);
                System.out.println("  OK");
            }
            catch (IOException e) {
                throw new IOException(" Fehler beim Einlesen/Speichern von " + configFile + " :" + e);
            }
        }
    }

    private static String base64encode(String input) {
        return "{base64}" + Base64.getEncoder().withoutPadding().encodeToString(input.getBytes());
    }

    private static void doAdaptation(File configFile, String user, String passwd, String driver, String url) throws IOException {
        String oldConfig = StringUtils.readFile(configFile);
        String newConfig = new String(oldConfig);
        if (url.toLowerCase().indexOf("postgres") == -1) {
            throw new IOException("  In der Datei wurde bisher nur databaseType=postgresql getestet");
        }
        newConfig = newConfig.replaceAll("name=\"driver\".*value=\".*\"", "name=\"driver\" value=\"" + driver + "\"");
        newConfig = newConfig.replaceAll("name=\"url\".*value=\".*\"", "name=\"url\" value=\"" + url + "\"");
        newConfig = newConfig.replaceAll("name=\"user\".*value=\".*\"", "name=\"user\" value=\"" + user + "\"");
        newConfig = newConfig.replaceAll("name=\"password\".*value=\".*\"", "name=\"password\" value=\"" + passwd + "\"");
        FileUtils.write((File)configFile, (CharSequence)newConfig);
    }

    private static void configSaikuBeans(String user, String passwd, String driver, String url) throws IOException {
        String saikubeansPath = dbpropfile.getParentFile().getAbsolutePath() + File.separator + "saiku" + File.separator + "saiku-beans.xml";
        File saikubeansFile = new File(saikubeansPath);
        System.out.print("Saiku-Beans Datei: " + saikubeansFile + " ..");
        if (!saikubeansFile.exists()) {
            File saikubeansSamFile = new File(dbpropfile.getParentFile().getAbsolutePath() + File.separator + "saiku", "saiku-beans.xml.sam");
            if (saikubeansSamFile.exists()) {
                System.out.println("\n  Keine Datei " + saikubeansFile + " gefunden, kopiere Vorlage saiku-beans.xml.sam nach saiku-beans.xml ");
                FileUtils.copyFile((File)saikubeansSamFile, (File)saikubeansFile);
            } else {
                throw new IOException("Weder " + saikubeansFile + " noch saiku-beans.xml.sam gefunden");
            }
        }
        try {
            String oldConfig = StringUtils.readFile(saikubeansFile);
            String newConfig = new String(oldConfig);
            newConfig = newConfig.replaceAll("name=\"driverClassName\".*value=\".*\"", "name=\"driverClassName\" value=\"" + driver + "\"");
            newConfig = newConfig.replaceAll("name=\"url\".*value=\".*\"", "name=\"url\" value=\"" + url + "\"");
            newConfig = newConfig.replaceAll("name=\"username\".*value=\".*\"", "name=\"username\" value=\"" + user + "\"");
            newConfig = newConfig.replaceAll("name=\"password\".*value=\".*\"", "name=\"password\" value=\"" + passwd + "\"");
            FileUtils.write((File)saikubeansFile, (CharSequence)newConfig);
            System.out.println("  OK");
        }
        catch (IOException e) {
            throw new IOException(" Fehler beim Einlesen/Speichern von " + saikubeansFile + " :" + e + "TIPP: L\u00d6SCHEN SIE DIE DATEI saiku-beans.xml damit saiku-beans.xml als Vorlage genommen wird");
        }
    }

    private static void configSaikuDatasource(String variante, String user, String passwd, String driver, String url) throws IOException {
        if (variante.contentEquals("classes")) {
            File saikuDatasource = new File(dbpropfile.getParentFile().getAbsolutePath() + File.separator + "classes" + File.separator + "saiku-datasources", "edustore");
            System.out.print("Saiku Datasource: " + saikuDatasource + " .. ");
            if (!saikuDatasource.exists()) {
                File saikuDatasourceSamFile = new File(dbpropfile.getAbsolutePath() + File.separator + "edustore.sam");
                if (saikuDatasourceSamFile.exists()) {
                    System.out.println("\nKeine Datei " + saikuDatasource + "gefunden, kopiere Vorlage edustore.sam nach edustore ");
                    FileUtils.copyFile((File)saikuDatasourceSamFile, (File)saikuDatasource);
                } else {
                    throw new IOException("Weder " + saikuDatasource + " noch Vorlage in WEB-INF/edustore.sam gefunden");
                }
            }
            PropAdmin.adaptSaikuDatasourceFile(user, passwd, driver, url, saikuDatasource);
        } else {
            File saikuDatasourceInSrcOrdner = new File(dbpropfile.getParentFile().getParentFile().getParentFile().getAbsolutePath() + File.separator + "src" + File.separator + "saiku-datasources", "edustore");
            if (saikuDatasourceInSrcOrdner.exists()) {
                System.out.print("Saiku Datasource in src-Ordner: " + saikuDatasourceInSrcOrdner + " .. ");
                PropAdmin.adaptSaikuDatasourceFile(user, passwd, driver, url, saikuDatasourceInSrcOrdner);
            }
        }
    }

    private static void adaptSaikuDatasourceFile(String user, String passwd, String driver, String url, File saikuDatasource) throws IOException {
        List lines = FileUtils.readLines((File)saikuDatasource, (String)fileEncoding);
        StringBuffer config = new StringBuffer();
        for (String line : lines) {
            if (line.startsWith("location=")) {
                config.append("location=jdbc:mondrian:Jdbc=").append(url).append(";Catalog=mondrian:///datasources/edustore.xml;JdbcDrivers=").append(driver).append(";UseContentChecksum=true");
            } else if (line.startsWith("username=")) {
                config.append("username=\"").append(user).append('\"');
            } else if (line.startsWith("password=")) {
                config.append("password=\"").append(passwd).append('\"');
            } else {
                config.append(line);
            }
            config.append('\n');
        }
        try {
            try (FileWriter fileWriter = new FileWriter(saikuDatasource);){
                if (config != null) {
                    fileWriter.write(config.toString());
                }
            }
            System.out.println(" OK");
        }
        catch (IOException e) {
            throw new IOException("Saiku: Datasource Datei " + saikuDatasource + " konnte nicht geschrieben werden:" + e);
        }
    }

    private static void saveProps() {
        try {
            props.remove("charSet");
            props.remove("DateStyle");
            props.remove("GL_DATETIME");
            props.remove("CLIENT_LOCALE");
            FileOutputStream os = new FileOutputStream(dbpropfile);
            props.store(os, "SuperX DB.properties");
            ((OutputStream)os).close();
            System.out.println("DB-Propertiesdatei (" + dbpropfile + ") .. OK");
        }
        catch (IOException e) {
            System.out.println("Konnte " + dbpropfile + " nicht speichern:" + e.toString());
            System.exit(1);
        }
    }

    private static void confirmOrUpdateProperty(String name, String propertyName) throws IOException {
        BufferedReader br;
        Object newValue;
        System.out.println("F\u00fcr " + name.toUpperCase() + " ist voreingestellt:\n  " + props.getProperty(propertyName));
        System.out.println("  Neuen Wert eingeben oder EINGABETASTE=OK ");
        if (propertyName.contentEquals("connectionURL")) {
            System.out.println("  (Tipp: Sie k\u00f6nnen die ganze URL mit jdbc:.. eingeben oder nur den Datenbanknamen, der wird dann an das letzte / angeh\u00e4ngt)");
        }
        if ((newValue = (br = new BufferedReader(new InputStreamReader(System.in))).readLine()) != null && !((String)newValue).trim().isEmpty()) {
            if (propertyName.contentEquals("connectionURL") && !((String)newValue).startsWith("jdbc:")) {
                String oldUrl = props.getProperty("connectionURL");
                newValue = oldUrl.substring(0, oldUrl.lastIndexOf("/") + 1) + (String)newValue;
                System.out.println(" neue ermittelte URL:" + (String)newValue + "\n");
            }
            props.put(propertyName, newValue);
        }
    }

    private static void updatePassword(String urlprop, String userprop, String propertyName) {
        System.out.println("Neues Passwort eingeben (Achtung: Auf Bildschirm sichtbar!):");
        Scanner scan = new Scanner(System.in);
        String newValue = scan.nextLine();
        if (newValue != null && !newValue.trim().isEmpty()) {
            System.out.println("Verbindung testen? j/n ?");
            String input = scan.nextLine();
            if (input != null && input.equalsIgnoreCase("j")) {
                PropAdmin.testConnection(props.getProperty(urlprop), props.getProperty(userprop), newValue);
            }
            props.put(propertyName, newValue);
        } else {
            System.out.println("Fehler: Kein Passwort eingegeben");
            System.exit(1);
        }
    }

    private static boolean testConnection(String url, String username, String password) {
        boolean result = false;
        try {
            Class.forName(props.getProperty("driverName"));
            if (props.getProperty("driverName").indexOf("postgres") > -1) {
                props.put("DateStyle", "German, DMY");
            } else {
                props.put("GL_DATETIME", "%d.%m.%Y %T");
            }
            Connection conn = DriverManager.getConnection(url, username, password);
            DatabaseMetaData dbmd = conn.getMetaData();
            String msg = "Verbindung mit Datenbank " + conn.getCatalog() + " (" + dbmd.getDatabaseProductName() + " " + dbmd.getDatabaseProductVersion() + ") als " + username + " erfolgreich aufgebaut";
            System.out.println(msg + "\n");
            conn.close();
            result = true;
        }
        catch (Exception e) {
            String msg = "Ein Fehler ist aufgetreten.\n" + e.toString();
            if (props.getProperty("driverName").indexOf("postgres") > -1 && e.toString().indexOf("Date Style") > -1) {
                msg = msg + "\nPr\u00fcfen Sie,ob Date Style auf dem Server auf German, DMY steht.";
            }
            System.out.println("Fehler: " + e.toString());
        }
        return result;
    }

    private static void properties_einlesen() throws IOException {
        System.out.println("  Lese ein: " + dbpropfile);
        props = new Properties();
        FileInputStream is = new FileInputStream(dbpropfile);
        props.load(is);
        is.close();
    }

    @Deprecated
    private void configSaikuBeansWithMemtextRoutines(File saikubeansFile, String user, String passwd, String driver, String url) throws IOException, SAXException, TransformerFactoryConfigurationError, TransformerException {
        List oldlines = FileUtils.readLines((File)saikubeansFile, (String)fileEncoding);
        Document d = XMLUtils.buildDocument(saikubeansFile);
        Node beanNode = XMLUtils.getFirstNodeWithNameAndAttrib(d, "bean", "id", "dataSource");
        Iterator<Node> it = XMLUtils.getChildNodeIterator(beanNode);
        while (it.hasNext()) {
            Node propertyNode = it.next();
            String attrib = XMLUtils.getAttribValue(propertyNode, "name");
            if (attrib.contentEquals("driverClassName")) {
                XMLUtils.setAttribValue(propertyNode, "value", driver);
            }
            if (attrib.contentEquals("url")) {
                XMLUtils.setAttribValue(propertyNode, "value", url);
            }
            if (attrib.contentEquals("username")) {
                XMLUtils.setAttribValue(propertyNode, "value", user);
            }
            if (!attrib.contentEquals("password")) continue;
            XMLUtils.setAttribValue(propertyNode, "value", passwd);
        }
        XMLUtils.writeXmlFile(d, saikubeansFile, fileEncoding);
    }

    @Deprecated
    private static void beansTagNachbearbeiten(File saikubeansFile, List<String> oldlines) throws IOException {
        System.out.println("  Anpassung von Namespaces in beans-Tag aus alter Dateiversion");
        String newConfig = StringUtils.readFile(saikubeansFile);
        String newConfigWithOldBeansTag = null;
        for (String oldline : oldlines) {
            if (oldline.indexOf("<beans") <= -1) continue;
            newConfigWithOldBeansTag = newConfig.replaceFirst("<beans.*/>", oldline);
            break;
        }
        FileUtils.write((File)saikubeansFile, newConfigWithOldBeansTag);
    }

    static {
        fileEncoding = null;
    }
}

