/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.superx.bin.SxConnection;
import de.superx.servlet.LdapPasswordChecker;
import java.io.File;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class LdapLockout {
    private static String usage = "Gebrauch: java de.superx.bin.LdapLockout -dbproperties=<<Pfad zu db.properties>> -ldapconfig=<<Pfad zu superx_standalone_ldap.properties>>";

    public static void main(String[] args) {
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_ldapconfig});
        if (isdrin != null) {
            System.err.println("Folgende Optionen fehlen: " + isdrin);
            System.err.println(usage);
            System.exit(1);
        }
        try {
            File f = new File("LdapLockout.log");
            if (f.exists()) {
                f.delete();
            }
            LdapPasswordChecker.setup(new File(GetOpts.getValue(GetOpts.Options.opt_ldapconfig)));
            LdapLockout.checkUsers(GetOpts.getValue(GetOpts.Options.opt_dbprops));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void checkUsers(String dbpropfile) throws Exception {
        SxConnection myConnection = new SxConnection();
        myConnection.setPropfile(dbpropfile);
        Connection con = myConnection.getConnection();
        Statement stm = con.createStatement();
        ResultSet rs = stm.executeQuery("select benutzer from userinfo order by 1");
        PreparedStatement pst = con.prepareStatement("update userinfo set max_versuch=0,passwd_sha=null, gueltig_bis=today()-1, info='deaktiviert am '||today() where benutzer=? and max_versuch>0");
        LdapPasswordChecker ldappwc = new LdapPasswordChecker();
        while (rs.next()) {
            String benutzer = rs.getString("benutzer");
            System.out.println("Pruefe Nutzer " + benutzer);
            if (!ldappwc.isUserLocked(benutzer)) continue;
            System.out.println(" - Benutzer " + benutzer + " wird gesperrt");
            pst.clearParameters();
            pst.setString(1, benutzer);
            pst.executeUpdate();
        }
        rs.close();
        stm.close();
        pst.close();
        myConnection.close();
        ldappwc.closeServiceCtxForLockout();
    }
}

