/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.db.ConnectionCreator;
import de.memtext.util.DateUtils;
import de.memtext.util.GetOpts;
import de.memtext.util.StringUtils;
import de.superx.common.FieldContainer;
import de.superx.common.Sichten;
import de.superx.common.StandaloneSicht;
import de.superx.common.SuperX_el;
import de.superx.common.SxResultRow;
import de.superx.common.SxResultSet;
import de.superx.common.SxSqlHelper;
import de.superx.common.SxUser;
import de.superx.common.TableFieldExists;
import de.superx.common.TemplateProcessor;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.util.PropsReader;
import de.superx.util.SqlStringUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.commons.io.FileUtils;

public class FMParser
extends TemplateProcessor {
    private String dbprop;
    private String infile;
    private String outfile;
    private Properties props;
    private Statement stm;
    private String isSimpleParser;
    private static String sqlDialect;

    public FMParser(String mandantenId, Connection con) throws SQLException {
        super(mandantenId, con);
        if (con.getMetaData().getDatabaseProductName().toLowerCase().contains("postgres")) {
            sqlDialect = "Postgres";
        }
    }

    public FMParser(String mandantenId) {
        super(mandantenId);
    }

    private void run() throws FileNotFoundException, IOException, Exception {
        this.dbprop = GetOpts.getValue(GetOpts.Options.opt_dbprops);
        this.props = PropsReader.prepareProps(new File(this.dbprop));
        this.infile = GetOpts.getValue(GetOpts.Options.opt_in);
        this.outfile = GetOpts.getValue(GetOpts.Options.opt_out);
        if (GetOpts.isPresent(GetOpts.Options.opt_simpPars)) {
            this.isSimpleParser = GetOpts.getValue(GetOpts.Options.opt_simpPars);
        }
        String input = StringUtils.readFile(new File(this.infile));
        Object output = "";
        if (this.isSimpleParser != null && this.isSimpleParser.equalsIgnoreCase("true")) {
            output = FMParser.simpleParser(this.dbprop, input);
        } else {
            SxPools.initTesting(this.props);
            this.initConAndParser();
            sqlDialect = SqlStringUtils.getSqlDialect(this.props.getProperty("driverName"));
            HashMap<String, TableFieldExists> map = new HashMap<String, TableFieldExists>();
            map.put("TableFieldExists", new TableFieldExists(this.con));
            output = "--automatically created by SuperX/Freemarker for " + sqlDialect + " (" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + ")\n" + this.process("FM-Parsing " + this.infile, input, map, sqlDialect);
            this.stm.close();
            this.con.close();
        }
        FileUtils.writeStringToFile((File)new File(this.outfile), (String)output);
    }

    private void initConAndParser() throws IOException, SQLException, ClassNotFoundException {
        this.con = ConnectionCreator.getConnectionCryptPassword(this.dbprop, "driverName", "connectionURL", "connectionName", "connectionPassword");
        this.stm = this.con.createStatement();
        if (SqlStringUtils.tableExists(this.con, "fm_templates", this.mandantenID)) {
            this.setTemplates(this.readFromDb("select trim(both from id),content from fm_templates"));
            FMParser.repositoryToMap(this.readFromDb("select trim(both from id) as id,caption,content,gueltig_seit,gueltig_bis,comment,sort1,sort2,sort3 from sx_repository where aktiv=1"), this.repositoryMap);
        }
        if (SqlStringUtils.tableExists(this.con, "konstanten", this.mandantenID)) {
            SxResultSet rs = this.readFromDb("select trim(both from beschreibung),apnr from konstanten");
            for (SxResultRow row : rs) {
                String beschreibung = (String)row.get(0);
                this.repositoryMap.put("K_" + beschreibung.trim(), row.get(1));
            }
        }
    }

    @Override
    protected SxResultSet readFromDb(String sql) throws SQLException {
        SuperX_el el = new SuperX_el();
        SxSqlHelper sh = new SxSqlHelper();
        sh.execute(sql, this.con, el);
        if (el.getError_String() != null && !el.getError_String().trim().equals("")) {
            throw new SQLException("\nProblem bei:\n\n  Meldung:" + el.getError_String() + "\n  sql:" + sql);
        }
        return el.getResultSet();
    }

    @Deprecated
    protected SxResultSet readFromDbAlt(String sql) throws SQLException {
        SxResultSet result = new SxResultSet();
        ResultSet rs = this.stm.executeQuery(sql);
        result.setColumnNames(rs.getMetaData());
        int naturalOrder = 0;
        while (rs.next()) {
            SxResultRow row = new SxResultRow(rs.getMetaData().getColumnCount(), naturalOrder++);
            for (int i = 1; i <= rs.getMetaData().getColumnCount(); ++i) {
                if (rs.getMetaData().getColumnType(i) == -1) {
                    row.add(rs.getString(i));
                    continue;
                }
                row.add(rs.getObject(i));
            }
            result.add(row);
        }
        rs.close();
        return result;
    }

    public static void main(String[] args) {
        GetOpts.setOpts(args);
        String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_dbprops, GetOpts.Options.opt_in, GetOpts.Options.opt_out});
        if (isdrin != null) {
            System.err.println("-dbproperties: -in: -out:");
            System.exit(1);
        }
        try {
            new FMParser(SxSQL_Server.DEFAULT_MANDANTEN_ID).run();
        }
        catch (Exception e) {
            System.err.println("Fehler beim FM-Parsen ");
            e.printStackTrace();
            System.exit(1);
        }
    }

    public static String simpleParser(String dbprop, String input) throws FileNotFoundException, IOException, Exception {
        Properties props = PropsReader.prepareProps(new File(dbprop));
        Object output = "";
        sqlDialect = SqlStringUtils.getSqlDialect(props.getProperty("driverName"));
        HashMap map = new HashMap();
        try {
            output = "--automatically created by SuperX/Freemarker for " + sqlDialect + " (" + DateUtils.getTodayString() + " " + DateUtils.getNowString() + ")\n" + new FMParser(SxSQL_Server.DEFAULT_MANDANTEN_ID).process("FM-Parsing ", input, map, sqlDialect);
        }
        catch (Exception e) {
            System.err.println("Fehler beim FM-Parsen ");
            e.printStackTrace();
            System.exit(1);
        }
        return output;
    }

    @Override
    protected StandaloneSicht addSqlVarSicht(HashMap hmap, String varname, String name_intern, String gewuenschterStand) throws SQLException {
        String sql = "select tid,name,label,'',beschreibung,quelle,standbutton,art  \n\t,type,alt_hier_id,treecfgtable,treecfgid,gueltig_seit,gueltig_bis,xmlmaxentries,name_intern,attribut1,attribut2,attribut3,cacheapplet,cachexml \nfrom sichten where name_intern='" + name_intern + "' and aktiv=1 order by type";
        SxResultSet roh = new SxResultSet();
        StandaloneSicht sicht = null;
        roh = this.readFromDb(sql);
        Sichten sichten = new Sichten();
        SxUser user = new SxUser();
        user.setAdmin(true);
        sichten.setUser(user);
        for (SxResultRow row : roh) {
            Integer id = 1;
            try {
                sichten.initNonInternalSicht(SxSQL_Server.DEFAULT_MANDANTEN_ID, StandaloneSicht.class, row, id);
                sicht = (StandaloneSicht)sichten.getById(id);
                sicht.setConnection(this.con);
                sicht.setSqlDialect(sqlDialect);
                if (gewuenschterStand.trim().startsWith("today")) {
                    gewuenschterStand = DateUtils.getTodayString();
                }
                sicht.setStand(new Hashtable(), hmap, new FieldContainer(), gewuenschterStand);
                hmap.put(varname, sicht);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new SQLException("Fehler beim Aufbau von Sicht " + name_intern + " " + e);
            }
        }
        return sicht;
    }
}

