/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.memtext.util.GetOpts;
import de.superx.bin.Doschema;
import de.superx.bin.SxJdbcClient;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class DoShutdown {
    Connection myDb;
    Statement st;
    DatabaseMetaData dbmd;
    boolean done;
    String delim;
    String header;
    Doschema.Format outFormat;
    String logfile;
    String tabelle;
    String dbpropfile;
    String outfile;
    Logger logger;
    private static String usage = "-------------------------------------\nGebrauch: java de.superx.bin DoShutdown -logger:<<Pfad zu logging.properties>> -dbproperties:<<Pfad zu den db.properties>> -cancel=<<Abbrechen bei Fehler (true/false)>>(optional)  \ndrei Parameter (Pfad zu den logger.properties, Pfad zu den db.properties  erforderlich---------------------------------------------------";

    public DoShutdown(String[] args) throws ClassNotFoundException, FileNotFoundException, IOException, SQLException {
        block7: {
            this.done = false;
            this.delim = "\t";
            this.header = "false";
            this.outFormat = Doschema.Format.txt;
            this.logfile = "../conf/logging.properties";
            this.tabelle = "";
            this.dbpropfile = "../conf/db.properties";
            this.outfile = "";
            this.logger = Logger.getLogger(DoShutdown.class.toString());
            String cancel = "";
            GetOpts.setOpts(args);
            String isdrin = GetOpts.isAllRequiredOptionsPresent(new GetOpts.Options[]{GetOpts.Options.opt_logger, GetOpts.Options.opt_dbprops});
            if (isdrin != null) {
                System.err.println("Folgende Optionen fehlen: " + isdrin);
                System.err.println(usage);
                System.exit(1);
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_logger)) {
                this.logfile = GetOpts.getValue(GetOpts.Options.opt_logger);
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_dbprops)) {
                this.dbpropfile = GetOpts.getValue(GetOpts.Options.opt_dbprops);
            }
            if (GetOpts.isPresent(GetOpts.Options.opt_cancel)) {
                cancel = GetOpts.getValue(GetOpts.Options.opt_cancel);
            }
            this.initLoggingSystem();
            boolean systemExitWanted = true;
            if (cancel.equalsIgnoreCase("false")) {
                systemExitWanted = false;
            }
            SxJdbcClient myClient = new SxJdbcClient(this.logger, this.dbpropfile, "checkpoint;");
            try {
                myClient.execute();
                myClient.sqlstmt = "shutdown immediately;";
                myClient.execute();
                this.logger.info("shutdown erfolgreich");
            }
            catch (SQLException e) {
                System.out.println("Fehler:" + e.toString());
                e.printStackTrace();
                if (!systemExitWanted) break block7;
                System.exit(-1);
            }
        }
    }

    private void initLoggingSystem() throws IOException, FileNotFoundException {
        File f = new File(this.logfile);
        if (!f.exists()) {
            throw new IOException("Datei nicht gefunden: " + this.logfile);
        }
        FileInputStream ins = new FileInputStream(this.logfile);
        LogManager MyLogManager = LogManager.getLogManager();
        MyLogManager.readConfiguration(ins);
        this.logfile = MyLogManager.getProperty(".level");
        this.logger.info("Using Loggging-Level " + this.logfile);
    }

    public static void instructions() {
        System.out.println("SuperX @version@\n");
        System.out.println("\nDieses Java-Programm beendet einen hsqldb-Datenbankserver\n");
        System.exit(1);
    }

    public static void main(String[] args) {
        try {
            DoShutdown doShutdown = new DoShutdown(args);
        }
        catch (Exception ex) {
            System.err.println("Exception caught.\n" + ex);
            ex.printStackTrace();
        }
    }
}

