/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.superx.bin.ColumnStatistic;
import de.superx.bin.ForeignKey;
import de.superx.bin.RankingEntry;
import de.superx.bin.TableStatistic;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.cli.config.CLIConfig;
import de.superx.spring.config.BatchConfig;
import de.superx.spring.config.DataJdbcConfiguration;
import de.superx.spring.config.ServiceConfig;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.JDBCType;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowCallbackHandler;
import org.springframework.jdbc.core.RowMapper;

public class DataProfiler {
    private static final String SQL_COUNT_NULL = "select count(*) from %s where %s is null";
    private static final String SQL_PERCENT_UNIQUE = "select\n    count(distinct %s) as unique_anz,\n    count(distinct %s)::float / count(*) * 100 as unique_percentage\nfrom\n    %s;";
    private static final String SQL_RANKING = "select %s, count(*) as anz from %s where %s is not null group by %s order by 2 desc limit 10;";
    private static final String SQL_MIN_MAX_LEN = "select min(length(%s)) as min_length, max(length(%s)) as max_length\nfrom %s\nwhere %s is not null";
    private static final String SQL_COUNT_VALUE = "select count(*) from %s where %s = %s";
    private static final String SQL_MIN_MAX_AVG = "select min(%s), max(%s), avg(%s) from %s where %s is not null;";
    private static final String SQL_START_END = "select min(%s), max(%s) from %s where %s is not null";
    private static GenericApplicationContext APPLICATION_CONTEXT = null;
    private static String HELP_STRING = "Use this tool to profile database tables for dwh design. It needs the config file 'his1_databases.properties' inside the classpath; this file gets written automatically when starting the web application.";
    static Logger logger = Logger.getLogger(DataProfiler.class);
    private DataSource dataSource;
    private String database;
    private String schema;
    private String[] tables;

    public DataProfiler(DataSource dataSource, String schema, String[] tables) {
        try (Connection con = dataSource.getConnection();){
            this.database = con.getCatalog();
        }
        catch (SQLException e) {
            logger.error((Object)"Couldn't read catalog", (Throwable)e);
        }
        this.schema = schema != null ? schema : "public";
        List<String> tableList = Arrays.asList(tables);
        tableList.sort(null);
        this.tables = tableList.toArray(new String[0]);
        this.dataSource = dataSource;
    }

    public static void main(String[] args) {
        System.setProperty("SuperX-HISinOne-VERSION", "non-empty-value");
        Options options = DataProfiler.createOptions();
        CommandLine parsedArgs = DataProfiler.parseArgs(args, options);
        if (parsedArgs.hasOption("h")) {
            DataProfiler.printHelp(options);
            System.exit(0);
        }
        String database = null;
        String schema = "public";
        String[] tables = null;
        if (parsedArgs.hasOption("d")) {
            database = parsedArgs.getOptionValue('d');
        }
        if (parsedArgs.hasOption("s")) {
            schema = parsedArgs.getOptionValue('s');
        }
        if (parsedArgs.hasOption("t")) {
            tables = parsedArgs.getOptionValues('t');
        }
        if (!parsedArgs.hasOption('d') || !parsedArgs.hasOption('t')) {
            DataProfiler.printHelp(options);
            System.exit(0);
        }
        try (GenericApplicationContext context = DataProfiler.createContext();){
            DataProfiler.initSxPools();
            DataSource dataSource = ((His1DataSources)context.getBean(His1DataSources.class)).get(database);
            DataProfiler profiler = new DataProfiler(dataSource, schema, tables);
            profiler.outputExcel(profiler.createStatistics(), null);
        }
    }

    public List<TableStatistic> createStatistics() {
        ArrayList<TableStatistic> tableStats = new ArrayList<TableStatistic>();
        try {
            JdbcTemplate jt = new JdbcTemplate(this.dataSource);
            logger.info((Object)("Database: " + this.database));
            logger.info((Object)("Schema: " + this.schema));
            logger.info((Object)("Tables: " + Arrays.asList(this.tables)));
            try (Connection con = this.dataSource.getConnection();){
                jt.execute("set search_path to " + this.schema);
                DatabaseMetaData meta = con.getMetaData();
                for (String table : this.tables) {
                    long rowCount = (Long)jt.queryForObject("select count(*) from " + table, Long.class);
                    TableStatistic tableStat = new TableStatistic(table, rowCount);
                    logger.info((Object)("Table " + table));
                    try (ResultSet columns = meta.getColumns(null, this.schema, table, null);
                         ResultSet exported = meta.getExportedKeys(null, this.schema, table);
                         ResultSet imported = meta.getImportedKeys(null, this.schema, table);
                         ResultSet pks = meta.getPrimaryKeys(null, this.schema, table);){
                        String toColumn;
                        String toTable;
                        String fromColumn;
                        while (columns.next()) {
                            final ColumnStatistic columnStat = new ColumnStatistic();
                            columnStat.name = columns.getString("COLUMN_NAME");
                            columnStat.size = columns.getInt("COLUMN_SIZE");
                            columnStat.decimalDigits = columns.getInt("DECIMAL_DIGITS");
                            columnStat.type = JDBCType.valueOf(columns.getInt("DATA_TYPE"));
                            columnStat.comment = columns.getString("REMARKS");
                            columnStat.isNullable = columns.getString("IS_NULLABLE").equalsIgnoreCase("yes");
                            columnStat.isAutoincrement = columns.getString("IS_AUTOINCREMENT").equalsIgnoreCase("yes");
                            columnStat.countNull = (Long)jt.queryForObject(String.format(SQL_COUNT_NULL, tableStat.name, columnStat.name), Long.class);
                            columnStat.percentNull = (double)columnStat.countNull / (double)tableStat.rowCount * 100.0;
                            jt.query(String.format(SQL_PERCENT_UNIQUE, columnStat.name, columnStat.name, tableStat.name), new RowCallbackHandler(){

                                public void processRow(ResultSet rs) throws SQLException {
                                    columnStat.uniqueCount = rs.getLong(1);
                                    columnStat.uniquePercent = rs.getDouble(2);
                                }
                            });
                            columnStat.ranking = jt.query(String.format(SQL_RANKING, columnStat.name, tableStat.name, columnStat.name, columnStat.name), (RowMapper)new RowMapper<RankingEntry>(){

                                public RankingEntry mapRow(ResultSet rs, int rowNum) throws SQLException {
                                    return new RankingEntry(rs.getString(1), rs.getInt(2));
                                }
                            });
                            switch (columnStat.type) {
                                case CHAR: 
                                case NCHAR: 
                                case VARCHAR: 
                                case NVARCHAR: 
                                case LONGVARCHAR: 
                                case LONGNVARCHAR: {
                                    jt.query(String.format(SQL_MIN_MAX_LEN, columnStat.name, columnStat.name, tableStat.name, columnStat.name), new RowCallbackHandler(){

                                        public void processRow(ResultSet rs) throws SQLException {
                                            columnStat.minLen = Optional.of(rs.getInt(1));
                                            columnStat.maxLen = Optional.of(rs.getInt(2));
                                        }
                                    });
                                    columnStat.min_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, "length(" + columnStat.name + ")", columnStat.minLen.get()), Integer.class));
                                    columnStat.max_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, "length(" + columnStat.name + ")", columnStat.maxLen.get()), Integer.class));
                                    break;
                                }
                                case BIGINT: 
                                case DECIMAL: 
                                case DOUBLE: 
                                case FLOAT: 
                                case INTEGER: 
                                case REAL: 
                                case NUMERIC: 
                                case SMALLINT: 
                                case TINYINT: {
                                    jt.query(String.format(SQL_MIN_MAX_AVG, columnStat.name, columnStat.name, columnStat.name, tableStat.name, columnStat.name), new RowCallbackHandler(){

                                        public void processRow(ResultSet rs) throws SQLException {
                                            columnStat.min = Optional.of(rs.getDouble(1));
                                            columnStat.max = Optional.of(rs.getDouble(2));
                                            columnStat.avg = Optional.of(rs.getDouble(3));
                                        }
                                    });
                                    columnStat.min_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, columnStat.min.get()), Integer.class));
                                    columnStat.max_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, columnStat.max.get()), Integer.class));
                                    break;
                                }
                                case DATE: {
                                    jt.query(String.format(SQL_START_END, columnStat.name, columnStat.name, tableStat.name, columnStat.name), new RowCallbackHandler(){

                                        public void processRow(ResultSet rs) throws SQLException {
                                            columnStat.earliestDate = Optional.ofNullable(rs.getDate(1));
                                            columnStat.latestDate = Optional.ofNullable(rs.getDate(2));
                                        }
                                    });
                                    if (columnStat.earliestDate.isPresent()) {
                                        columnStat.min_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, DataProfiler.quote(columnStat.earliestDate.get())), Integer.class));
                                    }
                                    if (!columnStat.latestDate.isPresent()) break;
                                    columnStat.max_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, DataProfiler.quote(columnStat.latestDate.get())), Integer.class));
                                    break;
                                }
                                case TIMESTAMP: 
                                case TIMESTAMP_WITH_TIMEZONE: {
                                    jt.query(String.format(SQL_START_END, columnStat.name, columnStat.name, tableStat.name, columnStat.name), new RowCallbackHandler(){

                                        public void processRow(ResultSet rs) throws SQLException {
                                            columnStat.earliestTimestamp = Optional.ofNullable(rs.getTimestamp(1));
                                            columnStat.latestTimestamp = Optional.ofNullable(rs.getTimestamp(2));
                                        }
                                    });
                                    if (columnStat.earliestTimestamp.isPresent()) {
                                        columnStat.min_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, DataProfiler.quote(columnStat.earliestTimestamp.get())), Integer.class));
                                    }
                                    if (!columnStat.latestTimestamp.isPresent()) break;
                                    columnStat.max_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, DataProfiler.quote(columnStat.latestTimestamp.get())), Integer.class));
                                    break;
                                }
                                case TIME: 
                                case TIME_WITH_TIMEZONE: {
                                    jt.query(String.format(SQL_START_END, columnStat.name, columnStat.name, tableStat.name, columnStat.name), new RowCallbackHandler(){

                                        public void processRow(ResultSet rs) throws SQLException {
                                            columnStat.earliestTime = Optional.ofNullable(rs.getTime(1));
                                            columnStat.latestTime = Optional.ofNullable(rs.getTime(2));
                                        }
                                    });
                                    if (columnStat.earliestTime.isPresent()) {
                                        columnStat.min_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, DataProfiler.quote(columnStat.earliestTime.get())), Integer.class));
                                    }
                                    if (!columnStat.latestTime.isPresent()) break;
                                    columnStat.max_count = Optional.of((Integer)jt.queryForObject(String.format(SQL_COUNT_VALUE, tableStat.name, columnStat.name, DataProfiler.quote(columnStat.latestTime.get())), Integer.class));
                                    break;
                                }
                            }
                            tableStat.columns.add(columnStat);
                        }
                        while (exported.next()) {
                            fromColumn = exported.getString("PKCOLUMN_NAME");
                            toTable = exported.getString("FKTABLE_NAME");
                            toColumn = exported.getString("FKCOLUMN_NAME");
                            tableStat.exportedKeys.add(new ForeignKey(fromColumn, toTable, toColumn));
                        }
                        while (imported.next()) {
                            fromColumn = imported.getString("FKCOLUMN_NAME");
                            toTable = imported.getString("PKTABLE_NAME");
                            toColumn = imported.getString("PKCOLUMN_NAME");
                            tableStat.importedKeys.add(new ForeignKey(fromColumn, toTable, toColumn));
                        }
                        while (pks.next()) {
                            String column = pks.getString("COLUMN_NAME");
                            tableStat.primaryKeys.add(column);
                        }
                    }
                    tableStats.add(tableStat);
                }
            }
        }
        catch (SQLException e) {
            logger.error((Object)"SQL Fehler", (Throwable)e);
        }
        return tableStats;
    }

    public void outputExcel(List<TableStatistic> tableStats, File outputFile) {
        XSSFWorkbook workbook = new XSSFWorkbook();
        XSSFDataFormat dataFormat = workbook.createDataFormat();
        XSSFCellStyle cellStyleDouble = workbook.createCellStyle();
        cellStyleDouble.setDataFormat(dataFormat.getFormat("0.##"));
        XSSFCellStyle headerStyle = workbook.createCellStyle();
        XSSFFont bold = workbook.createFont();
        bold.setBold(true);
        headerStyle.setFont((Font)bold);
        for (TableStatistic tableStat : tableStats) {
            XSSFSheet sheet = workbook.createSheet("Table " + tableStat.name);
            XSSFRow header = sheet.createRow(0);
            XSSFCell cell = header.createCell(0);
            cell.setCellValue("Database: " + this.database);
            cell.setCellStyle((CellStyle)headerStyle);
            cell = header.createCell(1);
            cell.setCellStyle((CellStyle)headerStyle);
            cell.setCellValue("Schema: " + this.schema);
            XSSFRow first = sheet.createRow(2);
            first.createCell(0).setCellValue("Table");
            first.getCell(0).setCellStyle((CellStyle)headerStyle);
            first.createCell(1).setCellValue("Row Count");
            first.getCell(1).setCellStyle((CellStyle)headerStyle);
            first.createCell(2).setCellValue("Column");
            first.getCell(2).setCellStyle((CellStyle)headerStyle);
            first.createCell(3).setCellValue("Type");
            first.getCell(3).setCellStyle((CellStyle)headerStyle);
            first.createCell(4).setCellValue("Size");
            first.getCell(4).setCellStyle((CellStyle)headerStyle);
            first.createCell(5).setCellValue("Not Null");
            first.getCell(5).setCellStyle((CellStyle)headerStyle);
            first.createCell(6).setCellValue("Autoincrement");
            first.getCell(6).setCellStyle((CellStyle)headerStyle);
            first.createCell(7).setCellValue("Count NULL");
            first.getCell(7).setCellStyle((CellStyle)headerStyle);
            first.createCell(8).setCellValue("% NULL");
            first.getCell(8).setCellStyle((CellStyle)headerStyle);
            first.createCell(9).setCellValue("Count Unique");
            first.getCell(9).setCellStyle((CellStyle)headerStyle);
            first.createCell(10).setCellValue("% Unique");
            first.getCell(10).setCellStyle((CellStyle)headerStyle);
            first.createCell(11).setCellValue("Min Len");
            first.getCell(11).setCellStyle((CellStyle)headerStyle);
            first.createCell(12).setCellValue("Max Len");
            first.getCell(12).setCellStyle((CellStyle)headerStyle);
            first.createCell(13).setCellValue("Min");
            first.getCell(13).setCellStyle((CellStyle)headerStyle);
            first.createCell(14).setCellValue("Max");
            first.getCell(14).setCellStyle((CellStyle)headerStyle);
            first.createCell(15).setCellValue("Avg");
            first.getCell(15).setCellStyle((CellStyle)headerStyle);
            first.createCell(16).setCellValue("Min Count");
            first.getCell(16).setCellStyle((CellStyle)headerStyle);
            first.createCell(17).setCellValue("Max Count");
            first.getCell(17).setCellStyle((CellStyle)headerStyle);
            first.createCell(18).setCellValue("Earliest");
            first.getCell(18).setCellStyle((CellStyle)headerStyle);
            first.createCell(19).setCellValue("Latest");
            first.getCell(19).setCellStyle((CellStyle)headerStyle);
            first.createCell(20).setCellValue("Comment");
            first.getCell(20).setCellStyle((CellStyle)headerStyle);
            int row = 3;
            XSSFRow tableRow = sheet.createRow(row);
            tableRow.createCell(0).setCellValue(tableStat.name);
            tableRow.getCell(0).setCellStyle((CellStyle)headerStyle);
            tableRow.createCell(1).setCellValue((double)tableStat.rowCount);
            tableRow.getCell(1).setCellStyle((CellStyle)headerStyle);
            for (ColumnStatistic columnStat : tableStat.columns) {
                XSSFRow descRow = sheet.createRow(++row);
                descRow.createCell(2).setCellValue(columnStat.name);
                if (tableStat.primaryKeys.contains(columnStat.name)) {
                    descRow.getCell(2).setCellValue(columnStat.name + " (PK)");
                    descRow.getCell(2).setCellStyle((CellStyle)headerStyle);
                }
                descRow.createCell(3).setCellValue(columnStat.type.getName());
                descRow.createCell(4).setCellValue((double)columnStat.size);
                if (columnStat.decimalDigits != 0) {
                    descRow.getCell(4).setCellValue(Double.valueOf(columnStat.size + "." + columnStat.decimalDigits).doubleValue());
                    descRow.getCell(4).setCellStyle((CellStyle)cellStyleDouble);
                }
                descRow.createCell(5).setCellValue(!columnStat.isNullable);
                descRow.createCell(6).setCellValue(columnStat.isAutoincrement);
                descRow.createCell(7).setCellValue((double)columnStat.countNull);
                descRow.createCell(8).setCellValue(columnStat.percentNull);
                descRow.getCell(8).setCellStyle((CellStyle)cellStyleDouble);
                descRow.createCell(9).setCellValue((double)columnStat.uniqueCount);
                descRow.createCell(10).setCellValue(columnStat.uniquePercent);
                descRow.getCell(10).setCellStyle((CellStyle)cellStyleDouble);
                if (columnStat.minLen.isPresent()) {
                    descRow.createCell(11).setCellValue(columnStat.minLen.get().doubleValue());
                }
                if (columnStat.maxLen.isPresent()) {
                    descRow.createCell(12).setCellValue(columnStat.maxLen.get().doubleValue());
                }
                if (columnStat.min.isPresent()) {
                    descRow.createCell(13).setCellValue(columnStat.min.get().doubleValue());
                    descRow.getCell(13).setCellStyle((CellStyle)cellStyleDouble);
                }
                if (columnStat.max.isPresent()) {
                    descRow.createCell(14).setCellValue(columnStat.max.get().doubleValue());
                    descRow.getCell(14).setCellStyle((CellStyle)cellStyleDouble);
                }
                if (columnStat.avg.isPresent()) {
                    descRow.createCell(15).setCellValue(columnStat.avg.get().doubleValue());
                    descRow.getCell(15).setCellStyle((CellStyle)cellStyleDouble);
                }
                if (columnStat.min_count.isPresent()) {
                    descRow.createCell(16).setCellValue(columnStat.min_count.get().doubleValue());
                    descRow.getCell(16).setCellStyle((CellStyle)cellStyleDouble);
                }
                if (columnStat.max_count.isPresent()) {
                    descRow.createCell(17).setCellValue(columnStat.max_count.get().doubleValue());
                    descRow.getCell(17).setCellStyle((CellStyle)cellStyleDouble);
                }
                if (columnStat.earliestDate.isPresent()) {
                    descRow.createCell(18).setCellValue(columnStat.earliestDate.get().toString());
                }
                if (columnStat.latestDate.isPresent()) {
                    descRow.createCell(19).setCellValue(columnStat.latestDate.get().toString());
                }
                if (columnStat.earliestTime.isPresent()) {
                    descRow.createCell(18).setCellValue(columnStat.earliestTime.get().toString());
                }
                if (columnStat.latestTime.isPresent()) {
                    descRow.createCell(19).setCellValue(columnStat.latestTime.get().toString());
                }
                if (columnStat.earliestTimestamp.isPresent()) {
                    descRow.createCell(18).setCellValue(columnStat.earliestTimestamp.get().toString());
                }
                if (columnStat.latestTimestamp.isPresent()) {
                    descRow.createCell(19).setCellValue(columnStat.latestTimestamp.get().toString());
                }
                descRow.createCell(20).setCellValue(columnStat.comment);
            }
            for (int i = 0; i < 20; ++i) {
                sheet.autoSizeColumn(i);
            }
            XSSFRow frequHeader1 = sheet.createRow(row + 2);
            XSSFRow frequHeader2 = sheet.createRow(row + 3);
            frequHeader1.createCell(0).setCellValue("Frequency");
            frequHeader1.getCell(0).setCellStyle((CellStyle)headerStyle);
            frequHeader2.createCell(0).setCellValue("Column");
            frequHeader2.getCell(0).setCellStyle((CellStyle)headerStyle);
            for (int n = 1; n <= 10; ++n) {
                frequHeader1.createCell(n).setCellValue((double)n);
                frequHeader1.getCell(n).setCellStyle((CellStyle)headerStyle);
            }
            for (int colNr = 0; colNr < tableStat.columns.size(); ++colNr) {
                XSSFRow frequRowLabel = sheet.createRow(row + 4 + 2 * colNr);
                XSSFRow frequRowCount = sheet.createRow(row + 5 + 2 * colNr);
                frequRowLabel.createCell(0).setCellValue(tableStat.columns.get((int)colNr).name);
                for (int rankNr = 0; rankNr < tableStat.columns.get((int)colNr).ranking.size(); ++rankNr) {
                    frequRowLabel.createCell(rankNr + 1).setCellValue(tableStat.columns.get((int)colNr).ranking.get((int)rankNr).label);
                    frequRowCount.createCell(rankNr + 1).setCellValue((double)tableStat.columns.get((int)colNr).ranking.get((int)rankNr).count);
                }
            }
            row = row + 2 * tableStat.columns.size() + 5;
            XSSFRow exHeader1 = sheet.createRow(row);
            exHeader1.createCell(0).setCellValue("Exported Keys");
            exHeader1.getCell(0).setCellStyle((CellStyle)headerStyle);
            XSSFRow exHeader2 = sheet.createRow(row + 1);
            exHeader2.createCell(0).setCellValue("From Column");
            exHeader2.getCell(0).setCellStyle((CellStyle)headerStyle);
            exHeader2.createCell(1).setCellValue("To Table");
            exHeader2.getCell(1).setCellStyle((CellStyle)headerStyle);
            exHeader2.createCell(2).setCellValue("To Column");
            exHeader2.getCell(2).setCellStyle((CellStyle)headerStyle);
            for (int fkNr = 0; fkNr < tableStat.exportedKeys.size(); ++fkNr) {
                XSSFRow fkRow = sheet.createRow(row + 2 + fkNr);
                fkRow.createCell(0).setCellValue(tableStat.exportedKeys.get((int)fkNr).fromColumn);
                fkRow.createCell(1).setCellValue(tableStat.exportedKeys.get((int)fkNr).toTable);
                fkRow.createCell(2).setCellValue(tableStat.exportedKeys.get((int)fkNr).toColumn);
            }
            row = row + 3 + tableStat.exportedKeys.size();
            XSSFRow imHeader1 = sheet.createRow(row);
            imHeader1.createCell(0).setCellValue("Imported Keys");
            imHeader1.getCell(0).setCellStyle((CellStyle)headerStyle);
            XSSFRow imHeader2 = sheet.createRow(row + 1);
            imHeader2.createCell(0).setCellValue("From Table");
            imHeader2.getCell(0).setCellStyle((CellStyle)headerStyle);
            imHeader2.createCell(1).setCellValue("From Column");
            imHeader2.getCell(1).setCellStyle((CellStyle)headerStyle);
            imHeader2.createCell(2).setCellValue("To Column");
            imHeader2.getCell(2).setCellStyle((CellStyle)headerStyle);
            for (int fkNr = 0; fkNr < tableStat.importedKeys.size(); ++fkNr) {
                XSSFRow fkRow = sheet.createRow(row + 2 + fkNr);
                fkRow.createCell(0).setCellValue(tableStat.importedKeys.get((int)fkNr).toTable);
                fkRow.createCell(1).setCellValue(tableStat.importedKeys.get((int)fkNr).toColumn);
                fkRow.createCell(2).setCellValue(tableStat.importedKeys.get((int)fkNr).fromColumn);
            }
        }
        File currDir = new File(".");
        String path = currDir.getAbsolutePath();
        Object fileLocation = path.substring(0, path.length() - 1) + "db_profile_" + this.database + ".xlsx";
        if (outputFile != null) {
            fileLocation = outputFile.getAbsolutePath();
        }
        logger.info((Object)("Writing to " + (String)fileLocation));
        try {
            FileOutputStream outputStream = new FileOutputStream((String)fileLocation);
            workbook.write((OutputStream)outputStream);
            workbook.close();
        }
        catch (IOException e) {
            logger.error((Object)"Couldn't write excel file", (Throwable)e);
        }
    }

    private static Options createOptions() {
        Options options = new Options();
        Option opt = new Option("h", "help", false, "get help");
        options.addOption(opt);
        opt = new Option("t", "tables", true, "tables");
        opt.setArgs(-2);
        options.addOption(opt);
        opt = new Option("s", "schema", true, "schema");
        options.addOption(opt);
        opt = new Option("d", "database", true, "database");
        options.addOption(opt);
        return options;
    }

    private static CommandLine parseArgs(String[] args, Options options) {
        GnuParser parser = new GnuParser();
        try {
            return parser.parse(options, args, false);
        }
        catch (ParseException e) {
            System.out.println("error while reading the command line parameters:");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static void initSxPools() {
        try {
            LinkedList<String> mandantenNamen = new LinkedList<String>();
            mandantenNamen.add(SxSQL_Server.DEFAULT_MANDANTEN_ID);
            SxPools.closeAll();
            SxPools.init(mandantenNamen);
            SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID).init();
            SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID).initLogging(true, Level.DEBUG);
            SuperXManager.initKettleEnv((ApplicationContext)APPLICATION_CONTEXT);
        }
        catch (Exception e) {
            System.out.println("error while initialising the SuperX pools:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(HELP_STRING, options);
    }

    private static GenericApplicationContext createContext() {
        if (APPLICATION_CONTEXT == null) {
            APPLICATION_CONTEXT = new AnnotationConfigApplicationContext(new Class[]{BatchConfig.class, DataJdbcConfiguration.class, CLIConfig.class, ServiceConfig.class});
        }
        return APPLICATION_CONTEXT;
    }

    private static String quote(Object o) {
        return "'" + o + "'";
    }
}

