/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bin;

import de.superx.job.ContainerNode;
import de.superx.rest.EtlJobApi;
import de.superx.rest.model.job.Component;
import de.superx.rest.model.job.JobExecutionStatus;
import de.superx.servlet.SuperXManager;
import de.superx.servlet.SxPools;
import de.superx.servlet.SxSQL_Server;
import de.superx.spring.HisInOneConfiguration;
import de.superx.spring.batch.His1DataSources;
import de.superx.spring.cli.config.CLIConfig;
import de.superx.spring.config.BatchConfig;
import de.superx.spring.config.DataJdbcConfiguration;
import de.superx.spring.config.ServiceConfig;
import de.superx.spring.service.BatchJobDescriptionAdapter;
import de.superx.spring.service.EntityJobDescriptionSource;
import de.superx.util.PathAndFileUtils;
import java.io.File;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.GnuParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.AnnotationConfigApplicationContext;
import org.springframework.context.support.GenericApplicationContext;

public class ComponentAdminCLI {
    private static GenericApplicationContext APPLICATION_CONTEXT = null;
    private static String HELP_STRING = "Use this tool to run component actions via command line. It needs the config file 'his1_databases.properties' inside the classpath; this file gets written automatically when starting the web application.";
    private static boolean FILESYSTEM = false;
    static Logger logger = Logger.getLogger(ComponentAdminCLI.class);

    public static void main(String[] args) {
        System.setProperty("SuperX-HISinOne-VERSION", "non-empty-value");
        Options options = ComponentAdminCLI.createOptions();
        CommandLine parsedArgs = ComponentAdminCLI.parseArgs(args, options);
        ComponentAdminCLI.logOptions(parsedArgs);
        if (parsedArgs.hasOption("h")) {
            ComponentAdminCLI.printHelp(options);
            System.exit(0);
        }
        if (parsedArgs.hasOption("f")) {
            FILESYSTEM = true;
        }
        ComponentAdminCLI.initSuperXManager();
        if (parsedArgs.hasOption("s")) {
            ComponentAdminCLI.initTablesForEmptyDB();
        }
        if (parsedArgs.hasOption("lg")) {
            ComponentAdminCLI.setBatchLoggerToOneFile();
        }
        SuperXManager.initKettleEnv((ApplicationContext)ComponentAdminCLI.createContext());
        if (parsedArgs.hasOption("la")) {
            ComponentAdminCLI.printAllJobs();
        } else if (parsedArgs.hasOption("li")) {
            ComponentAdminCLI.printInstallableJobs();
        } else if (parsedArgs.hasOption("le")) {
            ComponentAdminCLI.printEtlJobs();
        } else if (parsedArgs.hasOption("i")) {
            ComponentAdminCLI.installComponents(parsedArgs);
        } else if (parsedArgs.hasOption("d")) {
            ComponentAdminCLI.deinstallComponent(parsedArgs);
        } else if (parsedArgs.hasOption("u")) {
            ComponentAdminCLI.upgradeComponents(parsedArgs);
        } else if (parsedArgs.hasOption("ua")) {
            ComponentAdminCLI.upgradeAll();
        } else if (parsedArgs.hasOption("e")) {
            ComponentAdminCLI.etlJobs(parsedArgs);
        } else if (parsedArgs.hasOption("r")) {
            ComponentAdminCLI.reloadModule();
        } else if (parsedArgs.hasOption("if")) {
            ComponentAdminCLI.installFunctions(parsedArgs);
        } else {
            ComponentAdminCLI.printHelp(options);
        }
    }

    private static void logOptions(CommandLine parsedArgs) {
        logger.info((Object)"Starting  with the following options:");
        for (Option opt : parsedArgs.getOptions()) {
            logger.info((Object)opt);
            if (opt.getValues() == null || opt.getValues().length <= 0) continue;
            logger.info((Object)("Values for option " + opt.getOpt() + ": " + Arrays.asList(opt.getValues())));
        }
    }

    private static void initTablesForEmptyDB() {
        try {
            GenericApplicationContext context = ComponentAdminCLI.createContext();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            ContainerNode root = EntityJobDescriptionSource.getPreKernInstallJob();
            componentApi.executeJob("eduetl", root);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void setBatchLoggerToOneFile() {
        try {
            GenericApplicationContext context = ComponentAdminCLI.createContext();
            BatchJobDescriptionAdapter bjda = (BatchJobDescriptionAdapter)context.getBean(BatchJobDescriptionAdapter.class);
            bjda.setLogJobToFile(false);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void installComponents(CommandLine parsedArgs) {
        String[] components = parsedArgs.getOptionValues("i");
        String currentComp = null;
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            for (String comp : components) {
                try {
                    currentComp = comp;
                    Long jobStartStatus = -1L;
                    if (!FILESYSTEM) {
                        logger.info((Object)"EXECUTING: install job from database");
                        jobStartStatus = componentApi.executeInstall(comp);
                    } else {
                        logger.info((Object)("EXECUTING: install job from filesystem for " + currentComp));
                        jobStartStatus = componentApi.executeInstallForQAMuster(comp);
                        logger.info((Object)("EXECUTING: workaround upgrade job from filesystem for " + currentComp));
                        jobStartStatus = componentApi.executeUpgradeForQAMuster(comp);
                    }
                    ComponentAdminCLI.handleStartResult(jobStartStatus, componentApi);
                    if (!comp.equals("kern") || !FILESYSTEM) continue;
                    DataSource dataSource = ((His1DataSources)context.getBean(His1DataSources.class)).get("eduetl");
                    SuperXManager.setWebInfFilePath(dataSource);
                }
                catch (Exception e) {
                    logger.error((Object)("ERROR installing component " + comp), (Throwable)e);
                }
            }
        }
        catch (BeansException be) {
            ComponentAdminCLI.handleBeansException(be);
        }
        catch (Exception e) {
            ComponentAdminCLI.handleJobException(e, currentComp);
        }
    }

    private static void reloadModule() {
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            ComponentAdminCLI.initSuperXManager();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            componentApi.writeJobsToDb();
        }
    }

    private static void printHelp(Options options) {
        HelpFormatter help = new HelpFormatter();
        help.printHelp(HELP_STRING, options);
    }

    private static void printInstallableJobs() {
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            List<Component> installJobs = componentApi.getInstallJobs();
            for (Component comp : installJobs) {
                ComponentAdminCLI.printDetails(comp);
                System.out.println();
            }
        }
    }

    private static void printEtlJobs() {
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            List<Component> etlJobs = componentApi.getEtlJobs();
            for (Component etlJob : etlJobs) {
                ComponentAdminCLI.printDetails(etlJob);
                System.out.println();
            }
        }
    }

    private static void printDetails(Component comp) {
        System.out.println("abbrev:        " + comp.getAbbreviation());
        System.out.println("name:          " + comp.getName());
        System.out.println("database:      " + comp.getDatabase());
        System.out.println("systeminfo_id: " + comp.getSysteminfoId());
        System.out.println("installed:     " + comp.isInstalled());
    }

    private static void deinstallComponent(CommandLine parsedArgs) {
        String comp = parsedArgs.getOptionValue("d");
        System.out.println(comp);
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            Long jobStartStatus = componentApi.executeUninstall(comp);
            ComponentAdminCLI.handleStartResult(jobStartStatus, componentApi);
        }
        catch (BeansException be) {
            ComponentAdminCLI.handleBeansException(be);
        }
        catch (Exception e) {
            ComponentAdminCLI.handleJobException(e, comp);
        }
    }

    private static void upgradeComponents(CommandLine parsedArgs) {
        String[] components = parsedArgs.getOptionValues("u");
        String currentComp = null;
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            String[] stringArray = components;
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                String comp;
                currentComp = comp = stringArray[i];
                Long jobStartStatus = componentApi.executeUpgrade(comp);
                if (jobStartStatus == -1L) {
                    logger.warn((Object)(comp + " not installed. Skipping upgrade."));
                    continue;
                }
                ComponentAdminCLI.handleStartResult(jobStartStatus, componentApi);
            }
        }
        catch (BeansException be) {
            ComponentAdminCLI.handleBeansException(be);
        }
        catch (Exception e) {
            ComponentAdminCLI.handleJobException(e, currentComp);
        }
    }

    private static void installFunctions(CommandLine parsedArgs) {
        String[] components = parsedArgs.getOptionValues("if");
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            if (components.length == 1 && "all".equals(components[0])) {
                List<Component> installedComponents = componentApi.getInstallJobs();
                components = installedComponents.stream().map(c -> c.getAbbreviation()).collect(Collectors.toList()).toArray(new String[0]);
            }
            boolean exitFailure = false;
            for (String comp : components) {
                componentApi.installModuleFunctions(comp);
            }
            if (exitFailure) {
                System.out.println("Beim Ausf\u00fchren einer Aktion ist ein Fehler aufgetreten:");
                System.exit(1);
            }
        }
        catch (BeansException be) {
            ComponentAdminCLI.handleBeansException(be);
        }
    }

    private static void upgradeAll() {
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            Long jobStartStatus = componentApi.executeUpgradeAll();
            ComponentAdminCLI.handleStartResult(jobStartStatus, componentApi);
        }
        catch (BeansException be) {
            ComponentAdminCLI.handleBeansException(be);
        }
        catch (Exception e) {
            ComponentAdminCLI.handleJobException(e, null);
        }
    }

    private static void etlJobs(CommandLine parsedArgs) {
        String[] jobIds = parsedArgs.getOptionValues("e");
        String currentJobId = null;
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            ComponentAdminCLI.initSxPools();
            EtlJobApi componentApi = (EtlJobApi)context.getBean(EtlJobApi.class);
            for (String jobId : jobIds) {
                try {
                    currentJobId = jobId;
                    Long jobStartStatus = ComponentAdminCLI.isHauptladeroutine(jobId, componentApi) ? componentApi.complete(jobId) : (ComponentAdminCLI.isLoadTransform(jobId, componentApi) ? componentApi.load(jobId) : componentApi.executeJob(null, jobId));
                    ComponentAdminCLI.handleStartResult(jobStartStatus, componentApi);
                }
                catch (Exception e) {
                    logger.error((Object)("ERROR executing job " + jobId), (Throwable)e);
                }
            }
        }
        catch (BeansException be) {
            ComponentAdminCLI.handleBeansException(be);
        }
        catch (Exception e) {
            ComponentAdminCLI.handleJobException(e, currentJobId);
        }
    }

    private static void handleStartResult(Long jobStartStatus, EtlJobApi componentApi) {
        if (jobStartStatus.intValue() == -1) {
            System.err.println("Aktion konnte nicht gestartet werden: Es l\u00e4uft bereits eine Aktion");
        }
        try {
            JobExecutionStatus es = componentApi.getStatus(jobStartStatus);
            if ("FAILED".equals(es.exitStatus.getExitCode())) {
                EtlJobApi.outputErrorSummary(es, System.err);
            }
        }
        catch (Exception e) {
            System.err.println("Beim Ausf\u00fchren der Aktion ist ein Fehler aufgetreten:");
            e.printStackTrace();
        }
    }

    private static void handleJobException(Exception e, String jobName) {
        System.err.println("error while executing the job '" + jobName + "'");
        e.printStackTrace();
    }

    private static void handleBeansException(BeansException be) {
        System.err.println("configuration error or error with resolving the bean '" + EtlJobApi.class.getCanonicalName() + "'");
        be.printStackTrace();
    }

    private static boolean isHauptladeroutine(String comp, EtlJobApi etlJob) {
        List<Component> installJobs = etlJob.getEtlJobs();
        for (Component comp_meta : installJobs) {
            if (comp_meta == null || !comp_meta.getAbbreviation().equals(comp) || !comp_meta.isDatabaseConnected()) continue;
            return true;
        }
        return false;
    }

    private static boolean isLoadTransform(String comp, EtlJobApi etlJob) {
        List<Component> installJobs = etlJob.getEtlJobs();
        for (Component comp_meta : installJobs) {
            if (comp_meta == null || !comp_meta.getAbbreviation().equals(comp) || comp_meta.isDatabaseConnected()) continue;
            return true;
        }
        return false;
    }

    private static void printAllJobs() {
        try (GenericApplicationContext context = ComponentAdminCLI.createContext();){
            EtlJobApi etlJob = (EtlJobApi)context.getBean(EtlJobApi.class);
            List<ContainerNode> allJobs = etlJob.getAllJobs();
            for (ContainerNode cn : allJobs) {
                ComponentAdminCLI.printDetails(cn);
                System.out.println();
            }
        }
    }

    private static GenericApplicationContext createContext() {
        if (APPLICATION_CONTEXT == null) {
            APPLICATION_CONTEXT = new AnnotationConfigApplicationContext(new Class[]{BatchConfig.class, DataJdbcConfiguration.class, CLIConfig.class, ServiceConfig.class});
            HisInOneConfiguration.configSuperXDbformsXML("pg", SuperXManager.getWEB_INFPfad() + File.separator + "..");
        }
        if (FILESYSTEM) {
            EtlJobApi etlJob = (EtlJobApi)APPLICATION_CONTEXT.getBean(EtlJobApi.class);
            EntityJobDescriptionSource entityJobDescriptionSource = (EntityJobDescriptionSource)APPLICATION_CONTEXT.getBean(EntityJobDescriptionSource.class);
            etlJob.setJobDescriptionSource(entityJobDescriptionSource);
        }
        return APPLICATION_CONTEXT;
    }

    private static void printDetails(ContainerNode cn) {
        System.out.println("id:            " + cn.id);
        System.out.println("name:          " + cn.name);
        System.out.println("systeminfo_id: " + cn.systemInfoId);
        System.out.println("tid:           " + cn.tid);
        System.out.println("type:          " + cn.type);
    }

    private static Options createOptions() {
        Options options = new Options();
        Option opt = new Option("h", "help", false, "get help");
        options.addOption(opt);
        opt = new Option("f", "filesystem", false, "load jobs from filesystem");
        options.addOption(opt);
        opt = new Option("s", "setup", false, "setup minimal list of tables necessary for kern install");
        options.addOption(opt);
        opt = new Option("la", "list-all", false, "list all available components");
        options.addOption(opt);
        opt = new Option("li", "list-installables", false, "list all installable components");
        options.addOption(opt);
        opt = new Option("le", "list-etl", false, "list all etl components");
        options.addOption(opt);
        opt = new Option("i", "install", true, "install components");
        opt.setArgs(-2);
        options.addOption(opt);
        opt = new Option("if", "install-functions", true, "install database functions for components (use 'all' to install functions for all installed components)");
        options.addOption(opt);
        opt.setArgs(-2);
        opt = new Option("d", "deinstall", true, "de-/uninstall component");
        options.addOption(opt);
        opt = new Option("u", "upgrade", true, "upgrade components");
        opt.setArgs(-2);
        options.addOption(opt);
        opt = new Option("ua", "upgrade-all", false, "upgrade all installed components");
        options.addOption(opt);
        opt = new Option("e", "etl", true, "run etl jobs");
        opt.setArgs(-2);
        options.addOption(opt);
        opt = new Option("r", "reload-modules", false, "reload modules");
        options.addOption(opt);
        opt = new Option("db", "database", true, "database system");
        options.addOption(opt);
        opt = new Option("lg", "log-to-stdout", false, "log only to stdout and not to individual job files");
        options.addOption(opt);
        return options;
    }

    private static CommandLine parseArgs(String[] args, Options options) {
        GnuParser parser = new GnuParser();
        try {
            return parser.parse(options, args, false);
        }
        catch (ParseException e) {
            System.out.println("error while reading the command line parameters:");
            e.printStackTrace();
            System.exit(1);
            return null;
        }
    }

    private static void initSuperXManager() {
        try {
            SuperXManager.setWEB_INFPfad(PathAndFileUtils.getWebinfPath());
            SuperXManager.setModuleDir(PathAndFileUtils.getWebinfPath() + File.separator + PathAndFileUtils.MODULE_PATH);
        }
        catch (Exception e) {
            System.out.println("error while initialising the SuperXManger:");
            e.printStackTrace();
            System.exit(1);
        }
    }

    private static void initSxPools() {
        try {
            LinkedList<String> mandantenNamen = new LinkedList<String>();
            mandantenNamen.add(SxSQL_Server.DEFAULT_MANDANTEN_ID);
            SxPools.closeAll();
            SxPools.init(mandantenNamen);
            SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID).init();
            SxPools.get(SxSQL_Server.DEFAULT_MANDANTEN_ID).initLogging(true, Level.DEBUG);
            SuperXManager.initKettleEnv((ApplicationContext)APPLICATION_CONTEXT);
        }
        catch (Exception e) {
            System.out.println("error while initialising the SuperX pools:");
            e.printStackTrace();
            System.exit(1);
        }
    }
}

