/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.sqlgeneration;

import de.superx.bianalysis.ColumnElement;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.Measure;
import java.util.List;
import java.util.StringJoiner;

public class SQLGenerator {
    public ReportMetadata reportMetadata;
    public List<ColumnElement> columnElements;
    public char formatSql = (char)32;
    private static final String HIERARCHY_MODEL_SUFFIX = "_hierarchy";

    public SQLGenerator(ReportMetadata reportMetadata, List<ColumnElement> columnElements) {
        this.reportMetadata = reportMetadata;
        this.columnElements = columnElements;
    }

    public SQLGenerator(ReportMetadata reportMetadata) {
        this.reportMetadata = reportMetadata;
    }

    public String buildFormattedSqlStatement() {
        this.formatSql = (char)10;
        return this.buildSqlStatement();
    }

    public String buildSqlStatement() {
        StringBuilder statement = new StringBuilder();
        statement.append("SELECT ");
        statement.append(this.buildSelectSection());
        statement.append(this.formatSql + "FROM presentation." + this.reportMetadata.factTable.getTablename());
        statement.append(this.buildJoinSection());
        statement.append(this.buildFilterSection());
        statement.append(this.buildGroupBySection());
        statement.append(this.buildOrderBySection());
        return statement.toString();
    }

    public String buildSelectSection() {
        StringJoiner columns = new StringJoiner(", ");
        String dimensionAttributesStatement = this.selectDimensionAttributes();
        if (dimensionAttributesStatement != null && !dimensionAttributesStatement.isBlank()) {
            columns.add(dimensionAttributesStatement);
        }
        StringJoiner measuresStatementJoiner = new StringJoiner(", ");
        this.columnElements.forEach(columnElement -> measuresStatementJoiner.add(this.selectMeasure((ColumnElement)columnElement)));
        String measuresStatement = measuresStatementJoiner.toString();
        if (measuresStatement != null && !measuresStatement.isBlank()) {
            columns.add(measuresStatement);
        }
        return columns.toString();
    }

    public String selectDimensionAttributes() {
        if (this.reportMetadata.leftDimensionAttributes == null) {
            return null;
        }
        StringJoiner columns = new StringJoiner(", ");
        for (DimensionAttribute attribute : this.reportMetadata.leftDimensionAttributes) {
            String columnName = attribute.getColumnname();
            String tableAlias = attribute.getDimensionTableAlias();
            String columnAlias = attribute.getDimensionColumnAlias();
            if (attribute.isHierarchy()) {
                StringBuilder resultBuilder = new StringBuilder();
                for (int i = this.reportMetadata.minBridgeLvl; i < this.reportMetadata.maxBridgeLvl; ++i) {
                    resultBuilder.append(attribute.getDimensionTableAlias()).append(".ancestor_").append(columnName).append('[').append(i + 1).append(']').append(" AS \"col").append(i).append("\"");
                    if (i >= this.reportMetadata.maxBridgeLvl - 1) continue;
                    resultBuilder.append(", ");
                }
                columns.add(resultBuilder.toString());
                continue;
            }
            columns.add(String.format("%s.%s AS %s", tableAlias, columnName, columnAlias));
            String sortOrderColumn = attribute.getSortOrderColumn();
            if (sortOrderColumn == null) continue;
            columns.add(String.format("%s.%s AS %s_%s", tableAlias, sortOrderColumn, columnAlias, sortOrderColumn));
        }
        return columns.toString();
    }

    public String getMeasureTablePart(String factTableTablename, Measure measure, List<DimensionAttribute> dimensionAttributes) {
        Object result = "";
        String tableCol = factTableTablename + "." + measure.getColumnname();
        if (measure.getAggregationType().equals("sum")) {
            result = "SUM(" + tableCol + ")";
        } else if (measure.getAggregationType().equals("count")) {
            result = "COUNT(" + tableCol + ")";
        } else if (measure.getAggregationType().equals("distinct-count")) {
            result = "COUNT(distinct(" + tableCol + "))";
        } else if (measure.getAggregationType().equals("avg")) {
            result = "AVG(" + tableCol + ")";
        } else if (measure.getAggregationType().equals("min")) {
            result = "MIN(" + tableCol + ")";
        } else if (measure.getAggregationType().equals("max")) {
            result = "MAX(" + tableCol + ")";
        } else if (measure.getAggregationType().equals("std")) {
            result = "STDDEV_SAMP(" + tableCol + ")";
        } else if (measure.getAggregationType().equals("var")) {
            result = "VAR_SAMP(" + tableCol + ")";
        }
        return result;
    }

    public String selectMeasure(ColumnElement columnElement) {
        String factTableTablename = this.reportMetadata.factTable.getTablename();
        StringBuilder measureSelect = new StringBuilder();
        Measure measure = columnElement.measure;
        measureSelect.append(this.getMeasureTablePart(factTableTablename, measure, this.reportMetadata.leftDimensionAttributes));
        if (measure.filterCondition != null) {
            measureSelect.append(this.formatSql + "FILTER (WHERE " + measure.filterCondition);
            if (columnElement.dimensionAttributeFilter != null) {
                measureSelect.append(" AND " + columnElement.dimensionAttributeFilter);
            }
            measureSelect.append(")");
        } else if (columnElement.dimensionAttributeFilter != null) {
            measureSelect.append(this.formatSql + "FILTER (WHERE " + columnElement.dimensionAttributeFilter + ")");
        }
        if (measureSelect.length() != 0) {
            measureSelect.append(" AS \"col" + columnElement.columnNumber + "\"");
        }
        return measureSelect.toString();
    }

    public String buildJoinSection() {
        StringBuilder statement = new StringBuilder();
        for (DimensionAttribute attr : this.reportMetadata.getUniqueDimensionAttributes()) {
            String joinColumn = "id";
            if (attr.getDimIdJoinColumn() != null && !attr.getDimIdJoinColumn().isBlank()) {
                joinColumn = attr.getDimIdJoinColumn();
            }
            Object dimensionTable = attr.getTablename();
            boolean isTopAttribute = this.reportMetadata.topDimensionAttributes.contains(attr);
            if (attr.isHierarchy() && !isTopAttribute) {
                dimensionTable = (String)dimensionTable + HIERARCHY_MODEL_SUFFIX;
            }
            String join = String.format(" JOIN presentation.%s AS %s ON %s.%s = %s.%s", dimensionTable, attr.getDimensionTableAlias(), this.reportMetadata.factTable.getTablename(), attr.getJoincolumn(), attr.getDimensionTableAlias(), joinColumn);
            statement.append(join);
            if (!attr.isHistorical()) continue;
            String currentFilter = String.format(" AND %s.is_current = true ", attr.getDimensionTableAlias());
            statement.append(currentFilter);
        }
        return statement.toString();
    }

    public String buildFilterSection() {
        if (this.reportMetadata.filters == null || this.reportMetadata.filters.size() <= 0) {
            return "";
        }
        StringBuilder statement = new StringBuilder(" WHERE ");
        StringJoiner groups = new StringJoiner(" AND ");
        for (Filter filter : this.reportMetadata.filters) {
            if (this.reportMetadata.isHierarchyFilter(filter)) {
                StringBuilder resultBuilder = new StringBuilder();
                for (int i = this.reportMetadata.minBridgeLvl; i < this.reportMetadata.maxBridgeLvl; ++i) {
                    resultBuilder.append(filter.joincolumn).append(".ancestor_").append(filter.columnname).append('[').append(i).append("] IN (").append(filter.getValues()).append(')');
                    if (i >= this.reportMetadata.maxBridgeLvl - 1) continue;
                    resultBuilder.append(" OR ");
                }
                groups.add(resultBuilder.toString());
                continue;
            }
            groups.add(filter.dimensionTableAlias + "." + filter.columnname + " IN (" + filter.getValues() + ")");
        }
        statement.append(groups.toString());
        if (groups.length() == 0) {
            return "";
        }
        return statement.toString();
    }

    public String buildGroupBySection() {
        if (this.reportMetadata.leftDimensionAttributes == null || this.reportMetadata.leftDimensionAttributes.size() <= 0) {
            return "";
        }
        StringBuilder statement = new StringBuilder("GROUP BY ROLLUP (");
        StringJoiner groups = new StringJoiner(", ");
        for (DimensionAttribute attr : this.reportMetadata.leftDimensionAttributes) {
            if (attr.isHierarchy()) {
                int numOfHierarchyAttributes = this.reportMetadata.getHierarchyAttributes().size();
                for (int i = 0; i < numOfHierarchyAttributes; ++i) {
                    for (int j = 0; j < this.reportMetadata.maxBridgeLvl; ++j) {
                        if (j < this.reportMetadata.minBridgeLvl) continue;
                        groups.add("col" + (j + i * this.reportMetadata.maxBridgeLvl));
                    }
                }
                continue;
            }
            groups.add(attr.getDimensionTableAlias() + "." + attr.getColumnname());
            if (attr.getSortOrderColumn() == null) continue;
            groups.add(attr.getDimensionTableAlias() + "." + attr.getSortOrderColumn());
        }
        statement.append(groups.toString());
        if (groups.length() == 0) {
            return "";
        }
        statement.append(")");
        return this.formatSql + statement.toString();
    }

    public StringJoiner buildOrderBySection() {
        StringJoiner orderCols = new StringJoiner(", ", " ORDER BY ", "");
        orderCols.setEmptyValue("");
        for (DimensionAttribute attr : this.reportMetadata.leftDimensionAttributes) {
            if (attr.isHierarchy()) {
                for (int i = this.reportMetadata.minBridgeLvl; i < this.reportMetadata.maxBridgeLvl; ++i) {
                    orderCols.add("col" + i);
                }
                continue;
            }
            if (attr.getSortOrderColumn() != null) {
                orderCols.add(attr.getDimensionTableAlias() + "." + attr.getSortOrderColumn());
                continue;
            }
            orderCols.add(attr.getDimensionColumnAlias());
        }
        return orderCols;
    }
}

