/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.service;

import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.ReportDefinition;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.StoredReport;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.FactTable;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.Measure;
import de.superx.bianalysis.repository.DimensionAttributeRepository;
import de.superx.bianalysis.repository.DimensionRepository;
import de.superx.bianalysis.repository.FactRepository;
import de.superx.bianalysis.repository.MeasureFilterRepository;
import de.superx.bianalysis.repository.MeasureRepository;
import de.superx.bianalysis.repository.StoredReportRepository;
import de.superx.bianalysis.repository.dto.AttributeDto;
import de.superx.bianalysis.repository.dto.DimensionDto;
import de.superx.bianalysis.repository.dto.FactDto;
import de.superx.bianalysis.repository.dto.MeasureDto;
import de.superx.bianalysis.repository.dto.MeasureFilterDto;
import de.superx.common.NotYetImplementedException;
import de.superx.jdbc.entity.Sachgebiet;
import de.superx.jdbc.entity.Systeminfo;
import de.superx.jdbc.repository.SachgebieteRepository;
import de.superx.jdbc.repository.SysteminfoRepository;
import java.lang.invoke.CallSite;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import javax.sql.DataSource;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Service;

@Service
public class DbMetaAdapter
implements InitializingBean {
    @Autowired
    FactRepository factRepository;
    @Autowired
    MeasureRepository measureRepository;
    @Autowired
    DimensionRepository dimensionRepository;
    @Autowired
    DimensionAttributeRepository dimensionAttrRepo;
    @Autowired
    MeasureFilterRepository measureFilterRepo;
    @Autowired
    StoredReportRepository storedReportRepository;
    @Autowired
    SachgebieteRepository sachgebieterepository;
    @Autowired
    SysteminfoRepository systeminfoRepository;
    @Autowired
    DataSource dataSource;
    private JdbcTemplate jt;

    public void afterPropertiesSet() throws Exception {
        this.jt = new JdbcTemplate(this.dataSource);
    }

    public List<FactTable> getFactTables(List<Integer> sachgebieteTids, List<Identifier> facts) throws NotYetImplementedException {
        try {
            List<FactTable> factTables = this.factRepository.findAll().stream().filter(f -> this.getSachgebietForFacttable((int)f.sachgebiettid.intValue()).tid != -1).filter(f -> sachgebieteTids.isEmpty() || sachgebieteTids.contains((int)f.sachgebiettid)).filter(f -> facts.isEmpty() || facts.contains(f.id) || !this.hasSachgebietTopicRestrictions(facts, f.sachgebiettid)).map(f -> {
                FactTable fact = new FactTable((FactDto)f);
                fact.setSachgebiet(this.getSachgebietForFacttable(f.sachgebiettid));
                fact.setConformedDimensions(this.getConformedDimensionsForFacttable(f.id));
                return fact;
            }).collect(Collectors.toList());
            return factTables;
        }
        catch (Exception e) {
            e.printStackTrace();
            if (e.getCause().getMessage().contains("FEHLER: Relation \u00bbmetadata.facttable\u00ab existiert nicht")) {
                throw new NotYetImplementedException("Bitte installieren Sie zuerst die Komponente 'BI-Analyse-Daten' und f\u00fchren Sie anschlie\u00dfend den Konnektor aus.");
            }
            throw e;
        }
    }

    private boolean hasSachgebietTopicRestrictions(List<Identifier> facts, int tid) {
        for (Identifier factId : facts) {
            if (this.getFactTable(factId).getSachgebiettid() != tid) continue;
            return true;
        }
        return false;
    }

    public List<Dimension> getConformedDimensionsForFacttable(Identifier factId) {
        ArrayList<Dimension> conformedDimension = new ArrayList<Dimension>();
        List<Identifier> ids = this.dimensionRepository.getUsedConformedDimensionsByFactTable(factId.composedId);
        for (Identifier id : ids) {
            Dimension dimension = this.getDimension(id);
            List<DimensionAttribute> attributes = this.getAttributesOfDimension(dimension.getId());
            dimension.setDimensionAttributes(attributes);
            for (DimensionAttribute a : attributes) {
                a.setDimension(dimension);
            }
            conformedDimension.add(this.getDimension(id));
        }
        return conformedDimension;
    }

    public List<DimensionAttribute> getDimensionAttributeMetadata(List<Identifier> attributeIds, Identifier factId) {
        if (attributeIds == null || attributeIds.size() <= 0) {
            return null;
        }
        ArrayList<DimensionAttribute> result = new ArrayList<DimensionAttribute>();
        for (Identifier id : attributeIds) {
            Optional<AttributeDto> optAttributeConf;
            Identifier rpId;
            Optional<AttributeDto> optAttribute = this.dimensionAttrRepo.findById(id);
            if (optAttribute.isEmpty()) {
                throw new FaultyMetadataException(id, "Attribute");
            }
            DimensionAttribute attr = new DimensionAttribute(optAttribute.get());
            Dimension dim = null;
            if (factId != null && (rpId = this.getRolePlayingDimensionWithNoAttributes(id.composedId, factId.composedId)) != null) {
                dim = this.getDimension(rpId);
            }
            if (dim == null) {
                dim = this.getDimension(attr.getDimensionId());
            }
            attr.setDimension(dim);
            if (attr.getAttrConformedId() != null && (optAttributeConf = this.dimensionAttrRepo.findById(new Identifier(attr.getAttrConformedId()))).isPresent()) {
                Dimension dimConf = this.getDimension(optAttributeConf.get().dimensionId);
                attr.setDimConformedId(dimConf.getId().composedId);
            }
            result.add(attr);
        }
        return result;
    }

    public List<Measure> getMeasureMetadata(List<Identifier> measureIds) {
        if (measureIds != null && measureIds.size() > 0) {
            ArrayList<Measure> result = new ArrayList<Measure>();
            for (Identifier id : measureIds) {
                Measure measure = this.getMeasure(id);
                if (measure.getMeasureFilterId() != null) {
                    MeasureFilterDto filter = (MeasureFilterDto)this.measureFilterRepo.findById(measure.getMeasureFilterId()).get();
                    if (filter.dimensionAttributeId != null) {
                        DimensionAttribute attribute = this.getDimensionAttributeById(filter.dimensionAttributeId);
                        Dimension dimension = this.getDimension(attribute.getDimensionId());
                        measure.setMeasureFilterAttributes(filter, attribute, dimension);
                    } else if (filter.factColumnFilter != null) {
                        measure.setFactColumnFilter(filter);
                    }
                }
                result.add(measure);
            }
            return result;
        }
        return null;
    }

    public List<Dimension> getDimensions(Identifier factTableId) {
        ArrayList<Dimension> dimensions = new ArrayList<Dimension>();
        for (DimensionDto dimensionDto : this.dimensionRepository.findByFactTableId(factTableId)) {
            Dimension dimension = new Dimension(dimensionDto);
            dimensions.add(dimension);
            List<DimensionAttribute> attr = this.getAttributesOfDimension(dimension.getId());
            dimension.setDimensionAttributes(attr);
            if (dimension.getConformed() != null) {
                Dimension dimConf = this.getDimension(new Identifier(dimension.getConformed()));
                dimension.conformedCaption = dimConf.getCaption();
                dimension.conformedDescription = dimConf.getDescription();
                if (attr.isEmpty() && !dimension.getConformed().isEmpty()) {
                    attr = this.getAttributesOfDimension(new Identifier(dimension.getConformed()));
                    for (DimensionAttribute a : attr) {
                        a.setAttrConformedId(a.getStringId());
                        a.setHierarchy(dimConf.isHierarchy());
                    }
                    dimension.setDimensionAttributes(attr);
                    continue;
                }
            }
            for (DimensionAttribute a : attr) {
                if (a.getAttrConformedId() != null) {
                    DimensionAttribute attribute = this.getDimensionAttributeById(new Identifier(a.getAttrConformedId()));
                    a.setConformedCaption(attribute.getCaption());
                    a.setConformedDescription(attribute.getDescription());
                }
                a.setDimension(dimension);
            }
        }
        return dimensions;
    }

    public List<DimensionAttribute> getAllowedDimensionAttributes(List<Identifier> ids, List<Integer> sachgebietTids, List<Identifier> factTables) {
        ArrayList<DimensionAttribute> attributes = new ArrayList<DimensionAttribute>();
        for (Identifier id : ids) {
            DimensionAttribute attr = this.getDimensionAttributeById(id);
            Dimension dim = this.getDimension(attr.getDimensionId());
            attr.setDimension(dim);
            Optional<FactDto> factOpt = this.factRepository.findById(dim.getId());
            if (factOpt.isPresent()) {
                if (!factTables.contains(factOpt.get().id)) continue;
                Integer sachgebiettsTid = (int)factOpt.get().sachgebiettid;
                if (!sachgebietTids.isEmpty() && !sachgebietTids.contains(sachgebiettsTid)) continue;
            }
            attributes.add(attr);
        }
        return attributes;
    }

    public List<String> getDimensionAttributeValues(List<DimensionAttribute> attributes, List<Identifier> factTables) {
        ArrayList<String> result = new ArrayList<String>();
        ArrayList<String> tables = new ArrayList<String>();
        for (DimensionAttribute attr : attributes) {
            if (tables.contains(attr.getTablename())) continue;
            tables.add(attr.getTablename());
            for (Identifier factId : factTables) {
                FactTable fact = this.getFactTable(factId);
                Dimension dim = this.getDimension(attr.getDimensionId());
                List<String> values = this.getDimensionAttributeValues(attr, dim, fact);
                result.addAll(values);
            }
        }
        return result;
    }

    public List<List<Object>> getDimensionAttributeValuesHierarchy(Identifier attribute_id) {
        DimensionAttribute attr = this.getDimensionAttributeById(attribute_id);
        Dimension dim = this.getDimension(attr.getDimensionId());
        return this.getDimensionAttributeValuesHierarchy(attr.getColumnname(), dim.getTablename());
    }

    public List<Filter> getFilterMetadata(List<Filter> filters) {
        for (Filter filter : filters) {
            DimensionAttribute attr = this.getDimensionAttributeById(filter.dimensionAttributeId);
            Dimension dim = this.getDimension(attr.getDimensionId());
            attr.setDimension(dim);
            filter.setDimension(dim);
            filter.setDimensionAttribute(attr);
        }
        return filters;
    }

    public List<String> getDimensionAttributeValues(DimensionAttribute attr, Dimension dim, FactTable factTable) {
        String sortOrderColumnName = attr.getSortOrderColumn() != null ? attr.getSortOrderColumn() : attr.getColumnname();
        Object templateSql = "SELECT DISTINCT d.%s AS value, d.%s, array_position(array[%s], d.%s::text) FROM presentation.%s d";
        if (dim != null && attr.getFilterSelection() != null && attr.getFilterSelection().equals("show_existing_only")) {
            templateSql = (String)templateSql + " INNER JOIN presentation." + factTable.getTablename() + " f ON d.id = f." + dim.getJoincolumn();
        }
        templateSql = (String)templateSql + " WHERE d.%s IS NOT NULL ";
        if (dim != null && attr.getFilterSelection() != null && attr.getFilterSelection().equals("show_range")) {
            templateSql = (String)templateSql + " AND d.id BETWEEN (SELECT MIN(" + dim.getJoincolumn() + ") FROM presentation." + factTable.getTablename() + ") AND (SELECT MAX(" + dim.getJoincolumn() + " FROM presentation." + factTable.getTablename() + ")";
        }
        templateSql = (String)templateSql + " ORDER BY 3, 2 ASC;";
        String query = String.format((String)templateSql, attr.getColumnname(), sortOrderColumnName, DimensionAttribute.specialValueListForSql(), attr.getColumnname(), attr.getTablename(), attr.getColumnname());
        List<String> values = this.jt.query(query, (rs, rowNum) -> rs.getString("value")).stream().distinct().collect(Collectors.toList());
        return values;
    }

    public List<List<Object>> getDimensionAttributeValuesHierarchy(final String columname, String tablename) {
        String query = "select distinct id, parent_id, " + columname + " from presentation." + tablename;
        List values = this.jt.query(query, new Object[0], (RowMapper)new RowMapper<List<Object>>(){

            public List<Object> mapRow(ResultSet rs, int rowNum) throws SQLException {
                ArrayList<Object> result = new ArrayList<Object>();
                result.add(rs.getInt("id"));
                result.add(rs.getInt("parent_id"));
                result.add(rs.getString(columname));
                return result;
            }
        });
        return values;
    }

    public DimensionAttribute getDimensionAttributeMetadataById(Identifier id) {
        DimensionAttribute attr = this.getDimensionAttributeById(id);
        Dimension dim = this.getDimension(attr.getDimensionId());
        attr.setDimension(dim);
        return attr;
    }

    public Sachgebiet getSachgebietById(int sachgebietId) {
        return (Sachgebiet)this.sachgebieterepository.findById(sachgebietId).get();
    }

    public int saveReportDefinition(StoredReport report) {
        StoredReport savedStoredReport = (StoredReport)this.storedReportRepository.save(report);
        return savedStoredReport.id;
    }

    public int getBridgeMaxLevel(DimensionAttribute bridgeAttr, ReportMetadata metadata) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = DbMetaAdapter.buildMaxHierarchyLvlSQL(bridgeAttr, metadata.factTable.getTablename(), metadata.getFilterNoHierarchy(), bridgeAttr.getTablename());
        int value = (Integer)jdbcTemplate.queryForObject(sql, Integer.class) + 1;
        return value;
    }

    public int getBridgeMaxLevel(DimensionAttribute bridgeAttr, ReportMetadata metadata, String factTableName) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        String sql = DbMetaAdapter.buildMaxHierarchyLvlSQL(bridgeAttr, factTableName, metadata.getFilterNoHierarchy(), bridgeAttr.getTablename());
        int value = (Integer)jdbcTemplate.queryForObject(sql, Integer.class) + 1;
        return value;
    }

    public int getBridgeMinLevel(List<Filter> filters, int maxLvl, String dimTable) {
        if (filters == null || filters.isEmpty()) {
            return 0;
        }
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        ArrayList<CallSite> filterValues = new ArrayList<CallSite>();
        for (Filter filter : filters) {
            filterValues.add((CallSite)((Object)("ancestor_" + filter.columnname + "[%s] IN ( " + filter.getValues() + " )")));
        }
        for (int i = 0; i < maxLvl; ++i) {
            String sql = "select count(*) from presentation." + dimTable + "_hierarchy where ";
            StringJoiner filterJoiner = new StringJoiner(" OR ");
            for (String string : filterValues) {
                filterJoiner.add(String.format(string, i + 1));
            }
            int value = (Integer)jdbcTemplate.queryForObject(sql = sql + filterJoiner.toString(), Integer.class);
            if (value <= 0) continue;
            return i;
        }
        return -1;
    }

    public boolean isAttributeHierarchyBridge(Identifier leftDimensionAttributeId) {
        Optional<AttributeDto> dimAttrOpt = this.dimensionAttrRepo.findById(leftDimensionAttributeId);
        if (dimAttrOpt.isEmpty()) {
            return false;
        }
        Optional<DimensionDto> dimOpt = this.dimensionRepository.findById(dimAttrOpt.get().dimensionId);
        if (dimOpt.isEmpty()) {
            return false;
        }
        if (dimOpt.get().isHierarchy == null) {
            return false;
        }
        return dimOpt.get().isHierarchy;
    }

    public int getColNumbers(List<DimensionAttribute> topDimensionAttributes, List<Filter> filters) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate(this.dataSource);
        int num = 1;
        for (DimensionAttribute dimensionAttribute : topDimensionAttributes) {
            Filter filter;
            if (filters != null && filters.size() > 0 && (filter = Filter.findFilterById(filters, dimensionAttribute.getId())) != null && filter.filterValues.size() > 0) {
                num *= filter.filterValues.size();
                continue;
            }
            String sql = String.format("SELECT count(DISTINCT %s) FROM presentation.%s WHERE %s IS NOT NULL", dimensionAttribute.getColumnname(), dimensionAttribute.getTablename(), dimensionAttribute.getColumnname());
            int value = (Integer)jdbcTemplate.queryForObject(sql, new Object[0], Integer.class);
            num *= value;
        }
        return num;
    }

    public Identifier getRolePlayingDimensionWithNoAttributes(String attrId, String factId) {
        Identifier confDimId = this.dimensionRepository.findDimensionIdForAttribute(attrId);
        System.out.println(attrId);
        List<Identifier> preids = this.dimensionRepository.getRolePlayingIds(confDimId.composedId, factId);
        if (preids.size() == 1) {
            return preids.get(0);
        }
        if (preids.size() > 1) {
            throw new RuntimeException("Not yet implemented: Can't use conformed dimension more than once for the same facttable.");
        }
        return null;
    }

    public Identifier checkIfFactTableHasDimensionAttribute(Identifier conformedAttrId, Identifier fact) {
        Identifier rpId = this.getRolePlayingDimensionWithNoAttributes(conformedAttrId.composedId, fact.composedId);
        if (rpId != null) {
            return conformedAttrId;
        }
        List<Identifier> ids = this.dimensionAttrRepo.findAttributesByConformedAttributeAndFactTable(conformedAttrId.composedId, fact.composedId);
        if (ids.size() == 1) {
            return ids.get(0);
        }
        if (ids.size() > 1) {
            throw new FaultyMetadataException("F\u00fcr die Faktentabelle mit der ID '" + fact.composedId + "' existieren zwei Role-Playing Dimensions zugeh\u00f6rig zu der Conformed Dimension mit der ID '" + conformedAttrId.composedId + "'. Dieser Fall ist zurzeit noch nicht umgesetzt.");
        }
        Identifier id = this.dimensionAttrRepo.findAttributesByIdAndFactTable(conformedAttrId.composedId, fact.composedId);
        return id;
    }

    public boolean checkIfFactTableHasMeasure(Identifier measure, Identifier fact) {
        return this.factRepository.hasFactTableMeasure(fact.composedId, measure.composedId);
    }

    public String getLastUpdate(int tid) {
        Optional systeminfoOpt = this.systeminfoRepository.findById(tid);
        if (systeminfoOpt.isPresent()) {
            Date lastUpdate = ((Systeminfo)systeminfoOpt.get()).datum;
            return new SimpleDateFormat("dd.MM.yyyy hh:mm").format(lastUpdate);
        }
        return "Unknown";
    }

    public String getFactTableNameMaxBridgeLvl(Identifier fact, Identifier attr) {
        return this.factRepository.getFactTableNameForAttribute(fact.composedId, attr.composedId);
    }

    public DataSource getDataSource() {
        return this.dataSource;
    }

    public int getSachgebietByFactTableId(String factTableId) {
        Optional<FactDto> fact = this.factRepository.findById(new Identifier(factTableId));
        if (fact.isPresent()) {
            return fact.get().sachgebiettid;
        }
        return -1;
    }

    public List<Integer> getSachgebieteForReport(ReportDefinition reportDefinition) {
        ArrayList<Integer> result = new ArrayList<Integer>();
        for (Identifier factTableId : reportDefinition.factTableIds) {
            int sachgebiet = this.getSachgebietByFactTableId(factTableId.composedId);
            result.add(sachgebiet);
        }
        return result;
    }

    public List<StoredReport> findAllStoredReports() {
        ArrayList<StoredReport> reports = new ArrayList<StoredReport>();
        for (StoredReport report : this.storedReportRepository.findAll()) {
            StoredReport.setReportDefinitionFromJson(report);
            reports.add(report);
        }
        return reports;
    }

    public Optional<StoredReport> findById(int id) {
        Optional<StoredReport> report = this.storedReportRepository.findById(id);
        if (report.isPresent()) {
            StoredReport.setReportDefinitionFromJson(report.get());
        }
        return report;
    }

    public void deleteById(int id) {
        this.storedReportRepository.deleteById(id);
    }

    private Sachgebiet getSachgebietForFacttable(int sachgebiettid) {
        Optional sachgebiet = this.sachgebieterepository.findById(sachgebiettid);
        if (sachgebiet.isPresent()) {
            return (Sachgebiet)sachgebiet.get();
        }
        return new Sachgebiet(-1, "Unknown", null);
    }

    public List<String> getSachgebieteForFactTables(List<String> rightParamValues) {
        ArrayList<String> result = new ArrayList<String>();
        for (String id : rightParamValues) {
            int sachgebiet = this.getSachgebietByFactTableId(id);
            if (sachgebiet == -1) continue;
            result.add(String.valueOf(sachgebiet));
        }
        return result;
    }

    public List<DimensionAttribute> getAttributesOfDimension(Identifier dimId) {
        List<AttributeDto> attr = this.dimensionAttrRepo.findByDimensionId(dimId);
        List<DimensionAttribute> attributes = attr.stream().map(a -> new DimensionAttribute((AttributeDto)a)).collect(Collectors.toList());
        return attributes;
    }

    public Dimension getDimension(Identifier id) {
        Optional<DimensionDto> dimOpt = this.dimensionRepository.findById(id);
        if (dimOpt.isEmpty()) {
            throw new FaultyMetadataException(id, "Dimension");
        }
        Dimension dimension = new Dimension(dimOpt.get());
        return dimension;
    }

    public Measure getMeasure(Identifier id) {
        Optional measureOpt = this.measureRepository.findById(id);
        if (measureOpt.isEmpty()) {
            throw new FaultyMetadataException(id, "Measure");
        }
        Measure measure = new Measure((MeasureDto)measureOpt.get());
        return measure;
    }

    public DimensionAttribute getDimensionAttributeById(Identifier dimAttrId) {
        Optional<AttributeDto> optAttr = this.dimensionAttrRepo.findById(dimAttrId);
        if (optAttr.isEmpty()) {
            throw new FaultyMetadataException(dimAttrId, "Attribute");
        }
        return new DimensionAttribute(optAttr.get());
    }

    public List<Measure> getMeasures(Identifier factTableId) {
        ArrayList<Measure> measures = new ArrayList<Measure>();
        for (MeasureDto measureDto : this.measureRepository.findByFactTableId(factTableId)) {
            measures.add(new Measure(measureDto));
        }
        return measures;
    }

    public FactTable getFactTable(Identifier factTableId) {
        Optional<FactDto> optFact = this.factRepository.findById(factTableId);
        if (optFact.isEmpty()) {
            throw new FaultyMetadataException(factTableId, "Fact");
        }
        return new FactTable(optFact.get());
    }

    private static String buildMaxHierarchyLvlSQL(DimensionAttribute bridgeAttr, String factTable, List<Filter> filters, String dimTab) {
        String sql = "SELECT MAX(lvl) FROM presentation." + factTable + " fw LEFT JOIN presentation." + dimTab + "_hierarchy h ON h." + bridgeAttr.getDimIdJoinColumn() + " = fw." + bridgeAttr.getJoincolumn();
        return sql;
    }
}

