/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.service;

import de.superx.bianalysis.ColumnElement;
import de.superx.bianalysis.ColumnElementBuilder;
import de.superx.bianalysis.ReportDefinition;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.ResultBuilder;
import de.superx.bianalysis.ResultMerger;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.service.BiAnalysisRightService;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.bianalysis.sqlgeneration.SQLGenerator;
import de.superx.bianalysis.sqlgeneration.SQLGeneratorTotals;
import de.superx.common.NotYetImplementedException;
import de.superx.rest.model.Item;
import de.superx.rest.model.Result;
import de.superx.rest.model.Row;
import de.superx.rest.model.TreeNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class BiAnalysisManager {
    static Logger logger = Logger.getLogger(BiAnalysisManager.class);
    @Autowired
    BiAnalysisRightService biAnalysisRightService;

    public Result createResult(ReportDefinition reportDefinition, DbMetaAdapter dbAdapter) throws Exception {
        ArrayList<Result> results = new ArrayList<Result>();
        ResultMerger resultMerger = new ResultMerger(dbAdapter);
        for (Identifier factTableId : reportDefinition.factTableIds) {
            ReportDefinition definition = resultMerger.createFactTableSpecificReportDefinition(reportDefinition, factTableId);
            if (definition.leftDimensionAttributeIds.isEmpty() || definition.measureIds.isEmpty()) continue;
            try {
                this.biAnalysisRightService.checkCreateOrViewRights();
                ReportMetadata metadata = new ReportMetadata(definition, factTableId, dbAdapter);
                BiAnalysisManager.checkColLimit(reportDefinition, dbAdapter, metadata);
                Result reportSegment = this.getReportData(metadata, dbAdapter);
                results.add(reportSegment);
            }
            catch (Exception e) {
                logger.error((Object)"Couldn't create report", (Throwable)e);
                throw e;
            }
        }
        Result result = reportDefinition.factTableIds.size() > 1 ? resultMerger.buildMergedReport(reportDefinition, results) : (Result)results.get(0);
        return result;
    }

    private static void checkColLimit(ReportDefinition reportDefinition, DbMetaAdapter dbAdapter, ReportMetadata metadata) throws NotYetImplementedException {
        int POSTGRES_MAX_COL_LIMIT = 1664;
        int resultCols = dbAdapter.getColNumbers(metadata.topDimensionAttributes, metadata.filters);
        if ((resultCols *= reportDefinition.measureIds.size()) > 1663) {
            throw new NotYetImplementedException("FEHLER: Ihre Anfrage \u00fcberschreitet das Spaltenlimit. Bitte w\u00e4hlen Sie eine andere Kombination an Attributen.");
        }
    }

    public static String getSqlStatement(ReportDefinition definition, DbMetaAdapter dbAdapter) {
        String sqlStatement = "";
        ReportMetadata reportMetadata = definition.getReportMetadata(dbAdapter, definition.factTableIds.get(0));
        List<ColumnElement> columnElements = ColumnElementBuilder.buildColumnElements(reportMetadata);
        SQLGenerator sqlGenerator = new SQLGenerator(reportMetadata, columnElements);
        sqlStatement = sqlGenerator.buildSqlStatement();
        return sqlStatement;
    }

    private Result getReportData(ReportMetadata metadata, DbMetaAdapter dbAdapter) throws Exception {
        List<ColumnElement> columnElements = ColumnElementBuilder.buildColumnElements(metadata);
        ArrayList<Item> sqlStatements = new ArrayList<Item>();
        String reportSQL = new SQLGenerator(metadata, columnElements).buildFormattedSqlStatement();
        String totalsColumnSQL = SQLGeneratorTotals.generateTotalsColumnSQL(metadata);
        sqlStatements.add(new Item("noAggregatesSQL", reportSQL));
        sqlStatements.add(new Item("totalsColumnSQL", totalsColumnSQL));
        ResultBuilder resultBuilder = new ResultBuilder(dbAdapter.getDataSource());
        resultBuilder.setColumnElements(columnElements);
        resultBuilder.setReportMetadata(metadata);
        Result report = resultBuilder.buildReport(sqlStatements, this.biAnalysisRightService.isCreateRight());
        return report;
    }

    public static List<Row> hierarchyToRows(ArrayList<TreeNode> hierarchy) {
        ArrayList<Row> rows = new ArrayList<Row>();
        for (TreeNode treeNode : hierarchy) {
            BiAnalysisManager.nodeToRow(treeNode, rows);
        }
        return rows;
    }

    private static List<Row> nodeToRow(TreeNode<Map<String, Object>> treeNode, List<Row> rows) {
        BiAnalysisManager.splitHierarchyColumn(treeNode);
        rows.add(new Row((Map)treeNode.data, true));
        for (TreeNode<Map<String, Object>> treeNode2 : treeNode.children) {
            List<Row> childRows = BiAnalysisManager.nodeToRow(treeNode2, rows);
            for (Row row : childRows) {
                if (rows.contains(row)) continue;
                rows.add(row);
            }
        }
        return rows;
    }

    private static void splitHierarchyColumn(TreeNode<Map<String, Object>> node) {
        String realColumn = ((Map)node.data).get("column").toString();
        if (realColumn.contains(" (Ebene ")) {
            String[] splittedString = realColumn.split(" \\(Ebene ");
            String mainColumn = splittedString[0];
            ((Map)node.data).put(realColumn, ((Map)node.data).get(mainColumn));
            ((Map)node.data).put(mainColumn, "");
        }
    }

    public static String getTotalsColumnSqlStatement(ReportDefinition definition, DbMetaAdapter dbAdapter) {
        String sqlStatement = "";
        ReportMetadata metadata = new ReportMetadata(definition, definition.factTableIds.get(0), dbAdapter);
        sqlStatement = SQLGeneratorTotals.generateTotalsColumnSQL(metadata);
        return sqlStatement;
    }
}

