/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.models;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.Dimension;
import de.superx.bianalysis.repository.dto.AttributeDto;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;

public class DimensionAttribute {
    public static final List<String> SPECIAL_VALUES = List.of("n. v.", "k.A.", "k.a.", "unbekannt", "Unbekannt", "ung\u00fcltig", "Ung\u00fcltig");
    public static final Comparator<String> SPECIAL_VALUE_COMPARATOR = (a1, a2) -> {
        if (a1.equals(a2)) {
            return 0;
        }
        if (SPECIAL_VALUES.contains(a1)) {
            return -1;
        }
        if (SPECIAL_VALUES.contains(a2)) {
            return 1;
        }
        return a1.compareTo((String)a2);
    };
    private String conformedCaption;
    private String conformedDescription;
    @JsonIgnore
    private AttributeDto attributeTable;
    @JsonIgnore
    private String dimCaption;
    @JsonIgnore
    private String dimId;
    @JsonIgnore
    private String dimConformedId;
    @JsonIgnore
    private String tablename;
    @JsonIgnore
    private String joincolumn;
    private boolean isHierarchy;
    @JsonIgnore
    private boolean isHistorical;
    @JsonIgnore
    private String dimensionTableAlias;
    @JsonIgnore
    private String dimensionColumnAlias;
    private List<String> dimensionAttributeValues;
    @JsonIgnore
    private String dimIdJoinColumn;

    public static String specialValueListForSql() {
        String result = String.join((CharSequence)"', '", SPECIAL_VALUES);
        return "'" + result + "'";
    }

    public DimensionAttribute() {
    }

    public DimensionAttribute(AttributeDto attributeTable) {
        this.attributeTable = attributeTable;
    }

    public void setDimension(Dimension dim) {
        this.dimCaption = dim.getCaption();
        this.dimId = dim.getId().composedId;
        this.tablename = dim.getTablename();
        this.joincolumn = dim.getJoincolumn();
        this.isHierarchy = dim.isHierarchy();
        this.isHistorical = dim.isHistorical();
        this.dimIdJoinColumn = dim.getIdColumn();
        this.dimensionTableAlias = dim.getAlias() != null ? dim.getAlias() : DimensionAttribute.generateDimensionTableAlias(this.joincolumn);
        this.dimensionColumnAlias = this.getColumnname() + "_" + this.getId().value;
    }

    public static String generateDimensionTableAlias(String joincolumn) {
        if (joincolumn != null) {
            return joincolumn.replaceFirst("_id$", "");
        }
        return null;
    }

    public int hashCode() {
        return Objects.hash(this.getId());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        DimensionAttribute other = (DimensionAttribute)obj;
        return Objects.equals(this.getId(), other.getId());
    }

    public String getCaption() {
        return this.attributeTable.caption;
    }

    public String getColumnname() {
        return this.attributeTable.columnname;
    }

    public String getSortOrderColumn() {
        return this.attributeTable.sortOrderColumn;
    }

    public String getFilterSelection() {
        return this.attributeTable.filterSelection;
    }

    public String getDimId() {
        return this.dimId;
    }

    public void setDimId(String dimId) {
        this.dimId = dimId;
    }

    public String getDimConformedId() {
        return this.dimConformedId;
    }

    public void setDimConformedId(String dimConformedId) {
        this.dimConformedId = dimConformedId;
    }

    public String getAttrConformedId() {
        return this.attributeTable.attrConformedId;
    }

    public Identifier getId() {
        return this.attributeTable.id;
    }

    @JsonIgnore
    public String getStringId() {
        return this.attributeTable.id.composedId;
    }

    public String getDimCaption() {
        return this.dimCaption;
    }

    public void setDimCaption(String dimCaption) {
        this.dimCaption = dimCaption;
    }

    public String getDimensionTableAlias() {
        return this.dimensionTableAlias;
    }

    public void setDimensionTableAlias(String dimensionTableAlias) {
        this.dimensionTableAlias = dimensionTableAlias;
    }

    public String getDimensionColumnAlias() {
        return this.dimensionColumnAlias;
    }

    public void setDimensionColumnAlias(String dimensionColumnAlias) {
        this.dimensionColumnAlias = dimensionColumnAlias;
    }

    public String getConformedCaption() {
        return this.conformedCaption;
    }

    public void setConformedCaption(String conformedCaption) {
        this.conformedCaption = conformedCaption;
    }

    public String getConformedDescription() {
        return this.conformedDescription;
    }

    public void setConformedDescription(String conformedDescription) {
        this.conformedDescription = conformedDescription;
    }

    public String getDescription() {
        return this.attributeTable.description;
    }

    public Identifier getDimensionId() {
        return this.attributeTable.dimensionId;
    }

    public String getTablename() {
        return this.tablename;
    }

    public void setTablename(String tablename) {
        this.tablename = tablename;
    }

    public String getJoincolumn() {
        return this.joincolumn;
    }

    public void setJoincolumn(String joincolumn) {
        this.joincolumn = joincolumn;
    }

    @JsonProperty(value="isHierarchy")
    public boolean isHierarchy() {
        return this.isHierarchy;
    }

    public boolean isHistorical() {
        return this.isHistorical;
    }

    public void setHierarchy(boolean isHierarchy) {
        this.isHierarchy = isHierarchy;
    }

    public void setHistorical(boolean isHistorical) {
        this.isHistorical = isHistorical;
    }

    public boolean isHierarchicalFilter() {
        return this.attributeTable.hierarchicalFilter;
    }

    public List<String> getDimensionAttributeValues() {
        return this.dimensionAttributeValues;
    }

    public void setDimensionAttributeValues(List<String> dimensionAttributeValues) {
        this.dimensionAttributeValues = dimensionAttributeValues;
    }

    public void setDimIdJoinColumn(String idColumn) {
        this.dimIdJoinColumn = idColumn;
    }

    public String getDimIdJoinColumn() {
        return this.dimIdJoinColumn;
    }

    public void setAttrConformedId(String stringId) {
        this.attributeTable.attrConformedId = stringId;
    }
}

