/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata.models.json;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import de.superx.bianalysis.metadata.UpsertStringBuilder;
import de.superx.bianalysis.metadata.models.json.MetaDimension;
import de.superx.bianalysis.metadata.models.json.MetaObject;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"id", "default_release", "ref", "caption", "dim_column"})
public class MetaDimensionAttribute
extends MetaObject {
    @JsonProperty(value="dim_column")
    private String dimColumn;
    @JsonProperty(value="sort_order_column")
    private String sortOrderColumn;
    @JsonProperty(value="hierarchical_filter")
    private boolean hierarchicalFilter;
    @JsonIgnore
    private MetaDimension dimension;
    @JsonIgnore
    private MetaDimensionAttribute confDimAttrRef;
    @JsonProperty(value="ref_to")
    private String refTo;
    @JsonProperty(value="filter_selection")
    private String filterSelection;

    public MetaDimensionAttribute() {
        super("dimension_attribute");
    }

    public MetaDimensionAttribute(String attrColumn) {
        super("dimension_attribute");
        this.refTo = attrColumn;
    }

    public void setConformedDimensionAttribute(MetaDimensionAttribute attribute) {
        this.confDimAttrRef = attribute;
    }

    @Override
    public UpsertStringBuilder getUpsertBuilder() {
        UpsertStringBuilder builder = new UpsertStringBuilder();
        if (this.confDimAttrRef == null) {
            builder = super.getUpsert().withIdCol("dimension_id", this.dimension.id).withStringCol("columnname", this.dimColumn).withStringCol("sort_order_column", this.sortOrderColumn).withStringCol("filter_selection", this.filterSelection);
        } else {
            builder = new UpsertStringBuilder().forTable("metadata", this.sourceTable).withStringCol("namespace", this.namespace).withIdCol("id", this.id).withIntCol("default_release", 1);
            builder = this.getCaption() != null && !this.getCaption().isBlank() ? builder.withStringCol("caption", this.caption) : builder.withStringCol("caption", this.confDimAttrRef.getCaption());
            builder = this.getDimColumn() != null && !this.getDimColumn().isBlank() ? builder.withStringCol("columnname", this.dimColumn) : builder.withStringCol("columnname", this.confDimAttrRef.getDimColumn());
            builder = this.getFilterSelection() != null && !this.getFilterSelection().isBlank() ? builder.withStringCol("filter_selection", this.filterSelection) : builder.withStringCol("filter_selection", this.confDimAttrRef.getFilterSelection());
            builder = this.getSortOrderColumn() != null && !this.getSortOrderColumn().isBlank() ? builder.withStringCol("sort_order_column", this.sortOrderColumn) : builder.withStringCol("sort_order_column", this.confDimAttrRef.getSortOrderColumn());
            builder = builder.withIdCol("dimension_id", this.dimension.id);
            builder = builder.withIdCol("conformed", this.confDimAttrRef.id);
        }
        builder = this.confDimAttrRef != null && this.confDimAttrRef.hierarchicalFilter ? builder.withStringCol("hierarchical_filter", String.valueOf(this.confDimAttrRef.hierarchicalFilter)) : builder.withStringCol("hierarchical_filter", String.valueOf(this.hierarchicalFilter));
        builder = this.description != null && !this.description.isBlank() ? builder.withStringCol("description", this.description) : (this.confDimAttrRef != null ? builder.withStringCol("description", this.confDimAttrRef.getDescription()) : builder.withStringCol("description", ""));
        return builder;
    }

    public String getDimColumn() {
        return this.dimColumn;
    }

    public void setDimColumn(String dimColumn) {
        this.dimColumn = dimColumn;
    }

    public String getSortOrderColumn() {
        return this.sortOrderColumn;
    }

    public void setSortOrderColumn(String sortOrderColumn) {
        this.sortOrderColumn = sortOrderColumn;
    }

    public String getFilterSelection() {
        return this.filterSelection;
    }

    public void setFilterSelection(String filterSelection) {
        this.filterSelection = filterSelection;
    }

    public MetaDimension getDimension() {
        return this.dimension;
    }

    public void setDimension(MetaDimension dimension) {
        this.dimension = dimension;
    }

    public MetaDimensionAttribute getConfDimAttrRef() {
        return this.confDimAttrRef;
    }

    public void setConfDimAttrRef(MetaDimensionAttribute confDimAttrRef) {
        this.confDimAttrRef = confDimAttrRef;
    }

    public String getRefTo() {
        return this.refTo;
    }

    public void setRefTo(String refTo) {
        this.refTo = refTo;
    }

    @Override
    @JsonIgnore
    public String getDocIdentifier() {
        if (this.refTo != null) {
            return this.confDimAttrRef.getDocIdentifier();
        }
        return this.dimension.getDocIdentifier() + "." + this.dimColumn;
    }

    public boolean isHierarchicalFilter() {
        return this.hierarchicalFilter;
    }

    public void setHierarchicalFilter(boolean hierarchicalFilter) {
        this.hierarchicalFilter = hierarchicalFilter;
    }
}

