/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata;

import de.superx.bianalysis.metadata.Identifier;
import java.util.ArrayList;
import java.util.List;
import java.util.StringJoiner;

public class UpsertStringBuilder {
    private StringJoiner values;
    private StringJoiner columns;
    private StringJoiner onConflict;
    private String schema;
    private String tablename;
    private List<UpsertStringBuilder> builders = new ArrayList<UpsertStringBuilder>();

    public UpsertStringBuilder() {
        this.values = new StringJoiner(", ");
        this.columns = new StringJoiner(", ");
        this.onConflict = new StringJoiner(", ");
    }

    public void addUpsertStringBuilder(UpsertStringBuilder builder) {
        this.builders.add(builder);
    }

    public UpsertStringBuilder forTable(String schema, String tablename) {
        this.tablename = tablename;
        this.schema = schema;
        return this;
    }

    public UpsertStringBuilder withStringCol(String colName, String value) {
        this.appendToSelection(colName);
        if (value == null) {
            this.values.add("null");
        } else {
            this.values.add("'" + value + "'");
        }
        return this;
    }

    public UpsertStringBuilder withStringCol(String colName, Object value) {
        if (value != null) {
            return this.withStringCol(colName, value.toString());
        }
        return this.withStringCol(colName, "unknown");
    }

    public UpsertStringBuilder withStringCol(String colName, String value, String defaultVal) {
        if (value != null) {
            return this.withStringCol(colName, value);
        }
        return this.withStringCol(colName, defaultVal);
    }

    public UpsertStringBuilder withStringCol(String colName, Object value, Object defaultVal) {
        if (value != null) {
            return this.withStringCol(colName, value);
        }
        return this.withStringCol(colName, defaultVal);
    }

    public UpsertStringBuilder withIntCol(String colName, Integer value) {
        this.appendToSelection(colName);
        this.values.add(String.valueOf(value));
        return this;
    }

    public UpsertStringBuilder withIdCol(String colName, Identifier id) {
        if (id != null) {
            return this.withStringCol(colName, id.composedId);
        }
        return this.withStringCol(colName, null);
    }

    private void appendToSelection(String colName) {
        this.onConflict.add(String.format("%s = EXCLUDED.%s", colName, colName));
        this.columns.add(colName);
    }

    public String build(boolean hasOnConflictConstruct) {
        Object result = "INSERT INTO %s.%s(%s) VALUES(%s)";
        result = String.format((String)result, this.schema, this.tablename, this.columns, this.values);
        if (hasOnConflictConstruct) {
            result = (String)result + " ON CONFLICT(id) DO NOTHING";
        }
        result = (String)result + ";\n";
        if (this.builders.size() > 0) {
            for (UpsertStringBuilder upsertStringBuilder : this.builders) {
                result = (String)result + upsertStringBuilder.build(hasOnConflictConstruct);
            }
        }
        return result;
    }
}

