/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.superx.bianalysis.FaultyMetadataException;
import de.superx.bianalysis.metadata.MetaJson;
import de.superx.bianalysis.metadata.models.json.MetaDimension;
import de.superx.bianalysis.metadata.models.json.MetaDimensionAttribute;
import de.superx.bianalysis.metadata.models.json.MetaFact;
import de.superx.bianalysis.metadata.models.json.MetaMeasure;
import de.superx.bianalysis.metadata.models.json.MetaMeasureFilter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.log4j.Logger;

public class MetaImport
extends MetaJson {
    public List<MetaFact> facts;
    private static Logger log = Logger.getLogger(MetaImport.class);
    @JsonIgnore
    private Map<String, MetaDimensionAttribute> keysForMeasureFilter = new HashMap<String, MetaDimensionAttribute>();
    @JsonIgnore
    public List<MetaDimension> conformedDimensions;

    @JsonIgnore
    public void setConformedDimensions(List<MetaDimension> conformedDimensions) {
        this.conformedDimensions = conformedDimensions;
        if (this.conformedDimensions != null) {
            for (MetaDimension dim : this.conformedDimensions) {
                for (MetaDimensionAttribute attr : dim.getAttributes()) {
                    attr.setDimension(dim);
                    this.keysForMeasureFilter.put(dim.getDimension() + "." + attr.getDimColumn(), attr);
                }
            }
        }
    }

    @Override
    @JsonIgnore
    public void init() {
        this.allMetaObj = new ArrayList();
        for (MetaFact fact : this.facts) {
            this.allMetaObj.add(fact);
            for (MetaDimension dim : fact.getDimensions()) {
                this.allMetaObj.add(dim);
                if (dim.getRefTo() != null && !dim.getRefTo().isEmpty()) {
                    MetaDimension conformedDim = this.findByRef(dim);
                    dim.setConformedDimension(conformedDim);
                }
                for (MetaDimensionAttribute attr : dim.getAttributes()) {
                    this.allMetaObj.add(attr);
                    if (attr.getRefTo() != null && !attr.getRefTo().isEmpty()) {
                        attr.setConformedDimensionAttribute(this.findByRefAttr(dim.getConformedDimension().getDimension(), attr));
                    }
                    this.keysForMeasureFilter.put(dim.getDimension() + "." + attr.getDimColumn(), attr);
                }
            }
            if (fact.getMeasures() == null) continue;
            for (MetaMeasure measure : fact.getMeasures()) {
                this.allMetaObj.add(measure);
                MetaMeasureFilter filter = measure.getFilter();
                if (filter == null) continue;
                if (filter.getDimensionRef() != null && !filter.getDimensionRef().isBlank()) {
                    MetaDimensionAttribute attr;
                    attr = this.keysForMeasureFilter.get(filter.getDimensionRef());
                    if (attr == null) {
                        throw new FaultyMetadataException("Could not resolve dimensionRef '" + filter.getDimensionRef() + "' (" + this.file.getName() + " -> " + fact.getFacttable() + ")");
                    }
                    filter.setAttribute(attr);
                    this.allMetaObj.add(filter);
                    continue;
                }
                if (filter.getFactColumnRef() == null || filter.getFactColumnRef().isBlank()) continue;
                this.allMetaObj.add(filter);
            }
        }
    }

    private MetaDimensionAttribute findByRefAttr(String dimensionTable, MetaDimensionAttribute attribute) {
        String attributeColumn = attribute.getRefTo();
        MetaDimensionAttribute confAttr = null;
        block0: for (MetaDimension confDim : this.conformedDimensions) {
            if (!confDim.getDimension().equals(dimensionTable)) continue;
            for (MetaDimensionAttribute attr : confDim.getAttributes()) {
                if (!attr.getDimColumn().equals(attributeColumn)) continue;
                confAttr = attr;
                continue block0;
            }
        }
        if (confAttr == null) {
            throw new FaultyMetadataException("Could not resolve attribute reference '" + attributeColumn + "' (" + this.file.getName() + " -> " + attribute.getDimension().getFact().getFacttable() + " -> " + attribute.getDimension().getRefTo() + ")");
        }
        return confAttr;
    }

    @JsonIgnore
    private MetaDimension findByRef(MetaDimension dim) {
        String refTo = dim.getRefTo();
        MetaDimension resolvedRefTo = null;
        for (MetaDimension dimConf : this.conformedDimensions) {
            if (dimConf.getDimension() == null) {
                log.error((Object)("Missing dimension attribute for " + dimConf.getCaption()));
                continue;
            }
            if (!dimConf.getDimension().equals(refTo)) continue;
            resolvedRefTo = dimConf;
            break;
        }
        if (resolvedRefTo == null) {
            throw new FaultyMetadataException("Could not resolve dimension reference '" + refTo + "' (" + this.file.getName() + " -> " + dim.getFact().getFacttable() + ")");
        }
        return resolvedRefTo;
    }

    @JsonIgnore
    public List<MetaDimension> getDimensionsWithoutRefTo() {
        ArrayList<MetaDimension> dims = new ArrayList<MetaDimension>();
        for (MetaFact fact : this.facts) {
            for (MetaDimension dim : fact.getDimensions()) {
                if (dim.getRefTo() != null) continue;
                dims.add(dim);
            }
        }
        return dims;
    }
}

