/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.json.JsonMapper;
import de.superx.bianalysis.ReportDefinition;
import de.superx.rest.model.Result;
import de.superx.rest.model.TreeNode;
import java.util.ArrayList;
import org.springframework.data.annotation.Id;
import org.springframework.data.annotation.Transient;
import org.springframework.data.relational.core.mapping.Column;
import org.springframework.data.relational.core.mapping.Table;

@Table(value="metadata\".\"rw_report_definitions")
public class StoredReport {
    @Id
    public int id;
    public String name;
    public String description;
    public String definition;
    @Column(value="show_total_column")
    @JsonProperty(value="show_total_column")
    public int showTotalColumn;
    @Transient
    public Boolean isReadOnly = Boolean.FALSE;
    @Transient
    public ReportDefinition reportDefinition;
    @Transient
    public Result exportedResult;
    @Transient
    public ArrayList<TreeNode> hierarchy;

    public StoredReport(String name, ReportDefinition reportDefinition, Result exportedResult) {
        this.name = name;
        this.reportDefinition = reportDefinition;
        this.exportedResult = exportedResult;
    }

    public StoredReport() {
    }

    public static void setReportDefinitionJson(StoredReport report) {
        ObjectWriter ow = new ObjectMapper().writer();
        String reportDefinitionJson = null;
        try {
            reportDefinitionJson = ow.writeValueAsString((Object)report.reportDefinition);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        report.definition = reportDefinitionJson;
    }

    public static void setReportDefinitionFromJson(StoredReport report) {
        ObjectMapper mapper = ((JsonMapper.Builder)JsonMapper.builder().findAndAddModules()).build();
        ReportDefinition reportDefinition = null;
        try {
            reportDefinition = (ReportDefinition)mapper.readValue(report.definition, ReportDefinition.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        report.reportDefinition = reportDefinition;
        report.definition = "";
    }
}

