/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.ColumnElement;
import de.superx.bianalysis.ColumnElementBuilder;
import de.superx.bianalysis.ReportDefinition;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.ResultBuilder;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.FactTable;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.InfoItem;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.Sachgebiet;
import de.superx.rest.model.Column;
import de.superx.rest.model.Result;
import de.superx.rest.model.Row;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;

public class ResultMerger {
    private DbMetaAdapter dbAdapter;

    public ResultMerger(DbMetaAdapter dbAdapter) {
        this.dbAdapter = dbAdapter;
    }

    public Result buildMergedReport(ReportDefinition definition, List<Result> reportResults) {
        Result result = new Result();
        ReportMetadata metadata = new ReportMetadata(definition, null, this.dbAdapter);
        List<ColumnElement> columnElements = ColumnElementBuilder.buildColumnElements(metadata);
        List<Column> columns = ResultBuilder.buildColumns(metadata, columnElements);
        if (!metadata.topDimensionAttributes.isEmpty()) {
            ResultBuilder.setTotalColumnToColumns(columns, metadata);
        }
        List<List<Row>> allRows = Result.getRowsFromReports(reportResults);
        List<Row> rows = ResultMerger.mergeRows(allRows);
        if (metadata.hideEmptyColumns) {
            ResultBuilder.removeEmptyColumns(columns, rows);
        }
        ResultBuilder.setAttributesToReport(result, metadata, rows, columns);
        result.setSubResults(reportResults);
        List<InfoItem> factTablesInfo = ResultMerger.getFactTablesAsInfo(this.dbAdapter, definition.factTableIds);
        result.info.setSegmentCaption(factTablesInfo.stream().map(f -> f.caption).collect(Collectors.joining(", ")));
        result.info.setSachgebiete(ResultMerger.getSachgebieteAsInfo(this.dbAdapter, definition.factTableIds));
        result.info.setFacttables(factTablesInfo);
        for (Result r : reportResults) {
            if (r.info.error == null || r.info.error.isBlank()) continue;
            result.info.setErrorMessage(r.info.error);
            break;
        }
        return result;
    }

    private static List<String> getSachgebieteAsInfo(DbMetaAdapter dbAdapter, List<Identifier> factTableIds) {
        ArrayList<String> sachgebiete = new ArrayList<String>();
        ArrayList<Integer> tids = new ArrayList<Integer>();
        for (Identifier id : factTableIds) {
            FactTable factTable = dbAdapter.getFactTable(id);
            Sachgebiet sachgebiet = dbAdapter.getSachgebietById(factTable.getSachgebiettid());
            Integer tid = sachgebiet.tid;
            if (tids.contains(tid)) continue;
            tids.add(tid);
            sachgebiete.add(sachgebiet.name.trim());
        }
        return sachgebiete;
    }

    private static List<InfoItem> getFactTablesAsInfo(DbMetaAdapter dbAdapter, List<Identifier> factTableIds) {
        ArrayList<InfoItem> facttables = new ArrayList<InfoItem>();
        for (Identifier id : factTableIds) {
            FactTable factTable = dbAdapter.getFactTable(id);
            facttables.add(new InfoItem(factTable.getId().composedId, factTable.getCaption(), factTable.getDescription()));
        }
        return facttables;
    }

    public ReportDefinition createFactTableSpecificReportDefinition(ReportDefinition reportDefinition, Identifier factTableId) {
        Identifier checkedAttr;
        Identifier attr;
        int i;
        ReportDefinition definition = new ReportDefinition();
        definition.hideEmptyColumns = reportDefinition.hideEmptyColumns;
        definition.factTableIds.add(factTableId);
        for (i = 0; i < reportDefinition.leftDimensionAttributeIds.size(); ++i) {
            attr = reportDefinition.leftDimensionAttributeIds.get(i);
            checkedAttr = this.dbAdapter.checkIfFactTableHasDimensionAttribute(attr, factTableId);
            if (checkedAttr == null) continue;
            definition.leftDimensionAttributeIds.add(checkedAttr);
        }
        for (i = 0; i < reportDefinition.topDimensionAttributeIds.size(); ++i) {
            attr = reportDefinition.topDimensionAttributeIds.get(i);
            checkedAttr = this.dbAdapter.checkIfFactTableHasDimensionAttribute(attr, factTableId);
            if (checkedAttr == null) continue;
            definition.topDimensionAttributeIds.add(checkedAttr);
        }
        for (i = 0; i < reportDefinition.measureIds.size(); ++i) {
            Identifier measure = reportDefinition.measureIds.get(i);
            if (!this.dbAdapter.checkIfFactTableHasMeasure(measure, factTableId)) continue;
            definition.measureIds.add(measure);
        }
        for (i = 0; i < reportDefinition.filters.size(); ++i) {
            Filter filter = reportDefinition.filters.get(i);
            checkedAttr = this.dbAdapter.checkIfFactTableHasDimensionAttribute(filter.dimensionAttributeId, factTableId);
            if (checkedAttr == null) continue;
            Filter roleFilter = new Filter(filter);
            roleFilter.dimensionAttributeId = checkedAttr;
            definition.filters.add(roleFilter);
        }
        return definition;
    }

    public static List<Row> mergeRows(List<List<Row>> rows) {
        ArrayList<Row> result = new ArrayList<Row>();
        for (List<Row> inputRows : rows) {
            for (Row row : inputRows) {
                Row rowRepl = new Row(row.aggregated);
                rowRepl.rowKey = row.rowKey;
                Iterator<String> iterator = row.cells.keySet().iterator();
                while (iterator.hasNext()) {
                    String key;
                    String newKey = key = iterator.next();
                    rowRepl.cells.put(newKey, row.cells.get(key));
                }
                if (!result.contains(rowRepl)) {
                    result.add(rowRepl);
                    continue;
                }
                Row found = (Row)result.get(result.indexOf(rowRepl));
                for (String key : rowRepl.cells.keySet()) {
                    if (found.cells.containsKey(key)) continue;
                    found.cells.put(key, rowRepl.cells.get(key));
                }
            }
        }
        return result;
    }
}

