/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.ColumnElement;
import de.superx.bianalysis.ReportMetadata;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.InfoItem;
import de.superx.bianalysis.models.Measure;
import de.superx.rest.model.Column;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.Item;
import de.superx.rest.model.Result;
import de.superx.rest.model.ResultType;
import de.superx.rest.model.Row;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TreeMap;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class ResultBuilder {
    private static final boolean IGNORE_SELF_LOOPS = true;
    private DataSource dataSource;
    private ReportMetadata reportMetadata;
    private List<ColumnElement> columnElements;
    Logger logger = Logger.getLogger(ResultBuilder.class);

    public ResultBuilder() {
    }

    public ResultBuilder(ReportMetadata metadata, List<ColumnElement> columns) {
        this.reportMetadata = metadata;
        this.columnElements = columns;
    }

    public ResultBuilder(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public void setReportMetadata(ReportMetadata reportMetadata) {
        this.reportMetadata = reportMetadata;
    }

    public void setColumnElements(List<ColumnElement> columnElements) {
        this.columnElements = columnElements;
    }

    private Row buildRowCells(ResultSet rs) {
        Row row = new Row();
        TreeMap<String, Object> cells = new TreeMap<String, Object>();
        if (this.reportMetadata.leftDimensionAttributes != null && !this.reportMetadata.leftDimensionAttributes.isEmpty()) {
            int aggregationLvl = this.reportMetadata.leftDimensionAttributes.size() - 1;
            for (DimensionAttribute dimensionAttribute : this.reportMetadata.leftDimensionAttributes) {
                if (dimensionAttribute.isHierarchy()) {
                    try {
                        String prevLbl = "";
                        int countLvl = 0;
                        aggregationLvl += this.reportMetadata.maxBridgeLvl - this.reportMetadata.minBridgeLvl - 1;
                        for (int i = this.reportMetadata.minBridgeLvl; i < this.reportMetadata.maxBridgeLvl; ++i) {
                            Object cell = rs.getObject("col" + i);
                            String curLbl = (String)cell;
                            if (cell == null) {
                                --aggregationLvl;
                            }
                            if (curLbl != null && curLbl != "" && curLbl.equals(prevLbl)) continue;
                            String id = dimensionAttribute.getAttrConformedId();
                            if (id == null) {
                                id = dimensionAttribute.getStringId();
                            }
                            Object cellKey = id + " (Ebene " + countLvl + ")";
                            if (countLvl == 0) {
                                cellKey = dimensionAttribute.getAttrConformedId();
                            }
                            if (cell != null && cellKey != null) {
                                cells.put((String)cellKey, cell);
                                row.rowKey = row.rowKey + (String)cellKey + cell;
                                ++countLvl;
                            }
                            prevLbl = (String)cell;
                        }
                        continue;
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                        continue;
                    }
                }
                try {
                    Object val = rs.getObject(dimensionAttribute.getDimensionColumnAlias());
                    if (val != null) {
                        String id = dimensionAttribute.getAttrConformedId();
                        if (id == null) {
                            id = dimensionAttribute.getStringId();
                        }
                        cells.put(id, val);
                        row.rowKey = row.rowKey + id + val;
                    } else {
                        --aggregationLvl;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                if (dimensionAttribute.getSortOrderColumn() == null) continue;
                try {
                    String id = dimensionAttribute.getAttrConformedId();
                    if (id == null) {
                        id = dimensionAttribute.getStringId();
                    }
                    cells.put(id + "_sorting", rs.getObject(dimensionAttribute.getDimensionColumnAlias() + "_" + dimensionAttribute.getSortOrderColumn()));
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
            }
            try {
                row.aggregated = aggregationLvl;
                if (row.aggregated == -1) {
                    int colNum = this.reportMetadata.maxBridgeLvl + this.columnElements.size() - this.reportMetadata.measures.size();
                    for (Measure measure : this.reportMetadata.measures) {
                        cells.put(ResultBuilder.getTotalCellHeaderPrefix(this.reportMetadata) + measure.getId().composedId, rs.getObject("col" + colNum++));
                    }
                }
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
        if (!this.columnElements.isEmpty()) {
            for (ColumnElement columnElement : this.columnElements) {
                try {
                    cells.put(columnElement.caption, rs.getObject("col" + columnElement.columnNumber));
                }
                catch (SQLException sQLException) {
                    sQLException.printStackTrace();
                }
            }
        }
        row.cells = cells;
        return row;
    }

    public static List<Column> buildColumns(ReportMetadata reportMetadata, List<ColumnElement> columnElements) {
        ArrayList<Column> columns = new ArrayList<Column>();
        if (reportMetadata.leftDimensionAttributes != null) {
            reportMetadata.leftDimensionAttributes.forEach(dimensionAttribute -> {
                String id = dimensionAttribute.getAttrConformedId();
                if (id == null) {
                    id = dimensionAttribute.getStringId();
                }
                if (dimensionAttribute.isHierarchy()) {
                    int cnt = 0;
                    for (int i = reportMetadata.minBridgeLvl; i < reportMetadata.maxBridgeLvl - 1; ++i) {
                        if (cnt == 0) {
                            columns.add(new Column(id, dimensionAttribute.getCaption(), ColumnType.StringColumn, true));
                        } else {
                            String caption = id + " (Ebene " + cnt + ")";
                            String header = dimensionAttribute.getCaption() + " (Ebene " + cnt + ")";
                            columns.add(new Column(caption, header, ColumnType.HierarchyLevelColumn, true, id, false));
                        }
                        ++cnt;
                    }
                } else if (dimensionAttribute.getSortOrderColumn() != null) {
                    columns.add(new Column(id, dimensionAttribute.getCaption(), ColumnType.StringColumn, true, dimensionAttribute.getStringId() + "_sorting", false));
                    columns.add(new Column(id + "_sorting", dimensionAttribute.getCaption(), ColumnType.SortOrderColumn, false, dimensionAttribute.getStringId(), true));
                } else {
                    columns.add(new Column(id, dimensionAttribute.getCaption(), ColumnType.StringColumn, true));
                }
            });
        }
        if (!columnElements.isEmpty()) {
            columnElements.forEach(columnElement -> {
                Column col = new Column(columnElement.caption, columnElement.header, columnElement.measure.getMeasureType(), false);
                col.aggregation = columnElement.measure.getAggregationType();
                columns.add(col);
            });
        }
        return columns;
    }

    public List<Row> getRowsForReport(String sqlStatement, Connection con) {
        List<Row> rows = null;
        try (Statement stmt = con.createStatement();
             ResultSet rs = stmt.executeQuery(sqlStatement);){
            rows = this.buildRowList(rs);
        }
        catch (SQLException e) {
            System.out.println(sqlStatement);
            throw new RuntimeException(e);
        }
        return rows;
    }

    public List<Row> buildRowList(ResultSet rs) throws SQLException {
        ArrayList<Row> rows = new ArrayList<Row>();
        while (rs.next()) {
            Row row = this.buildRowCells(rs);
            rows.add(row);
        }
        ArrayList<Row> result = new ArrayList<Row>();
        if (this.reportMetadata.getHierarchyAttributes().size() > 0) {
            HashMap<String, Row> keys = new HashMap<String, Row>();
            for (Row row : rows) {
                if (keys.containsKey(row.rowKey)) {
                    Row currentRow = (Row)keys.get(row.rowKey);
                    if (currentRow.aggregated > row.aggregated) {
                        keys.put(currentRow.rowKey, row);
                    }
                    if (currentRow.aggregated != -1 || row.aggregated != -1) continue;
                    for (String cell : currentRow.cells.keySet()) {
                        Number currentCellVal = (Number)currentRow.cells.get(cell);
                        Number candidateVal = (Number)row.cells.get(cell);
                        if (!(candidateVal.doubleValue() > currentCellVal.doubleValue())) continue;
                        keys.put(currentRow.rowKey, row);
                    }
                    continue;
                }
                keys.put(row.rowKey, row);
            }
            rows = new ArrayList(keys.values());
        }
        for (Row row : rows) {
            if (row == null) continue;
            result.add(row);
        }
        return rows;
    }

    public Result buildReport(List<Item> sqlStatements, boolean isCreateRight) {
        JdbcTemplate jt = new JdbcTemplate(this.dataSource);
        Result report = new Result();
        if (isCreateRight) {
            report.info.setSqlStatements(sqlStatements);
        }
        String sql = ResultBuilder.findByLabel(sqlStatements, (String)"noAggregatesSQL").value;
        String sqlColumnTotal = ResultBuilder.findByLabel(sqlStatements, (String)"totalsColumnSQL").value;
        List<Column> columns = ResultBuilder.buildColumns(this.reportMetadata, this.columnElements);
        List<Row> rows = null;
        List<Row> totalColumns = null;
        try (Connection con = jt.getDataSource().getConnection();){
            rows = this.getRowsForReport(sql, con);
        }
        catch (Exception e) {
            this.logger.error((Object)e);
            e.printStackTrace();
            report.info.setSegmentCaption(this.reportMetadata.factTable.getCaption());
            report.info.setErrorMessage(e.getCause().getMessage());
            return report;
        }
        if (!this.reportMetadata.topDimensionAttributes.isEmpty()) {
            try {
                totalColumns = this.getTotalColumnResult(sqlColumnTotal, jt);
                ResultBuilder.setTotalColumnToColumns(columns, this.reportMetadata);
                ResultBuilder.setTotalColumnToRows(rows, totalColumns);
            }
            catch (Exception e) {
                e.printStackTrace();
                report.info.setErrorMessage("Die Gesamtspalte konnte nicht ermittelt werden.");
            }
        }
        ResultBuilder.setAttributesToReport(report, this.reportMetadata, rows, columns);
        try {
            if (this.reportMetadata.hideEmptyColumns) {
                ResultBuilder.removeEmptyColumns(columns, rows);
            }
        }
        catch (Exception e) {
            this.logger.error((Object)e);
        }
        return report;
    }

    public static void removeEmptyColumns(List<Column> columns, List<Row> rows) {
        HashMap<String, Integer> map = new HashMap<String, Integer>();
        for (Column col : columns) {
            if (map.containsKey(col.field)) continue;
            map.put(col.field, -1);
        }
        for (Row row : rows) {
            for (String cellKey : row.cells.keySet()) {
                Object value = row.cells.get(cellKey);
                if (value instanceof Number) {
                    Number val = (Number)value;
                    if (val.intValue() == 0 || !map.containsKey(cellKey)) continue;
                    map.remove(cellKey);
                    continue;
                }
                if (value == null || !map.containsKey(cellKey)) continue;
                map.remove(cellKey);
            }
        }
        for (Row row : rows) {
            for (String key : map.keySet()) {
                if (!row.cells.containsKey(key)) continue;
                row.cells.remove(key);
            }
        }
        if (rows.size() > 1) {
            Iterator<Column> iterator = columns.iterator();
            while (iterator.hasNext()) {
                if (!map.containsKey(iterator.next().field)) continue;
                iterator.remove();
            }
        }
    }

    public static void setAttributesToReport(Result report, ReportMetadata reportMetadata, List<Row> rows, List<Column> columns) {
        report.setResultType(ResultType.DrilldownTableGroupable);
        report.setRows(rows);
        report.setColumns(columns);
        if (reportMetadata.factTable.getCaption() != null) {
            report.info.setSegmentCaption(reportMetadata.factTable.getCaption());
            InfoItem facttableInfo = new InfoItem(reportMetadata.factTable.getId().composedId, reportMetadata.factTable.getCaption(), reportMetadata.factTable.getDescription());
            report.info.addFacttable(facttableInfo);
            report.info.addSachgebiet(reportMetadata.sachgebiet.name);
        }
        report.info.setMeasures(reportMetadata.getMeasureInfo());
        report.info.setLeftDimensionAttributes(reportMetadata.getLeftDimAttrAsInfo());
        report.info.setTopDimensionAttributes(reportMetadata.getTopDimAttrAsInfo());
        report.info.setFilter(reportMetadata.getFilterAsInfo());
        report.info.setLastUpdateBiad(reportMetadata.lastBiadUpdate);
        report.info.hideEmptyColumns(reportMetadata.hideEmptyColumns);
    }

    private static String getTotalCellHeaderPrefix(ReportMetadata reportMetadata) {
        Object totalCellHeaderPrefix = "";
        for (int i = 0; i < reportMetadata.topDimensionAttributes.size(); ++i) {
            DimensionAttribute attr = reportMetadata.topDimensionAttributes.get(i);
            totalCellHeaderPrefix = i == 0 ? (String)totalCellHeaderPrefix + ColumnElement.buildField(attr, "Gesamt") : (String)totalCellHeaderPrefix + ColumnElement.buildField(attr, " ");
        }
        totalCellHeaderPrefix = (String)totalCellHeaderPrefix + " || Kennzahl|";
        return totalCellHeaderPrefix;
    }

    private static String getTotalCellHeaderPrefixHeader(ReportMetadata reportMetadata) {
        Object totalCellHeaderPrefix = "";
        for (int i = 0; i < reportMetadata.topDimensionAttributes.size(); ++i) {
            DimensionAttribute attr = reportMetadata.topDimensionAttributes.get(i);
            totalCellHeaderPrefix = i == 0 ? (String)totalCellHeaderPrefix + attr.getCaption() + ": " + attr.getCaption() + "| Gesamt " : (String)totalCellHeaderPrefix + " || " + attr.getCaption() + ": " + attr.getCaption() + "|  ";
        }
        totalCellHeaderPrefix = (String)totalCellHeaderPrefix + " || Kennzahl|";
        return totalCellHeaderPrefix;
    }

    public List<Row> getTotalColumnResult(String sqlStatement, JdbcTemplate jt) {
        if (sqlStatement.isEmpty()) {
            return null;
        }
        List rows = null;
        rows = jt.query(sqlStatement, new Object[0], (RowMapper)new RowMapper<Row>(){

            public Row mapRow(ResultSet rs, int rowNum) {
                Row row = new Row();
                TreeMap<String, Object> cells = new TreeMap<String, Object>();
                int numCols = ResultBuilder.this.reportMetadata.maxBridgeLvl;
                try {
                    for (DimensionAttribute attr : ResultBuilder.this.reportMetadata.leftDimensionAttributes) {
                        if (attr.isHierarchy()) {
                            String prevCell = "";
                            for (int i = ResultBuilder.this.reportMetadata.minBridgeLvl; i < ResultBuilder.this.reportMetadata.maxBridgeLvl; ++i) {
                                Object cell = rs.getObject("col" + i);
                                if (cell == null || cell.equals(prevCell)) continue;
                                Object cellKey = attr.getStringId() + " (Ebene " + i + ")";
                                if (i == 0) {
                                    cellKey = attr.getStringId();
                                }
                                row.rowKey = row.rowKey + (String)cellKey + cell;
                                prevCell = (String)cell;
                            }
                            continue;
                        }
                        Object val = rs.getObject(attr.getDimensionColumnAlias());
                        if (val == null) continue;
                        String id = attr.getAttrConformedId();
                        if (id == null) {
                            id = attr.getStringId();
                        }
                        cells.put(id, val);
                        row.rowKey = row.rowKey + id + val;
                    }
                }
                catch (SQLException e) {
                    e.printStackTrace();
                }
                for (Measure measure : ResultBuilder.this.reportMetadata.measures) {
                    try {
                        String key = ResultBuilder.getTotalCellHeaderPrefix(ResultBuilder.this.reportMetadata) + measure.getId().composedId;
                        Object val = rs.getObject("col" + numCols++);
                        cells.put(key, val);
                    }
                    catch (SQLException e) {
                        e.printStackTrace();
                    }
                }
                row.cells = cells;
                return row;
            }
        });
        if (this.reportMetadata.getHierarchyAttributes().size() > 0) {
            HashMap<String, Row> rowKeyValue = new HashMap<String, Row>();
            for (Row row : rows) {
                boolean replace = false;
                if (rowKeyValue.containsKey(row.rowKey)) {
                    Row alreadyThere = (Row)rowKeyValue.get(row.rowKey);
                    for (String key : alreadyThere.cells.keySet()) {
                        Number alreadyVal;
                        Number candidateVal = (Number)row.cells.get(key);
                        if (candidateVal == null || (alreadyVal = (Number)alreadyThere.cells.get(key)) == null || !(candidateVal.doubleValue() > alreadyVal.doubleValue())) continue;
                        replace = true;
                    }
                    if (!replace) continue;
                    rowKeyValue.put(row.rowKey, row);
                    replace = false;
                    continue;
                }
                rowKeyValue.put(row.rowKey, row);
            }
            return new ArrayList<Row>(rowKeyValue.values());
        }
        return rows;
    }

    public static void setTotalColumnToRows(List<Row> rows, List<Row> result) {
        for (Row row : rows) {
            for (Row r : result) {
                if (!r.rowKey.equals(row.rowKey)) continue;
                row.cells.putAll(r.cells);
            }
        }
    }

    public static void setTotalColumnToColumns(List<Column> columns, ReportMetadata reportMetadata) {
        for (Measure measure : reportMetadata.measures) {
            String field = ResultBuilder.getTotalCellHeaderPrefix(reportMetadata) + measure.getId().composedId;
            String header = ResultBuilder.getTotalCellHeaderPrefixHeader(reportMetadata) + measure.getCaption();
            Column col = new Column(field, header, measure.getMeasureType(), false);
            col.setHidden(true);
            col.setTotalColumn(true);
            columns.add(col);
        }
    }

    private static Item findByLabel(List<Item> items, String label) {
        return items.stream().filter(s -> s.label.equals(label)).findAny().get();
    }
}

