/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.ReportDefinition;
import de.superx.bianalysis.metadata.Identifier;
import de.superx.bianalysis.models.DimensionAttribute;
import de.superx.bianalysis.models.FactTable;
import de.superx.bianalysis.models.Filter;
import de.superx.bianalysis.models.InfoItem;
import de.superx.bianalysis.models.Measure;
import de.superx.bianalysis.service.DbMetaAdapter;
import de.superx.jdbc.entity.Sachgebiet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;

public class ReportMetadata {
    public final FactTable factTable;
    public final Sachgebiet sachgebiet;
    public final List<DimensionAttribute> leftDimensionAttributes;
    public final List<DimensionAttribute> topDimensionAttributes;
    public final List<Measure> measures;
    public final List<Filter> filters;
    public String lastBiadUpdate;
    public int maxBridgeLvl;
    public int minBridgeLvl;
    public DbMetaAdapter dbMetaAdapter;
    public boolean hideEmptyColumns;

    public ReportMetadata(ReportDefinition reportDefinition, Identifier factTableId, DbMetaAdapter dbAdapter) {
        this.dbMetaAdapter = dbAdapter;
        if (factTableId == null) {
            this.factTable = new FactTable();
            this.sachgebiet = new Sachgebiet();
        } else {
            this.factTable = dbAdapter.getFactTable(factTableId);
            this.sachgebiet = dbAdapter.getSachgebietById(this.factTable.getSachgebiettid());
        }
        List<DimensionAttribute> databaseOrderedLeftDimensionAttributes = dbAdapter.getDimensionAttributeMetadata(reportDefinition.leftDimensionAttributeIds, factTableId);
        this.leftDimensionAttributes = ReportMetadata.reorderDimensionAttributesToReportOrder(databaseOrderedLeftDimensionAttributes, reportDefinition, false);
        List<DimensionAttribute> databaseOrderedTopDimensionAttributes = dbAdapter.getDimensionAttributeMetadata(reportDefinition.topDimensionAttributeIds, factTableId);
        this.topDimensionAttributes = ReportMetadata.reorderDimensionAttributesToReportOrder(databaseOrderedTopDimensionAttributes, reportDefinition, true);
        List<Measure> databaseOrderedMeasures = dbAdapter.getMeasureMetadata(reportDefinition.measureIds);
        this.measures = ReportMetadata.reorderMeasuresToReportOrder(databaseOrderedMeasures, reportDefinition);
        this.filters = reportDefinition.filters != null ? dbAdapter.getFilterMetadata(reportDefinition.filters) : new ArrayList<Filter>();
        this.setTopDimensionAttributeValues(dbAdapter);
        if (factTableId != null) {
            this.setMaxBridgeLvl();
        } else {
            this.setMaxBridgeLvlForConformed(reportDefinition.factTableIds);
        }
        this.lastBiadUpdate = dbAdapter.getLastUpdate(440);
        this.hideEmptyColumns = reportDefinition.hideEmptyColumns;
    }

    public ReportMetadata(ReportMetadata metadata, List<DimensionAttribute> leftDimensionAttributes) {
        this.dbMetaAdapter = metadata.dbMetaAdapter;
        this.factTable = metadata.factTable;
        this.sachgebiet = metadata.sachgebiet;
        this.topDimensionAttributes = metadata.topDimensionAttributes;
        this.measures = metadata.measures;
        this.filters = metadata.filters;
        this.leftDimensionAttributes = leftDimensionAttributes;
        this.hideEmptyColumns = metadata.hideEmptyColumns;
    }

    public ReportMetadata() {
        this.factTable = new FactTable();
        this.sachgebiet = new Sachgebiet();
        this.leftDimensionAttributes = new ArrayList<DimensionAttribute>();
        this.topDimensionAttributes = new ArrayList<DimensionAttribute>();
        this.measures = new ArrayList<Measure>();
        this.filters = new ArrayList<Filter>();
    }

    public List<DimensionAttribute> getSortOrderLeftDimensionAttributes() {
        return this.leftDimensionAttributes.stream().filter(d -> d.getSortOrderColumn() != null).collect(Collectors.toList());
    }

    private void setMaxBridgeLvl() {
        List attrs = this.leftDimensionAttributes.stream().filter(a -> a.isHierarchy()).collect(Collectors.toList());
        if (attrs.size() > 1) {
            throw new RuntimeException("NOT YET IMPLEMENTED: There can only be one hierarchy attribute.");
        }
        if (!attrs.isEmpty()) {
            this.maxBridgeLvl = this.dbMetaAdapter.getBridgeMaxLevel((DimensionAttribute)attrs.get(0), this);
            this.minBridgeLvl = this.dbMetaAdapter.getBridgeMinLevel(this.getHierarchyFilter(), this.maxBridgeLvl, ((DimensionAttribute)attrs.get(0)).getTablename());
        }
    }

    private void setMaxBridgeLvlForConformed(List<Identifier> factTableIds) {
        List attrs = this.leftDimensionAttributes.stream().filter(a -> a.isHierarchy()).collect(Collectors.toList());
        if (!attrs.isEmpty()) {
            DimensionAttribute attr = (DimensionAttribute)attrs.get(0);
            int lvl = 0;
            for (Identifier fact : factTableIds) {
                String name = this.dbMetaAdapter.getFactTableNameMaxBridgeLvl(fact, attr.getId());
                if (name == null || name.isBlank()) continue;
                int value = -1;
                Identifier checkedAttr = this.dbMetaAdapter.checkIfFactTableHasDimensionAttribute(attr.getId(), fact);
                if (checkedAttr != null && !checkedAttr.equals(attr.getId())) {
                    DimensionAttribute rolePlayingAttribute = this.dbMetaAdapter.getDimensionAttributeMetadataById(checkedAttr);
                    value = this.dbMetaAdapter.getBridgeMaxLevel(rolePlayingAttribute, this, name);
                }
                if (value <= lvl) continue;
                lvl = value;
            }
            this.maxBridgeLvl = lvl;
        }
    }

    private void setTopDimensionAttributeValues(DbMetaAdapter dbAdapter) {
        for (DimensionAttribute attr : this.topDimensionAttributes) {
            Filter filter = this.getFilterForDimensionAttribute(attr.getId());
            if (filter != null) {
                attr.setDimensionAttributeValues(filter.filterValues);
                continue;
            }
            attr.setDimensionAttributeValues(dbAdapter.getDimensionAttributeValues(attr, null, null));
        }
    }

    private Filter getFilterForDimensionAttribute(Identifier id) {
        return this.filters.stream().filter(f -> f.dimensionAttributeId.equals(id)).findFirst().orElse(null);
    }

    private static List<Measure> reorderMeasuresToReportOrder(List<Measure> measures, ReportDefinition reportDefinition) {
        ArrayList<Measure> orderedMeasures = new ArrayList<Measure>();
        reportDefinition.measureIds.forEach(measureId -> {
            Measure nextMeasure = measures.stream().filter(measure -> measure.getId().equals(measureId)).findFirst().orElse(null);
            orderedMeasures.add(nextMeasure);
        });
        return orderedMeasures;
    }

    public static List<DimensionAttribute> reorderDimensionAttributesToReportOrder(List<DimensionAttribute> dimensionAttributes, ReportDefinition reportDefinition, boolean isTopAttribute) {
        ArrayList<DimensionAttribute> orderedDimensionAttributes = new ArrayList<DimensionAttribute>();
        List<Identifier> attributeIds = isTopAttribute ? reportDefinition.topDimensionAttributeIds : reportDefinition.leftDimensionAttributeIds;
        attributeIds.forEach(attributeId -> {
            DimensionAttribute nextAttribute = dimensionAttributes.stream().filter(dimensionAttribute -> dimensionAttribute.getId().equals(attributeId)).findFirst().orElse(null);
            orderedDimensionAttributes.add(nextAttribute);
        });
        return orderedDimensionAttributes;
    }

    public DimensionAttribute getDimById(Identifier id) {
        DimensionAttribute attr = this.topDimensionAttributes.stream().filter(a -> a.getDimensionId().equals(id)).findFirst().orElse(null);
        if (attr != null) {
            return attr;
        }
        attr = this.leftDimensionAttributes.stream().filter(a -> a.getDimensionId().equals(id)).findFirst().orElse(null);
        return attr;
    }

    public DimensionAttribute getDimAttrById(Identifier id) {
        DimensionAttribute attr = this.topDimensionAttributes.stream().filter(a -> a.getId().equals(id)).findFirst().orElse(null);
        if (attr != null) {
            return attr;
        }
        attr = this.leftDimensionAttributes.stream().filter(a -> a.getId().equals(id)).findFirst().orElse(null);
        return attr;
    }

    public List<DimensionAttribute> getUniqueDimensionAttributes() {
        DimensionAttribute attr;
        Identifier attrId;
        HashMap<String, DimensionAttribute> joinTables = new HashMap<String, DimensionAttribute>();
        for (DimensionAttribute attr2 : this.leftDimensionAttributes) {
            if (joinTables.containsKey(attr2.getDimensionTableAlias())) continue;
            joinTables.put(attr2.getDimensionTableAlias(), attr2);
        }
        for (DimensionAttribute attr2 : this.topDimensionAttributes) {
            if (joinTables.containsKey(attr2.getDimensionTableAlias())) continue;
            joinTables.put(attr2.getDimensionTableAlias(), attr2);
        }
        for (Filter filter : this.filters) {
            attrId = filter.dimensionAttributeId;
            attr = this.dbMetaAdapter.getDimensionAttributeMetadataById(attrId);
            if (joinTables.containsKey(attr.getDimensionTableAlias())) continue;
            joinTables.put(attr.getDimensionTableAlias(), attr);
        }
        for (Measure measure : this.measures) {
            if (measure.filterAttributeId == null || joinTables.containsKey((attr = this.dbMetaAdapter.getDimensionAttributeMetadataById(attrId = measure.filterAttributeId)).getDimensionTableAlias())) continue;
            joinTables.put(attr.getDimensionTableAlias(), attr);
        }
        return new ArrayList<DimensionAttribute>(joinTables.values());
    }

    public List<InfoItem> getMeasureInfo() {
        if (this.measures != null && !this.measures.isEmpty()) {
            return this.measures.stream().map(m -> new InfoItem(m.getId().composedId, m.getCaption(), m.getDescription())).collect(Collectors.toList());
        }
        return null;
    }

    public List<InfoItem> getTopDimAttrAsInfo() {
        if (this.topDimensionAttributes != null && !this.topDimensionAttributes.isEmpty()) {
            return this.topDimensionAttributes.stream().map(m -> new InfoItem(m.getStringId(), m.getCaption(), m.getDescription())).collect(Collectors.toList());
        }
        return null;
    }

    public List<Filter> getFilterNoHierarchy() {
        ArrayList<Filter> filterNoBridge = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            DimensionAttribute attr = this.dbMetaAdapter.getDimensionAttributeById(filter.dimensionAttributeId);
            if (attr.isHierarchy()) continue;
            filterNoBridge.add(filter);
        }
        return filterNoBridge;
    }

    public List<InfoItem> getLeftDimAttrAsInfo() {
        if (this.leftDimensionAttributes != null && !this.leftDimensionAttributes.isEmpty()) {
            return this.leftDimensionAttributes.stream().map(m -> new InfoItem(m.getStringId(), m.getCaption(), m.getDescription())).collect(Collectors.toList());
        }
        return null;
    }

    public List<String> getFilterAsInfo() {
        ArrayList<String> filterList = new ArrayList<String>();
        for (Filter filter : this.filters) {
            DimensionAttribute dimAttr = filter.getDimAttribute(this);
            if (dimAttr == null) {
                dimAttr = this.dbMetaAdapter.getDimensionAttributeById(filter.dimensionAttributeId);
            }
            filterList.add(" (" + dimAttr.getCaption() + ") " + filter.getValuesAsString());
        }
        return filterList;
    }

    public List<DimensionAttribute> getHierarchyAttributes() {
        return this.leftDimensionAttributes.stream().filter(a -> a.isHierarchy()).collect(Collectors.toList());
    }

    public List<Filter> getHierarchyFilter() {
        ArrayList<Filter> hierarchyFilter = new ArrayList<Filter>();
        for (Filter filter : this.filters) {
            if (!this.isHierarchyFilter(filter)) continue;
            hierarchyFilter.add(filter);
        }
        return hierarchyFilter;
    }

    public boolean isHierarchyFilter(Filter filter) {
        return this.dbMetaAdapter.isAttributeHierarchyBridge(filter.dimensionAttributeId);
    }
}

