/*
 * Decompiled with CFR 0.152.
 */
package de.superx.bianalysis;

import de.superx.bianalysis.models.InfoItem;
import de.superx.rest.model.Column;
import de.superx.rest.model.ColumnType;
import de.superx.rest.model.Result;
import de.superx.rest.model.ResultType;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Footer;
import org.apache.poi.ss.usermodel.Header;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExcelSheetBuilder {
    private Result result;
    private XSSFWorkbook workbook;
    private XSSFSheet sheet;
    private String reportName;
    private String reportDescription;
    private String date;
    private int leftDimensionAttributes;
    private int topDimensionAttributes = 0;
    private List<Column> visibleColumns;
    private final boolean mergeCells = true;
    private final int startingRow = 1;
    private static HashMap<String, Integer> defaultStyles = new HashMap();

    public ExcelSheetBuilder(Result result) {
        this.result = result;
        this.visibleColumns = ExcelSheetBuilder.getVisibleColumns(result);
        this.workbook = new XSSFWorkbook();
        this.initializeDefaultStyles();
        this.leftDimensionAttributes = this.result.info.leftDimensionAttributes.size();
        if (this.result.info.topDimensionAttributes != null && this.result.info.topDimensionAttributes.size() > 0) {
            this.topDimensionAttributes = this.result.info.topDimensionAttributes.size();
        }
    }

    public XSSFWorkbook build() {
        int rowNum = 1;
        rowNum = this.createRowsFromGrid(this.createReportInfoGrid(), rowNum);
        int reportInfoEnd = rowNum += 2;
        String[][] grid = this.createHeaderGrid();
        rowNum = this.createRowsFromGrid(grid, rowNum);
        rowNum = this.createDataRows(rowNum);
        rowNum = this.createTotalRow(rowNum);
        this.mergeHeaderCells(grid, 0, reportInfoEnd);
        this.styleHeaderCells(reportInfoEnd, grid);
        this.styleDataCells(reportInfoEnd + grid.length);
        this.styleTotalRowCells(rowNum);
        this.styleReportInfoCells();
        Footer footer = this.sheet.getFooter();
        Header header = this.sheet.getHeader();
        header.setLeft(this.reportName);
        header.setRight(this.date);
        footer.setRight("Seite &P von &N");
        return this.workbook;
    }

    private void initializeDefaultStyles() {
        XSSFCellStyle infoStyle = this.workbook.createCellStyle();
        XSSFFont infoFont = this.workbook.createFont();
        infoFont.setBold(true);
        infoStyle.setFont((Font)infoFont);
        defaultStyles.put("info", Integer.valueOf(infoStyle.getIndex()));
        XSSFCellStyle headerStyle = this.workbook.createCellStyle();
        headerStyle.setBorderBottom(BorderStyle.THIN);
        headerStyle.setBorderLeft(BorderStyle.THIN);
        headerStyle.setBorderRight(BorderStyle.THIN);
        headerStyle.setBorderTop(BorderStyle.THIN);
        XSSFFont headerFont = this.workbook.createFont();
        headerFont.setBold(true);
        headerStyle.setFont((Font)headerFont);
        defaultStyles.put("header", Integer.valueOf(headerStyle.getIndex()));
        XSSFCellStyle dataStyle = this.workbook.createCellStyle();
        dataStyle.setBorderBottom(BorderStyle.HAIR);
        dataStyle.setBorderLeft(BorderStyle.HAIR);
        dataStyle.setBorderRight(BorderStyle.HAIR);
        dataStyle.setBorderTop(BorderStyle.HAIR);
        defaultStyles.put("data", Integer.valueOf(dataStyle.getIndex()));
        XSSFCellStyle totalStyle = this.workbook.createCellStyle();
        totalStyle.setBorderBottom(BorderStyle.THIN);
        totalStyle.setBorderLeft(BorderStyle.THIN);
        totalStyle.setBorderRight(BorderStyle.THIN);
        totalStyle.setBorderTop(BorderStyle.DOUBLE);
        XSSFFont totalFont = this.workbook.createFont();
        totalFont.setBold(true);
        totalStyle.setFont((Font)totalFont);
        defaultStyles.put("total", Integer.valueOf(totalStyle.getIndex()));
    }

    private void styleTotalRowCells(int rowNum) {
        int current = rowNum;
        XSSFRow row = this.sheet.getRow(--current);
        for (int i = 0; i < this.visibleColumns.size(); ++i) {
            Cell cell = row.getCell(i);
            cell.setCellStyle(ExcelSheetBuilder.getTotalCellStyle(this.workbook));
        }
    }

    private int createTotalRow(int startFrom) {
        de.superx.rest.model.Row totalRow = this.result.getTotalRow();
        int rowNum = startFrom;
        XSSFRow row = this.sheet.createRow(rowNum++);
        Cell labelCell = row.createCell(0);
        labelCell.setCellValue("Gesamt");
        for (int i = 1; i < this.visibleColumns.size(); ++i) {
            Column col = this.visibleColumns.get(i);
            Cell cell = row.createCell(i);
            if (col.type.equals((Object)ColumnType.StringColumn)) {
                cell.setCellValue("");
                continue;
            }
            Object obj = totalRow.cells.get(col.field);
            if (obj == null) {
                cell.setCellValue("");
                continue;
            }
            Double value = Double.valueOf(String.valueOf(obj));
            cell.setCellValue(value.doubleValue());
        }
        return rowNum;
    }

    private void styleReportInfoCells() {
        XSSFRow row = this.sheet.getRow(1);
        Cell cell = row.getCell(0);
        cell.setCellStyle((CellStyle)this.workbook.getCellStyleAt(defaultStyles.get("info").intValue()));
    }

    private String[][] createReportInfoGrid() {
        ArrayList<List<String>> gridList = new ArrayList<List<String>>();
        gridList.add(List.of("Informationen zur BI-Analyse", ""));
        gridList.add(List.of("Name:", this.reportName));
        gridList.add(List.of("Beschreibung:", this.reportDescription));
        String sachgebiet = this.result.info.sachgebiete.stream().collect(Collectors.joining(", "));
        String theme = ExcelSheetBuilder.getInfoCaptions(this.result.info.facttables);
        String measures = ExcelSheetBuilder.getInfoCaptions(this.result.info.measures);
        String topAttributes = ExcelSheetBuilder.getInfoCaptions(this.result.info.topDimensionAttributes);
        String leftAttributes = ExcelSheetBuilder.getInfoCaptions(this.result.info.leftDimensionAttributes);
        String filter = this.result.info.filter.stream().collect(Collectors.joining(", "));
        String lastUpdateBad = this.result.info.lastUpdateBiad;
        if (sachgebiet != null) {
            gridList.add(List.of("Sachgebiet:", sachgebiet));
        }
        if (theme != null) {
            gridList.add(List.of("Thema:", theme));
        }
        if (measures != null) {
            gridList.add(List.of("Kennzahlen:", measures));
        }
        if (leftAttributes != null) {
            gridList.add(List.of("Zeilenattribute:", leftAttributes));
        }
        if (topAttributes != null) {
            gridList.add(List.of("Spaltenattribute:", topAttributes));
        }
        if (filter != null) {
            gridList.add(List.of("Filter:", filter));
        }
        if (lastUpdateBad != null) {
            gridList.add(List.of("Letztes Update von BI-Analyse-Daten:", lastUpdateBad));
        }
        if (this.result.resultType.equals((Object)ResultType.FlatTable)) {
            gridList.add(List.of("Tabellentyp:", "Flache Tabelle"));
        } else if (this.result.resultType.equals((Object)ResultType.DrilldownTableGroupable)) {
            gridList.add(List.of("Tabellentyp:", "Hierarchische Tabelle"));
        }
        return ExcelSheetBuilder.listToStringGrid(gridList);
    }

    private static String getInfoCaptions(List<InfoItem> infoItems) {
        if (infoItems != null && infoItems.size() > 0) {
            return infoItems.stream().map(f -> f.caption).collect(Collectors.joining(", "));
        }
        return "";
    }

    private static String[][] listToStringGrid(List<List<String>> list) {
        String[][] result = new String[list.size()][list.get(0).size()];
        for (int i = 0; i < result.length; ++i) {
            for (int j = 0; j < result[i].length; ++j) {
                result[i][j] = list.get(i).get(j);
            }
        }
        return result;
    }

    private static CellRangeAddress mergeCellByOffset(int firstRow, int lastRow, int firstCol, int lastCol, int xOffset, int yOffset) {
        return new CellRangeAddress(firstRow + yOffset, lastRow + yOffset, firstCol + xOffset, lastCol + xOffset);
    }

    private void styleHeaderCells(int start, String[][] grid) {
        for (int i = 0; i < grid.length; ++i) {
            XSSFRow row = this.sheet.getRow(i + start);
            row.setHeightInPoints(25.0f);
            for (int j = 0; j < grid[i].length; ++j) {
                Cell cell = row.getCell(j);
                cell.setCellStyle(ExcelSheetBuilder.getHeaderStyle(this.workbook));
            }
        }
    }

    private static CellStyle getHeaderStyle(XSSFWorkbook workbook) {
        return workbook.getCellStyleAt(defaultStyles.get("header").intValue());
    }

    private static CellStyle getDataCellStyle(XSSFWorkbook workbook) {
        return workbook.getCellStyleAt(defaultStyles.get("data").intValue());
    }

    private static CellStyle getTotalCellStyle(XSSFWorkbook workbook) {
        return workbook.getCellStyleAt(defaultStyles.get("total").intValue());
    }

    private void styleDataCells(int startDataCells) {
        for (int i = startDataCells; i < startDataCells + this.result.rows.size(); ++i) {
            XSSFRow row = this.sheet.getRow(i);
            for (int j = 0; j < this.visibleColumns.size(); ++j) {
                Cell cell = row.getCell(j);
                if (this.visibleColumns.get((int)j).groupable) {
                    cell.setCellStyle(ExcelSheetBuilder.getHeaderStyle(this.workbook));
                    continue;
                }
                cell.setCellStyle(ExcelSheetBuilder.getDataCellStyle(this.workbook));
            }
        }
    }

    private void mergeHeaderCells(String[][] grid, int xOffset, int yOffset) {
        int i;
        if (this.topDimensionAttributes > 0) {
            for (i = 0; i < grid.length; ++i) {
                int j;
                String lastCell = "";
                int cellsToMerge = 0;
                for (j = 0; j < grid[i].length; ++j) {
                    String currentCell = grid[i][j];
                    if (!currentCell.equals(lastCell) && cellsToMerge > 0) {
                        this.sheet.addMergedRegion(ExcelSheetBuilder.mergeCellByOffset(i, i, j - cellsToMerge - 1, j - 1, xOffset, yOffset));
                    }
                    cellsToMerge = currentCell.equals(lastCell) ? ++cellsToMerge : 0;
                    lastCell = currentCell;
                }
                if (cellsToMerge <= 0) continue;
                j = grid[i].length - 1;
                this.sheet.addMergedRegion(ExcelSheetBuilder.mergeCellByOffset(i, i, j - cellsToMerge, j, xOffset, yOffset));
            }
        }
        if (grid.length > 1) {
            for (i = 0; i < this.leftDimensionAttributes; ++i) {
                this.sheet.addMergedRegion(ExcelSheetBuilder.mergeCellByOffset(0, grid.length - 1, i, i, xOffset, yOffset));
            }
        }
    }

    private int createRowsFromGrid(String[][] grid, int startFrom) {
        if (grid == null) {
            return startFrom;
        }
        int rowNum = startFrom;
        for (int i = 0; i < grid.length; ++i) {
            XSSFRow poiRow = this.sheet.createRow(rowNum++);
            int colNum = 0;
            for (int j = 0; j < grid[i].length; ++j) {
                Cell cell = poiRow.createCell(colNum++);
                if (grid[i][j] != null && !grid[i][j].isBlank()) {
                    cell.setCellValue(grid[i][j]);
                    continue;
                }
                cell.setBlank();
            }
        }
        return rowNum;
    }

    private int createDataRows(int startFrom) {
        int i;
        int rowNum = startFrom;
        List resultRows = this.result.rows.stream().filter(r -> r.aggregated != -1).collect(Collectors.toList());
        Row[] rows = new Row[resultRows.size()];
        for (i = 0; i < resultRows.size(); ++i) {
            rows[i] = this.sheet.createRow(rowNum++);
            rows[i].setHeightInPoints(20.0f);
        }
        for (i = 0; i < this.visibleColumns.size(); ++i) {
            Column col = this.visibleColumns.get(i);
            for (int j = 0; j < resultRows.size(); ++j) {
                Object obj = ((de.superx.rest.model.Row)resultRows.get((int)j)).cells.get(col.field);
                String objVal = String.valueOf(obj);
                Cell cell = rows[j].createCell(i);
                if (obj == null) {
                    cell.setBlank();
                    continue;
                }
                if (col.type == ColumnType.IntegerColumn || col.type == ColumnType.DecimalColumn) {
                    Double value = Double.valueOf(objVal);
                    cell.setCellValue(value.doubleValue());
                    continue;
                }
                cell.setCellValue(obj.toString());
            }
        }
        return rowNum;
    }

    private String[][] createHeaderGrid() {
        int colSize = this.visibleColumns.size();
        int rowSize = this.topDimensionAttributes + 1;
        String[][] grid = new String[rowSize][colSize];
        for (int i = 0; i < colSize; ++i) {
            Column column = this.visibleColumns.get(i);
            String[] columnHeader = column.header.split("\\|\\|");
            boolean isLeftDimensionAttributeColumn = columnHeader.length == 1 && !columnHeader[0].contains("|");
            for (int j = 0; j < rowSize; ++j) {
                if (isLeftDimensionAttributeColumn) {
                    grid[j][i] = columnHeader[0];
                    continue;
                }
                String header = columnHeader[j];
                String[] headerValues = header.split("\\|");
                grid[j][i] = headerValues[1];
            }
        }
        return grid;
    }

    public ExcelSheetBuilder withFileName(String name) {
        this.sheet = this.workbook.createSheet(name);
        return this;
    }

    public ExcelSheetBuilder withReportName(String name) {
        this.reportName = ExcelSheetBuilder.replaceEmptyString(name, "Nicht gespeicherte BI-Analyse");
        return this;
    }

    public ExcelSheetBuilder withDescription(String description) {
        this.reportDescription = ExcelSheetBuilder.replaceEmptyString(description, "-");
        return this;
    }

    private static String replaceEmptyString(String value, String replacement) {
        if (value == null || value.isBlank()) {
            return replacement;
        }
        return value;
    }

    public ExcelSheetBuilder withDate(Date currentDate) {
        this.date = new SimpleDateFormat("dd.MM.yyyy HH:mm").format(currentDate);
        return this;
    }

    private static List<Column> getVisibleColumns(Result result) {
        return result.columns.stream().filter(col -> !col.hidden).collect(Collectors.toList());
    }
}

