/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.StringWriter;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.log4j.Logger;
import org.dom4j.Document;
import org.dom4j.io.DOMReader;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.w3c.dom.CharacterData;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class XMLUtils {
    private static DocumentBuilderFactory factory = null;
    private static DocumentBuilder builder = null;
    private static Logger logger = Logger.getLogger(XMLUtils.class);

    private XMLUtils() {
    }

    public static DocumentBuilderFactory createSecureDocumentBuilderFactory() {
        XMLUtils.init();
        return factory;
    }

    private static void init() {
        if (factory == null) {
            try {
                factory = DocumentBuilderFactory.newInstance();
                factory.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                factory.setXIncludeAware(false);
                builder = factory.newDocumentBuilder();
                builder.setErrorHandler(new DTDErrorHandler());
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)"Couldn't initialize XMLUtils", (Throwable)e);
            }
        }
    }

    public static org.w3c.dom.Document buildDocument(File f) throws IOException, SAXException {
        return XMLUtils.buildDocument(f, false);
    }

    public static org.w3c.dom.Document buildDocument(File file, boolean isValidating) throws IOException, SAXException {
        XMLUtils.init();
        factory.setValidating(isValidating);
        org.w3c.dom.Document document = null;
        if (!file.canRead()) {
            throw new IOException("can't read file " + file.getAbsolutePath());
        }
        document = builder.parse(file);
        return document;
    }

    public static org.w3c.dom.Document buildDocument(InputStream in, boolean isValidating) throws SAXException, IOException {
        XMLUtils.init();
        factory.setValidating(isValidating);
        org.w3c.dom.Document document = null;
        document = builder.parse(in);
        return document;
    }

    public static org.w3c.dom.Document buildDocumentFromString(String input, boolean isValidating) throws SAXException, IOException {
        XMLUtils.init();
        factory.setValidating(isValidating);
        org.w3c.dom.Document document = null;
        InputSource is = new InputSource(new StringReader(input));
        document = builder.parse(is);
        return document;
    }

    public static org.w3c.dom.Document buildDocumentFromString(StringBuffer input, boolean isValidating) throws SAXException, IOException {
        XMLUtils.init();
        factory.setValidating(isValidating);
        org.w3c.dom.Document document = null;
        InputSource is = new InputSource(new StringReader(input.toString()));
        document = builder.parse(is);
        return document;
    }

    public static org.w3c.dom.Document buildDocumentFromStringWithException(String input, boolean isValidating) throws SAXException, IOException {
        XMLUtils.init();
        factory.setValidating(isValidating);
        InputSource is = new InputSource(new StringReader(input));
        org.w3c.dom.Document document = null;
        try {
            document = builder.parse(is);
        }
        catch (SAXException sex) {
            logger.error((Object)"Couldn't parse XML", (Throwable)sex);
            throw sex;
        }
        return document;
    }

    public static org.w3c.dom.Document buildDocumentFromString2(String input, boolean isValidating) throws Exception {
        XMLUtils.init();
        factory.setValidating(isValidating);
        InputSource is = new InputSource(new StringReader(input));
        return builder.parse(is);
    }

    public static org.w3c.dom.Document buildDocumentFromXmlUrl(String url, boolean isValidating) throws SAXException, IOException {
        XMLUtils.init();
        factory.setValidating(isValidating);
        org.w3c.dom.Document document = null;
        document = builder.parse(url);
        return document;
    }

    public static boolean hasAttrib(Node node, String attribname) {
        if (node == null) {
            throw new IllegalArgumentException("node is null - can't check");
        }
        if (attribname == null) {
            throw new IllegalArgumentException("attribname is null - can't check");
        }
        NamedNodeMap map = node.getAttributes();
        boolean result = false;
        if (map != null && map.getNamedItem(attribname) != null) {
            result = true;
        }
        return result;
    }

    public static String getAttribValue(Node node, String attribname) {
        return XMLUtils.getNamedItemValueFromAttribs(node, attribname);
    }

    public static void setAttribValue(Node node, String name, String value) {
        Element e = (Element)node;
        e.setAttribute(name, value);
    }

    public static String getTheValue(Node node) {
        String result = "";
        if (node == null) {
            throw new IllegalArgumentException("Node is null can't get value");
        }
        Node n = node.getFirstChild();
        if (n == null) {
            throw new IllegalArgumentException("Node " + node + " can't get value - no child node found");
        }
        if (n.getNodeType() == 3) {
            result = n.getNodeValue();
        }
        if (n.getNodeType() == 4) {
            CharacterData txt = (CharacterData)n;
            result = txt.getData();
        }
        return result;
    }

    public static String getChildNodeValues(Node node) {
        Object result = "";
        if (node == null) {
            throw new IllegalArgumentException("Node is null can't get value");
        }
        NodeList mynodes = node.getChildNodes();
        int anz = mynodes.getLength();
        for (int i = 0; i <= anz; ++i) {
            Node child = mynodes.item(i);
            if (child == null) continue;
            if (child.getNodeType() == 3) {
                result = (String)result + child.getNodeValue();
            }
            if (child.getNodeType() != 4) continue;
            CharacterData txt = (CharacterData)child;
            result = (String)result + txt.getData();
        }
        return result;
    }

    public static boolean hasValue(Node node) {
        Node firstChildNode;
        boolean result = false;
        if (node == null) {
            throw new IllegalArgumentException("Node is null can't check");
        }
        if (node.hasChildNodes() && ((firstChildNode = node.getFirstChild()).getNodeType() == 3 || firstChildNode.getNodeType() == 4)) {
            result = true;
        }
        return result;
    }

    public static Iterator<Node> getChildNodeIterator(Node aNode) {
        LinkedList<Node> result = new LinkedList<Node>();
        NodeList rawList = aNode.getChildNodes();
        for (int i2 = 0; i2 < rawList.getLength(); ++i2) {
            Node n = rawList.item(i2);
            if (n.getNodeType() == 3 || n.getNodeType() == 8) continue;
            result.add(n);
        }
        return result.iterator();
    }

    public static String getChildNodeValue(Node node, String name) {
        String result = null;
        Node childnode = XMLUtils.getChildNode(node, name);
        if (childnode.hasChildNodes()) {
            result = childnode.getFirstChild().getNodeValue();
        }
        return result;
    }

    public static int getNodeCount(org.w3c.dom.Document document, String name) {
        NodeList list = document.getElementsByTagName(name);
        return list.getLength();
    }

    public static Node getFirstNode(org.w3c.dom.Document document, String name) {
        if (XMLUtils.getNodeCount(document, name) == 0) {
            throw new IllegalArgumentException("No node with name:" + name + " found");
        }
        NodeList list = document.getElementsByTagName(name);
        return list.item(0);
    }

    public static String getFirstNodeValue(org.w3c.dom.Document document, String nodename) {
        Node node = XMLUtils.getFirstNode(document, nodename);
        return XMLUtils.getTheValue(node);
    }

    public static Node getFirstNodeWithNameAndAttrib(org.w3c.dom.Document document, String nodename, String attribname, String attribvalue) {
        Node result = null;
        NodeList list = document.getElementsByTagName(nodename);
        for (int i = 0; i < list.getLength(); ++i) {
            Node n = list.item(i);
            if (!XMLUtils.hasAttrib(n, attribname) || !XMLUtils.getAttribValue(n, attribname).equals(attribvalue)) continue;
            result = n;
            break;
        }
        return result;
    }

    public static boolean hasANodeWithName(org.w3c.dom.Document document, String name) {
        return XMLUtils.getNodeCount(document, name) > 0;
    }

    public static boolean hasChildNode(Node node, String name) {
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            return true;
        }
        return false;
    }

    public static Node getChildNode(Node node, String name) {
        NodeList nl = node.getChildNodes();
        Node childnode = null;
        for (int i = 0; i < nl.getLength(); ++i) {
            Node n = nl.item(i);
            if (!n.getNodeName().equals(name)) continue;
            childnode = n;
        }
        if (childnode == null) {
            throw new IllegalArgumentException("Node " + node + " doesn't have a child " + name);
        }
        return childnode;
    }

    public static List getListWithValuesOfNodes(Node node, String childnodename) {
        LinkedList<String> result = new LinkedList<String>();
        NodeList nl = node.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node aNode = nl.item(i);
            if (!aNode.getNodeName().equals(childnodename)) continue;
            result.add(aNode.getFirstChild().getNodeValue());
        }
        return result;
    }

    public static List getListWithAttribOfNodes(Node parentNode, String acceptedChildNodeName, String attribName) {
        LinkedList<String> result = new LinkedList<String>();
        NodeList nl = parentNode.getChildNodes();
        for (int i = 0; i < nl.getLength(); ++i) {
            Node aNode = nl.item(i);
            if (!aNode.getNodeName().equals(acceptedChildNodeName)) continue;
            result.add(XMLUtils.getAttribValue(aNode, attribName));
        }
        return result;
    }

    private static String getNamedItemValueFromAttribs(Node node, String name) {
        String result = "";
        NamedNodeMap attribs = node.getAttributes();
        if (attribs == null) {
            throw new RuntimeException("node " + node + " doesn't habe attribs - was looking for attrib:" + name);
        }
        Node node2 = attribs.getNamedItem(name);
        if (node2 == null) {
            throw new RuntimeException("node " + node + " doesn't habe attribute:" + name);
        }
        result = node2.getNodeValue();
        return result;
    }

    public static int getChildNodeCount(Node aNode, String name) {
        int result = 0;
        NodeList rawList = aNode.getChildNodes();
        for (int i2 = 0; i2 < rawList.getLength(); ++i2) {
            Node n = rawList.item(i2);
            if (n.getNodeType() == 3 || n.getNodeType() == 8 || !n.getNodeName().equals(name)) continue;
            ++result;
        }
        return result;
    }

    public static int getChildNodeCount(Node aNode) {
        int result = 0;
        NodeList rawList = aNode.getChildNodes();
        for (int i2 = 0; i2 < rawList.getLength(); ++i2) {
            Node n = rawList.item(i2);
            if (n.getNodeType() == 3 || n.getNodeType() == 8) continue;
            ++result;
        }
        return result;
    }

    public static String removeTroublesomeCharacters(StringBuffer inString) {
        return XMLUtils.removeTroublesomeCharacters(inString.toString());
    }

    public static String removeTroublesomeCharactersXX(String inString) {
        String xx = "";
        String n = "";
        Charset charset = Charset.forName("ISO-8859-1");
        CharsetDecoder decoder = charset.newDecoder();
        CharsetEncoder encoder = charset.newEncoder();
        for (int iCount = 128; iCount <= 165; ++iCount) {
            xx = Character.valueOf((char)iCount).toString();
            try {
                n = new String(xx.getBytes("ISO-8859-1"));
                ByteBuffer bbuf = encoder.encode(CharBuffer.wrap(xx));
                CharBuffer cbuf = decoder.decode(bbuf);
                n = cbuf.toString();
                inString = StringUtils.replace(inString, xx, n);
            }
            catch (Exception ex) {
                System.out.println(ex.toString());
            }
            long iValue = xx.charAt(0);
        }
        for (int i = 0; i < inString.length(); ++i) {
            if (inString.charAt(i) <= '\u007f' || inString.charAt(i) >= '\u00ff') continue;
            System.out.println("pos " + i + " " + inString.charAt(i));
        }
        return inString;
    }

    public static String removeTroublesomeCharacters(String input) {
        if (input == null) {
            return null;
        }
        String output = input;
        int l1 = 150;
        int l2 = 151;
        int l3 = 132;
        int l4 = 152;
        int l5 = 147;
        int l6 = 148;
        int l7 = 145;
        int l8 = 146;
        int l9 = 128;
        int l10 = 133;
        int l11 = 149;
        output = output.replace((char)l1, '-');
        output = output.replace((char)l2, '-');
        output = output.replace((char)l3, '\"');
        output = output.replace((char)l4, '\"');
        output = output.replace((char)l5, '\"');
        output = output.replace((char)l6, '\"');
        output = StringUtils.replace(output, "" + (char)l9, "EUR");
        output = output.replace((char)l7, '\'');
        output = output.replace((char)l8, '\'');
        output = output.replace((char)l10, '\u00e0');
        output = output.replace((char)l11, ' ');
        output = output.replace('\u0093', ' ');
        output = output.replace('\u0095', '-');
        StringBuilder newString = new StringBuilder();
        for (int i = 0; i < output.length(); ++i) {
            char ch = output.charAt(i);
            if ((ch >= '\u00fd' || ch <= '\u001f') && ch != '\t' && ch != '\r' && ch != '\n') continue;
            newString.append(ch);
        }
        return newString.toString();
    }

    public static org.w3c.dom.Document parseXml(String xmlString) throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory myFactory = DocumentBuilderFactory.newInstance();
        myFactory.setNamespaceAware(true);
        DocumentBuilder myBuilder = myFactory.newDocumentBuilder();
        org.w3c.dom.Document myDocument = myBuilder.parse(new InputSource(new StringReader(xmlString)));
        return myDocument;
    }

    public static Document convertDocument(org.w3c.dom.Document w3cDoc) {
        DOMReader reader = new DOMReader();
        Document document = reader.read(w3cDoc);
        return document;
    }

    public static void writeXmlFile(org.w3c.dom.Document w3cDoc, File targetFile, String encoding) throws TransformerFactoryConfigurationError, TransformerException, IOException {
        DOMSource domSource = new DOMSource(w3cDoc);
        Transformer transformer = TransformerFactory.newInstance().newTransformer();
        transformer.setOutputProperty("omit-xml-declaration", "no");
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("encoding", encoding);
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        StringWriter sw = new StringWriter();
        StreamResult sr = new StreamResult(sw);
        transformer.transform(domSource, sr);
        FileWriter fw = new FileWriter(targetFile);
        fw.write(sw.toString());
        fw.flush();
        fw.close();
    }

    public static org.w3c.dom.Document replaceMultipleUnloadJobs(File xmlFile, File xmlUnloadFile) {
        org.w3c.dom.Document modulDoc = null;
        try {
            modulDoc = XMLUtils.buildDocument(xmlFile, false);
            if (xmlUnloadFile.exists()) {
                org.w3c.dom.Document unloadDoc = XMLUtils.buildDocument(xmlUnloadFile, false);
                NodeList modulUnloadJobs = modulDoc.getElementsByTagName("unload-job");
                for (int i = 0; i < modulUnloadJobs.getLength(); ++i) {
                    Element modulUnloadJob = (Element)modulUnloadJobs.item(i);
                    String id = modulUnloadJob.getAttribute("id");
                    Node unloadJobNode = XMLUtils.findUnloadJobNode(unloadDoc, id);
                    if (unloadJobNode == null) continue;
                    Node parent = modulUnloadJob.getParentNode();
                    Node importedNode = modulDoc.importNode(unloadJobNode, true);
                    parent.replaceChild(importedNode, modulUnloadJob);
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return modulDoc;
    }

    private static Node findUnloadJobNode(org.w3c.dom.Document doc, String id) {
        NodeList nodeList = doc.getElementsByTagName("unload-job");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element element = (Element)nodeList.item(i);
            if (!id.equals(element.getAttribute("id"))) continue;
            return element;
        }
        return null;
    }

    private static void saveDocument(org.w3c.dom.Document doc, String filePath) throws TransformerException {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        Transformer transformer = transformerFactory.newTransformer();
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult result = new StreamResult(new File(filePath));
        transformer.transform(source, result);
    }

    public static String documentToString(org.w3c.dom.Document w3cDoc, String encoding) throws TransformerFactoryConfigurationError, TransformerException {
        DOMSource domSource = new DOMSource(w3cDoc);
        StringWriter writer = new StringWriter();
        StreamResult result = new StreamResult(writer);
        TransformerFactory tf = TransformerFactory.newInstance();
        Transformer transformer = tf.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "4");
        transformer.setOutputProperty("indent", "yes");
        if (encoding != null) {
            transformer.setOutputProperty("encoding", encoding);
        }
        transformer.transform(domSource, result);
        return writer.toString();
    }

    public static void writeXmlFile(Document doc, File outfile, String encoding) throws IOException {
        FileOutputStream fos = new FileOutputStream(outfile);
        OutputFormat format = OutputFormat.createPrettyPrint();
        format.setNewLineAfterDeclaration(false);
        format.setEncoding(encoding);
        XMLWriter writer = new XMLWriter((OutputStream)fos, format);
        writer.write(doc);
        writer.flush();
        writer.close();
        fos.close();
    }

    static class DTDErrorHandler
    implements ErrorHandler {
        DTDErrorHandler() {
        }

        @Override
        public void warning(SAXParseException error) throws RuntimeException {
            new RuntimeException("XML-Parse Exception Zeile: " + error.getLineNumber() + "\nDatei: " + error.getSystemId() + "\n" + error.getMessage());
        }

        @Override
        public void error(SAXParseException error) throws RuntimeException {
            new RuntimeException("XML-Parse Exception Zeile: " + error.getLineNumber() + "\nDatei: " + error.getSystemId() + "\n" + error.getMessage());
        }

        @Override
        public void fatalError(SAXParseException error) throws RuntimeException {
            new RuntimeException("XML-Parse Exception Zeile: " + error.getLineNumber() + "\nDatei: " + error.getSystemId() + "\n" + error.getMessage());
        }
    }
}

