/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import de.memtext.baseobjects.IdObjectI;
import de.memtext.rights.Allowable;
import de.memtext.tree.TreeEntryI;
import de.memtext.util.StringUtils;
import de.superx.common.SelectableItemNode;
import java.util.Enumeration;
import java.util.LinkedList;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class TreeUtils {
    private TreeUtils() {
    }

    public static void stripNode(DefaultMutableTreeNode node, int maxDescendents) {
        while (TreeUtils.countDescendents(node) > maxDescendents) {
            TreeUtils.removeLevel(node, node.getLevel() + node.getDepth());
        }
    }

    public static int getMaxLevel(DefaultMutableTreeNode node, int maxDescendents) {
        int maxLevel = node.getDepth();
        while (TreeUtils.countDescendents(node, maxLevel) > maxDescendents) {
            if (--maxLevel >= 0) continue;
            throw new RuntimeException("");
        }
        return maxLevel;
    }

    public static void removeLevel(DefaultMutableTreeNode node, int level) {
        LinkedList<DefaultMutableTreeNode> removeNodes = new LinkedList<DefaultMutableTreeNode>();
        Enumeration<TreeNode> en = node.preorderEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode n = (DefaultMutableTreeNode)en.nextElement();
            if (n.getLevel() != level) continue;
            removeNodes.add(n);
        }
        for (DefaultMutableTreeNode n : removeNodes) {
            n.removeFromParent();
        }
    }

    public static int countDescendents(DefaultMutableTreeNode node, int maxDepth) {
        int result = 0;
        if (maxDepth < 0 || node.getLevel() + 1 <= maxDepth) {
            result = node.getChildCount();
        }
        if (maxDepth < 0 || node.getLevel() + 2 <= maxDepth) {
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode n = (DefaultMutableTreeNode)node.getChildAt(i);
                if (n.isLeaf()) continue;
                result += TreeUtils.countDescendents(n, maxDepth);
            }
        }
        return result;
    }

    public static int countDescendents(DefaultMutableTreeNode node) {
        return TreeUtils.countDescendents(node, -1);
    }

    public static String toString(DefaultMutableTreeNode root) {
        StringBuffer buf = new StringBuffer();
        Enumeration<TreeNode> en = root.preorderEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)en.nextElement();
            for (int i = 0; i < node.getLevel(); ++i) {
                buf.append(" ");
            }
            buf.append(node.toString() + "\n");
        }
        return buf.toString();
    }

    private static void quickSort(DefaultMutableTreeNode[] a, int lo0, int hi0, boolean ascending, int posInText) {
        int lo = lo0;
        int hi = hi0;
        if (hi0 > lo0) {
            DefaultMutableTreeNode mid = a[(lo0 + hi0) / 2];
            while (lo <= hi) {
                if (ascending) {
                    while (lo < hi0 && a[lo].toString().substring(posInText).compareTo(mid.toString().substring(posInText)) < 0) {
                        ++lo;
                    }
                    while (hi > lo0 && a[hi].toString().substring(posInText).compareTo(mid.toString().substring(posInText)) > 0) {
                        --hi;
                    }
                } else {
                    while (lo < hi0 && a[lo].toString().substring(posInText).compareTo(mid.toString().substring(posInText)) > 0) {
                        ++lo;
                    }
                    while (hi > lo0 && a[hi].toString().substring(posInText).compareTo(mid.toString().substring(posInText)) < 0) {
                        --hi;
                    }
                }
                if (lo > hi) continue;
                DefaultMutableTreeNode T = a[lo];
                a[lo] = a[hi];
                a[hi] = T;
                ++lo;
                --hi;
            }
            if (lo0 < hi) {
                TreeUtils.quickSort(a, lo0, hi, ascending, posInText);
            }
            if (lo < hi0) {
                TreeUtils.quickSort(a, lo, hi0, ascending, posInText);
            }
        }
    }

    private static void sortChildren(DefaultMutableTreeNode root, boolean ascending, boolean sortByName) {
        int i;
        int NmbChildren = root.getChildCount();
        int startAt = 0;
        DefaultMutableTreeNode[] arrayOfNodes = new DefaultMutableTreeNode[NmbChildren];
        for (i = 0; i < NmbChildren; ++i) {
            arrayOfNodes[i] = (DefaultMutableTreeNode)root.getChildAt(i);
        }
        TreeUtils.quickSort(arrayOfNodes, 0, arrayOfNodes.length - 1, ascending, startAt);
        root.setAllowsChildren(false);
        root.setAllowsChildren(true);
        for (i = 0; i < arrayOfNodes.length; ++i) {
            root.add(arrayOfNodes[i]);
        }
    }

    public static String getSubordinateKeyList(DefaultMutableTreeNode startNode, boolean checkAllowed, boolean ignoreErrors) {
        StringBuffer buf = new StringBuffer("");
        Enumeration<TreeNode> en = startNode.breadthFirstEnumeration();
        while (en.hasMoreElements()) {
            TreeNode node = en.nextElement();
            if (checkAllowed && (!(node instanceof Allowable) || !((Allowable)((Object)node)).isAllowed()) || ignoreErrors && !(node instanceof IdObjectI)) continue;
            IdObjectI idObject = (IdObjectI)((Object)node);
            String key = idObject.getId() == null ? "null" : (idObject.getId() instanceof String ? TreeUtils.getKeyInclLiveMapping(idObject) : idObject.getId().toString());
            buf.append(key + ",");
        }
        if (buf.length() > 0 && StringUtils.getLastChar(buf) == ',') {
            StringUtils.removeFromEnd(buf, ",", true);
        }
        return buf.toString();
    }

    private static String getKeyInclLiveMapping(IdObjectI idObject) {
        Object result = "";
        if (idObject instanceof SelectableItemNode) {
            SelectableItemNode sn = (SelectableItemNode)idObject;
            result = sn.getKeysInclLiveMapping();
        } else {
            result = "'" + idObject.getId() + "'";
        }
        return result;
    }

    public static String getOwnAndParentsKeyList(DefaultMutableTreeNode startNode, boolean checkAllowed, boolean ignoreErrors) {
        if (checkAllowed) {
            throw new RuntimeException("endlosschleife");
        }
        StringBuffer buf = new StringBuffer("(");
        Object key = "";
        DefaultMutableTreeNode node = startNode;
        boolean done = false;
        while (node != null) {
            if (checkAllowed && (!(node instanceof Allowable) || !((Allowable)((Object)node)).isAllowed()) || ignoreErrors && !(node instanceof IdObjectI) && !(node instanceof TreeEntryI)) continue;
            if (node instanceof IdObjectI) {
                IdObjectI idObject = (IdObjectI)((Object)node);
                key = idObject.getId() == null ? "null" : (idObject.getId() instanceof String ? TreeUtils.getKeyInclLiveMapping(idObject) : idObject.getId().toString());
            }
            if (node instanceof TreeEntryI) {
                TreeEntryI treeEntry = (TreeEntryI)((Object)node);
                key = treeEntry.getOwnKey() == null ? "null" : (treeEntry.getOwnKey() instanceof String ? "'" + treeEntry.getOwnKey() + "'" : treeEntry.getOwnKey().toString());
            }
            buf.append((String)key + ",");
            node = (DefaultMutableTreeNode)node.getParent();
        }
        if (StringUtils.getLastChar(buf) == ',') {
            StringUtils.removeFromEnd(buf, ",", true);
        }
        return buf + ")";
    }

    public static void sort(DefaultMutableTreeNode root) {
        Enumeration<TreeNode> en = root.depthFirstEnumeration();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode aNode = (DefaultMutableTreeNode)en.nextElement();
            if (aNode.isLeaf()) continue;
            TreeUtils.sortChildren(aNode, true, true);
        }
    }

    public static void expandAll(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtils.expandOrCollapseAll(tree, new TreePath(root), true);
    }

    public static void collapseAll(JTree tree) {
        TreeNode root = (TreeNode)tree.getModel().getRoot();
        TreeUtils.expandOrCollapseAll(tree, new TreePath(root), false);
    }

    public static void collapseAll(JTree tree, DefaultMutableTreeNode node) {
        TreeUtils.expandOrCollapseAll(tree, new TreePath(node), false);
    }

    public static void collapseAll(JTree tree, TreePath tp) {
        if (tp == null) {
            return;
        }
        Object node = tp.getLastPathComponent();
        TreeModel model = tree.getModel();
        if (!model.isLeaf(node)) {
            tree.collapsePath(tp);
            for (int i = 0; i < model.getChildCount(node); ++i) {
                TreeUtils.collapseAll(tree, tp.pathByAddingChild(model.getChild(node, i)));
            }
            tree.collapsePath(tp);
        }
    }

    private static void expandOrCollapseAll(JTree tree, TreePath parent, boolean expand) {
        TreeNode node = (TreeNode)parent.getLastPathComponent();
        if (node.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> e = node.children();
            while (e.hasMoreElements()) {
                TreeNode n = e.nextElement();
                TreePath path = parent.pathByAddingChild(n);
                TreeUtils.expandOrCollapseAll(tree, path, expand);
            }
        }
        if (expand) {
            tree.expandPath(parent);
        } else {
            tree.collapsePath(parent);
        }
    }

    public static String toHierString(Enumeration en, String separator) {
        StringBuffer result = new StringBuffer();
        while (en.hasMoreElements()) {
            DefaultMutableTreeNode anode = (DefaultMutableTreeNode)en.nextElement();
            result.append(anode + separator);
        }
        StringUtils.removeFromEnd(result, separator, true);
        return result.toString();
    }

    public static String toHierString(DefaultMutableTreeNode node, String separator) {
        return TreeUtils.toHierString(node.preorderEnumeration(), separator);
    }
}

