/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.util;

import java.io.ByteArrayOutputStream;
import java.security.InvalidKeyException;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.DSAPrivateKey;
import java.security.interfaces.DSAPublicKey;
import java.security.spec.InvalidKeySpecException;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Hashtable;
import java.util.StringTokenizer;

public class DSAHandler {
    private Signature dsa = Signature.getInstance("SHA1withDSA");
    private Signature dsa2;
    private PrivateKey privateKey;
    private PublicKey publicKey;

    public DSAHandler(String privateKeyEncoded) throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException {
        this(privateKeyEncoded, null);
    }

    public DSAHandler(String privateKeyEncoded, String publicKeyEncoded) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException {
        PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(DSAHandler.getBytes(privateKeyEncoded));
        KeyFactory keyFactory = KeyFactory.getInstance("DSA");
        this.privateKey = keyFactory.generatePrivate(keyspec);
        this.dsa.initSign(this.privateKey);
        if (publicKeyEncoded != null) {
            this.dsa2 = Signature.getInstance("SHA1withDSA");
            X509EncodedKeySpec xkeyspec = new X509EncodedKeySpec(DSAHandler.getBytes(publicKeyEncoded));
            KeyFactory keyFactory2 = KeyFactory.getInstance("DSA");
            this.publicKey = keyFactory2.generatePublic(xkeyspec);
            this.dsa2.initVerify(this.publicKey);
        }
    }

    private static String getString(byte[] bytes) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < bytes.length; ++i) {
            byte b = bytes[i];
            sb.append(0xFF & b);
            if (i + 1 >= bytes.length) continue;
            sb.append("-");
        }
        return sb.toString();
    }

    private static byte[] getBytes(String str) {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        StringTokenizer st = new StringTokenizer(str, "-", false);
        while (st.hasMoreTokens()) {
            int i = Integer.parseInt(st.nextToken());
            bos.write((byte)i);
        }
        return bos.toByteArray();
    }

    public String sign(String data) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        this.dsa.update(data.getBytes());
        byte[] signature = this.dsa.sign();
        String signed = DSAHandler.getString(signature);
        return signed;
    }

    public boolean verify(String data, String signed) throws NoSuchAlgorithmException, InvalidKeySpecException, InvalidKeyException, SignatureException {
        if (this.dsa2 == null) {
            throw new IllegalStateException("no public key passed for verification");
        }
        this.dsa2.update(data.getBytes());
        boolean verifies = false;
        try {
            if (signed == null) {
                signed = "";
            }
            verifies = this.dsa2.verify(DSAHandler.getBytes(signed));
        }
        catch (Exception e) {
            verifies = false;
        }
        return verifies;
    }

    public static Hashtable generateKeyPair() throws Exception {
        Hashtable<String, String> table = new Hashtable<String, String>();
        KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
        gen.initialize(1024);
        KeyPair kp = gen.generateKeyPair();
        DSAPrivateKey privateKey = (DSAPrivateKey)kp.getPrivate();
        String privateKeyEncoded = DSAHandler.getString(privateKey.getEncoded());
        table.put("privatekey", privateKeyEncoded);
        DSAPublicKey publicKey = (DSAPublicKey)kp.getPublic();
        String encodedPublicKey = DSAHandler.getString(publicKey.getEncoded());
        table.put("publickey", encodedPublicKey);
        return table;
    }

    public static void test() throws InvalidKeyException, NoSuchAlgorithmException, InvalidKeySpecException, SignatureException {
        DSAHandler dsa = new DSAHandler("48-130-1-75-2-1-0-48-130-1-44-6-7-42-134-72-206-56-4-1-48-130-1-31-2-129-129-0-253-127-83-129-29-117-18-41-82-223-74-156-46-236-228-231-246-17-183-82-60-239-68-0-195-30-63-128-182-81-38-105-69-93-64-34-81-251-89-61-141-88-250-191-197-245-186-48-246-203-155-85-108-215-129-59-128-29-52-111-242-102-96-183-107-153-80-165-164-159-159-232-4-123-16-34-194-79-187-169-215-254-183-198-27-248-59-87-231-198-168-166-21-15-4-251-131-246-211-197-30-195-2-53-84-19-90-22-145-50-246-117-243-174-43-97-215-42-239-242-34-3-25-157-209-72-1-199-2-21-0-151-96-80-143-21-35-11-204-178-146-185-130-162-235-132-11-240-88-28-245-2-129-129-0-247-225-160-133-214-155-61-222-203-188-171-92-54-184-87-185-121-148-175-187-250-58-234-130-249-87-76-11-61-7-130-103-81-89-87-142-186-212-89-79-230-113-7-16-129-128-180-73-22-113-35-232-76-40-22-19-183-207-9-50-140-200-166-225-60-22-122-139-84-124-141-40-224-163-174-30-43-179-166-117-145-110-163-127-11-250-33-53-98-241-251-98-122-1-36-59-204-164-241-190-168-81-144-137-168-131-223-225-90-229-159-6-146-139-102-94-128-123-85-37-100-1-76-59-254-207-73-42-4-22-2-20-99-162-225-203-33-237-32-121-170-46-64-177-141-247-95-155-123-240-65-44", "48-130-1-184-48-130-1-44-6-7-42-134-72-206-56-4-1-48-130-1-31-2-129-129-0-253-127-83-129-29-117-18-41-82-223-74-156-46-236-228-231-246-17-183-82-60-239-68-0-195-30-63-128-182-81-38-105-69-93-64-34-81-251-89-61-141-88-250-191-197-245-186-48-246-203-155-85-108-215-129-59-128-29-52-111-242-102-96-183-107-153-80-165-164-159-159-232-4-123-16-34-194-79-187-169-215-254-183-198-27-248-59-87-231-198-168-166-21-15-4-251-131-246-211-197-30-195-2-53-84-19-90-22-145-50-246-117-243-174-43-97-215-42-239-242-34-3-25-157-209-72-1-199-2-21-0-151-96-80-143-21-35-11-204-178-146-185-130-162-235-132-11-240-88-28-245-2-129-129-0-247-225-160-133-214-155-61-222-203-188-171-92-54-184-87-185-121-148-175-187-250-58-234-130-249-87-76-11-61-7-130-103-81-89-87-142-186-212-89-79-230-113-7-16-129-128-180-73-22-113-35-232-76-40-22-19-183-207-9-50-140-200-166-225-60-22-122-139-84-124-141-40-224-163-174-30-43-179-166-117-145-110-163-127-11-250-33-53-98-241-251-98-122-1-36-59-204-164-241-190-168-81-144-137-168-131-223-225-90-229-159-6-146-139-102-94-128-123-85-37-100-1-76-59-254-207-73-42-3-129-133-0-2-129-129-0-173-249-1-200-111-178-86-229-143-74-255-43-195-147-70-225-219-229-126-18-191-233-96-18-139-198-134-117-53-214-109-204-84-10-165-5-208-23-187-189-12-129-242-38-74-59-245-208-115-104-100-38-2-237-201-242-68-84-199-34-253-135-233-35-46-192-95-85-93-226-159-194-23-25-50-186-177-113-140-77-147-218-209-108-87-115-217-101-168-171-255-157-90-185-229-138-1-222-202-241-10-92-15-49-82-233-242-155-109-55-62-42-106-241-168-142-149-42-55-200-129-217-229-191-192-100-51-181");
        String test = "abc";
        System.out.println(dsa.verify(test, dsa.sign(test)));
        test = "abc2";
        System.out.println(dsa.verify(test, dsa.sign(test)));
    }

    public static void test_alt() {
        try {
            KeyPairGenerator gen = KeyPairGenerator.getInstance("DSA");
            gen.initialize(1024);
            KeyPair kp = gen.generateKeyPair();
            DSAPrivateKey privateKey = (DSAPrivateKey)kp.getPrivate();
            System.out.println("private:\n" + DSAHandler.getString(privateKey.getEncoded()));
            String privateKeyEncoded = DSAHandler.getString(privateKey.getEncoded());
            PKCS8EncodedKeySpec keyspec = new PKCS8EncodedKeySpec(DSAHandler.getBytes(privateKeyEncoded));
            KeyFactory keyFactory = KeyFactory.getInstance("DSA");
            PrivateKey privateKey2 = keyFactory.generatePrivate(keyspec);
            System.out.println(privateKey2);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] a) {
        try {
            DSAHandler.test();
        }
        catch (Exception e) {
            e.printStackTrace();
            System.out.println("Es ist ein Fehler aufgetreten: " + e);
        }
    }
}

