/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree.admin;

import de.memtext.db.DBAccess;
import de.memtext.tree.admin.AdminTreeModel;
import de.memtext.tree.admin.EntryNode;
import de.memtext.tree.admin.Status;
import java.awt.event.ActionEvent;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;

public class SaveAction
extends AbstractAction {
    private AdminTreeModel model;

    public SaveAction(AdminTreeModel model) {
        if (model == null) {
            throw new RuntimeException("Model must not be null!");
        }
        this.model = model;
    }

    public SaveAction(String name, AdminTreeModel model) {
        super(name);
        if (model == null) {
            throw new RuntimeException("Model must not be null!");
        }
        this.model = model;
    }

    public SaveAction(String name, Icon icon, AdminTreeModel model) {
        super(name, icon);
        if (model == null) {
            throw new RuntimeException("Model must not be null!");
        }
        this.model = model;
    }

    @Override
    public void actionPerformed(ActionEvent arg1) {
        Status.getInstance().setBusy();
        try {
            DBAccess.get("RecursiveTableAdmin").execute("delete from " + this.model.getTablename() + " where 1=1");
            DefaultMutableTreeNode root = (DefaultMutableTreeNode)this.model.getRoot();
            TreeNode node = null;
            Enumeration<TreeNode> en = root.depthFirstEnumeration();
            while (en.hasMoreElements()) {
                EntryNode entryNode;
                node = en.nextElement();
                if (!(node instanceof EntryNode) || (entryNode = (EntryNode)node).isRoot()) continue;
                DBAccess.get("RecursiveTableAdmin").execute(entryNode.getInsertCommand(this.model.getTablename()));
            }
            Status.getInstance().setIdle();
            Status.getInstance().setSaveNecessary(false);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

