/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import de.memtext.baseobjects.NamedIdObjectWithParentI;
import de.memtext.baseobjects.coll.NamedIdObjectWithParentList;
import de.memtext.time.EphemeralI;
import de.memtext.tree.KeyParentEqualException;
import de.memtext.tree.NoMainEntryException;
import de.memtext.tree.TreeEntryI;
import de.memtext.tree.TreeEntryNode;
import de.memtext.widgets.NodeSelectionPanel;
import de.superx.common.SelectableItemNode;
import java.awt.Frame;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;

public class TreeBuilder {
    private static Collection _elementCollection;
    private static NamedIdObjectWithParentList _nodeList;

    private TreeBuilder() {
    }

    private static void addNodesToRoot2(DefaultMutableTreeNode root, NamedIdObjectWithParentList rawList) throws NoMainEntryException {
        _nodeList = TreeBuilder.toNodeList(rawList);
        rawList = null;
        TreeBuilder.insertNodes2(root, null);
    }

    private static NamedIdObjectWithParentList toNodeList(NamedIdObjectWithParentList rawList) {
        NamedIdObjectWithParentList result = new NamedIdObjectWithParentList();
        for (NamedIdObjectWithParentI element : rawList) {
            result.add(new TreeEntryNode(element));
        }
        return result;
    }

    private static void insertNodes2(DefaultMutableTreeNode presentNode, Object theParent) throws NoMainEntryException {
        if (_nodeList == null) {
            throw new RuntimeException("node list is null, set it before");
        }
        NamedIdObjectWithParentList result = (NamedIdObjectWithParentList)_nodeList.getByParent(theParent);
        if (theParent == null && result.size() == 0) {
            StringBuffer buf = new StringBuffer("These elements in collection\n");
            for (TreeEntryI element : _elementCollection) {
                buf.append(element.toString() + "\n");
            }
            throw new NoMainEntryException(buf.toString());
        }
        for (TreeEntryNode newNode : result) {
            presentNode.add(newNode);
            TreeBuilder.insertNodes2(newNode, newNode.getOwnKey());
        }
    }

    public static NodeSelectionPanel createNodeSelectionPanel(Frame owner, String infoText, NamedIdObjectWithParentList rawList) throws NoMainEntryException {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode("root");
        TreeBuilder.addNodesToRoot2(root, rawList);
        JTree tree = new JTree(root);
        tree.setRootVisible(false);
        NodeSelectionPanel nsp = new NodeSelectionPanel(owner, infoText, tree);
        return nsp;
    }

    @Deprecated
    public static void addNodesToRoot(DefaultMutableTreeNode root, Collection elementCollection) throws NoMainEntryException, KeyParentEqualException {
        _elementCollection = elementCollection;
        TreeBuilder.insertnodes(root, null);
    }

    @Deprecated
    private static void insertnodes(DefaultMutableTreeNode presentNode, Object theParent) throws NoMainEntryException, KeyParentEqualException {
        if (_elementCollection == null) {
            throw new RuntimeException("element collection is null, set it before");
        }
        Collection result = TreeBuilder.getEntries(theParent);
        if (theParent == null && result.size() == 0) {
            StringBuffer buf = new StringBuffer("These elements in collection\n");
            for (TreeEntryI element : _elementCollection) {
                buf.append(element.toString() + "\n");
            }
            throw new NoMainEntryException(buf.toString());
        }
        for (DefaultMutableTreeNode newNode : result) {
            presentNode.add(newNode);
            TreeEntryI newEntry = (TreeEntryI)((Object)newNode);
            Object keyOfNewNode = newEntry.getOwnKey();
            if (keyOfNewNode != null && theParent == null) {
                TreeBuilder.insertnodes(newNode, keyOfNewNode);
            }
            if (keyOfNewNode == null && theParent == null) {
                throw new KeyParentEqualException(newEntry);
            }
            if (keyOfNewNode == null || theParent == null) continue;
            if (!theParent.equals(keyOfNewNode)) {
                TreeBuilder.insertnodes(newNode, keyOfNewNode);
                continue;
            }
            throw new KeyParentEqualException(newEntry);
        }
    }

    @Deprecated
    private static Collection getEntries(Object checkparent) {
        LinkedList<TreeEntryI> result = new LinkedList<TreeEntryI>();
        for (TreeEntryI anEntry : _elementCollection) {
            Object entrysParent = anEntry.getParentKey();
            if (entrysParent == null && checkparent == null) {
                result.add(anEntry);
            }
            if (entrysParent == null || checkparent == null || !entrysParent.equals(checkparent)) continue;
            result.add(anEntry);
        }
        return result;
    }

    public static void addNodesToRootFromMap(DefaultMutableTreeNode root, HashMap map, Date stand) throws NoMainEntryException, KeyParentEqualException {
        NodeInserter inserter = new NodeInserter(map);
        inserter.insertNodesFromMap(root, null, stand);
    }

    public static void addNodesToRootFromMap(DefaultMutableTreeNode root, Object parentKey, HashMap map, Date stand) throws NoMainEntryException, KeyParentEqualException {
        NodeInserter inserter = new NodeInserter(map);
        inserter.insertNodesFromMap(root, parentKey, stand);
    }

    public static void addNodesToRootFromMapByLid(DefaultMutableTreeNode root, String parentLid, HashMap map, Date stand) throws NoMainEntryException, KeyParentEqualException {
        NodeInserterLid inserter = new NodeInserterLid(map);
        inserter.insertNodesFromMap(root, parentLid, stand);
    }

    public static void add(HashMap map, TreeEntryI item) {
        TreeBuilder.add(map, item, item.getParentKey());
    }

    public static void add(HashMap map, Object item, Object parent) {
        TreeSet<Object> col;
        Object obj = map.get(parent);
        if (obj == null) {
            col = new TreeSet<Object>();
            map.put(parent, col);
        } else {
            col = (TreeSet<Object>)obj;
        }
        col.add(item);
    }

    private static class NodeInserter {
        private Map elementMap;

        NodeInserter(Map map) {
            this.elementMap = map;
            if (this.elementMap == null) {
                throw new RuntimeException("element map must not be null");
            }
        }

        void insertNodesFromMap(DefaultMutableTreeNode presentNode, Object theParent, Date stand) throws NoMainEntryException, KeyParentEqualException {
            Object obj = this.elementMap.get(theParent);
            TreeSet result = obj == null ? new TreeSet() : (TreeSet)obj;
            if (theParent == null) {
                this.checkAtLeastOneChild(result);
            }
            for (DefaultMutableTreeNode newNode : result) {
                EphemeralI potentialNewEntry;
                TreeEntryI newEntry = (TreeEntryI)((Object)newNode);
                if (stand != null && !(potentialNewEntry = (EphemeralI)((Object)newEntry)).isValidAt(stand)) continue;
                try {
                    presentNode.add(newNode);
                }
                catch (IllegalArgumentException e) {
                    throw new IllegalArgumentException("Konnte Knoten " + newEntry.getOwnKey() + "nicht einf\u00fcgen unter " + theParent + " " + e);
                }
                Object keyOfNewNode = newEntry.getOwnKey();
                if (keyOfNewNode != null && theParent == null) {
                    this.insertNodesFromMap(newNode, keyOfNewNode, stand);
                }
                if (keyOfNewNode == null || theParent == null) continue;
                if (!theParent.equals(keyOfNewNode)) {
                    this.insertNodesFromMap(newNode, keyOfNewNode, stand);
                    continue;
                }
                throw new KeyParentEqualException(newEntry);
            }
        }

        private void checkAtLeastOneChild(Collection result) throws NoMainEntryException {
            if (result.size() == 0) {
                StringBuffer buf = new StringBuffer("These elements in collection\n");
                for (Collection c : this.elementMap.values()) {
                    for (TreeEntryI element : c) {
                        buf.append(element.toString() + "\n");
                    }
                }
                throw new NoMainEntryException(buf.toString());
            }
        }
    }

    private static class NodeInserterLid {
        private Map elementMap;

        NodeInserterLid(Map map) {
            this.elementMap = map;
            if (this.elementMap == null) {
                throw new RuntimeException("element map must not be null");
            }
        }

        void insertNodesFromMap(DefaultMutableTreeNode presentNode, Object theParent, Date stand) throws NoMainEntryException, KeyParentEqualException {
            Object obj = this.elementMap.get(theParent);
            TreeSet result = obj == null ? new TreeSet() : (TreeSet)obj;
            if (theParent == null) {
                this.checkAtLeastOneChild(result);
            }
            Iterator it = result.iterator();
            while (it.hasNext()) {
                EphemeralI potentialNewEntry;
                SelectableItemNode newNode;
                SelectableItemNode newEntry = newNode = (SelectableItemNode)it.next();
                if (stand != null && !(potentialNewEntry = (EphemeralI)((Object)newEntry)).isValidAt(stand)) continue;
                try {
                    presentNode.add(newNode);
                }
                catch (IllegalArgumentException e) {
                    String add = "";
                    if (theParent != null && theParent.equals("") || newNode.getLid() != null && newNode.equals("")) {
                        add = " Achtung wurde versucht unter parent bzw parent_lid Leerstring einzuh\u00e4ngen, es darf in der Quelltabelle nicht Eintr\u00e4ge mit sowohl parent/parent_lid null als auch Leerstring geben";
                    }
                    throw new IllegalArgumentException("Konnte Knoten " + newNode.getName() + " Schl\u00fcssel " + newNode.getOwnKey() + " (lid:" + newNode.getLid() + ") nicht einf\u00fcgen unter Schl\u00fcssel:" + theParent + " (lid:" + newNode.getLid() + ") " + add + " " + e);
                }
                String lidOfNewNode = newNode.getLid();
                if (lidOfNewNode != null && theParent == null) {
                    this.insertNodesFromMap(newNode, lidOfNewNode, stand);
                }
                if (lidOfNewNode == null || theParent == null) continue;
                if (!theParent.equals(lidOfNewNode)) {
                    this.insertNodesFromMap(newNode, lidOfNewNode, stand);
                    continue;
                }
                throw new KeyParentEqualException(newEntry);
            }
        }

        private void checkAtLeastOneChild(Collection result) throws NoMainEntryException {
            if (result.size() == 0) {
                StringBuffer buf = new StringBuffer("These elements in collection\n");
                for (Collection c : this.elementMap.values()) {
                    for (TreeEntryI element : c) {
                        buf.append(element.toString() + "\n");
                    }
                }
                throw new NoMainEntryException(buf.toString());
            }
        }
    }
}

