/*
 * Decompiled with CFR 0.152.
 */
package de.memtext.tree;

import java.lang.reflect.Method;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;

public class CheckBoxNodeDec
extends DefaultMutableTreeNode {
    private DefaultMutableTreeNode internalNode;
    public static final int SINGLE_SELECTION = 0;
    public static final int DIG_IN_SELECTION = 4;
    private static final Class[] booleanparam = new Class[]{Boolean.TYPE};
    protected int selectionMode;
    protected boolean isSelected;
    protected boolean isCheckBoxVisible;
    private Method setMethod = null;

    public CheckBoxNodeDec(DefaultMutableTreeNode node, String setMethodName, boolean isCheckBoxVisible) {
        super(node.getUserObject());
        this.isCheckBoxVisible = isCheckBoxVisible;
        this.internalNode = node;
        this.setSelectionMode(4);
        if (setMethodName != null) {
            try {
                this.setMethod = node.getClass().getMethod(setMethodName, booleanparam);
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
                System.exit(-1);
            }
        }
    }

    public DefaultMutableTreeNode getInternalNode() {
        return this.internalNode;
    }

    public void setSelectionMode(int mode) {
        this.selectionMode = mode;
    }

    public int getSelectionMode() {
        return this.selectionMode;
    }

    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
        if (this.setMethod != null) {
            try {
                Object[] param = new Object[]{isSelected};
                this.setMethod.invoke((Object)this.internalNode, param);
            }
            catch (Exception e) {
                e.printStackTrace();
                System.exit(-1);
            }
            if (this.selectionMode == 4 && this.children != null) {
                Enumeration en = this.children.elements();
                while (en.hasMoreElements()) {
                    CheckBoxNodeDec node = (CheckBoxNodeDec)en.nextElement();
                    node.setSelected(isSelected);
                }
            }
        }
    }

    public boolean isSelected() {
        return this.isSelected;
    }

    public boolean isCheckBoxVisible() {
        return this.isCheckBoxVisible;
    }

    public void setCheckBoxVisible(boolean b) {
        this.isCheckBoxVisible = b;
    }
}

