/**
 * <p>This package provides utility routines for handling integer sets and maps.</p>
 * <p>The main classes are <code>IntSet</code> which represents a set of 32-bit integers
 * (int values), <code>IntIterator</code> which is an iterator over a sequence of 32-bit
 * integers, <code>IntHashMap</code> which is a map from 32-bit integers to arbitrary
 * objects, and <code>IntToIntMap</code> which is a map from 32-bit integers to 32-bit
 * integers.</p>
 * <p>The package name is a pun on the conventional use by mathematicians
 * of the symbol <b>Z</b> to denote the set of all natural integers.</p>
 * <hr>
 * <p align="center"><i>Michael H. Kay<br/>
 * Saxonica Limited<br/>
 * 9 January 2014</i></p>
 */
package net.sf.saxon.z;
