/*
 * Copyright 2014 OSBI Ltd
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

  package org.saiku.web.rest.util;

import org.jasig.cas.client.validation.Assertion;
import org.springframework.security.cas.userdetails.AbstractCasAssertionUserDetailsService;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;

import java.util.ArrayList;
import java.util.List;

/**
 * Created by bugg on 12/03/15.
 */
final class GrantedAuth extends AbstractCasAssertionUserDetailsService {
  private static final SimpleGrantedAuthority ROLE_USER = new SimpleGrantedAuthority(
      "ROLE_USER");
  @Override
  protected UserDetails loadUserDetails(Assertion assertion) {
    final List<GrantedAuthority> grantedAuthorities = new ArrayList<>();
    grantedAuthorities.add(ROLE_USER);
    return new User(assertion.getPrincipal().getName(), "NO_PASSWORD",
        true, true, true, true, grantedAuthorities);
  }
}