/*! ******************************************************************************
 *
 * Pentaho Data Integration
 *
 * Copyright (C) 2002-2017 by Hitachi Vantara : http://www.pentaho.com
 *
 *******************************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/

package org.pentaho.di.trans.steps.dynamicsqlrow;

import java.util.ArrayList;

import org.pentaho.di.core.database.Database;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.trans.step.BaseStepData;
import org.pentaho.di.trans.step.StepDataInterface;

/**
 * @author Matt
 * @since 24-jan-2005
 */
public class DynamicSQLRowData extends BaseStepData implements StepDataInterface {
  RowMetaInterface outputRowMeta;
  RowMetaInterface lookupRowMeta;

  public Database db;

  public Object[] notfound; // Values in case nothing is found...

  public int indexOfSQLField;

  public boolean skipPreviousRow;

  public String previousSQL;

  public ArrayList<Object[]> previousrowbuffer;

  public boolean isCanceled;

  public DynamicSQLRowData() {
    super();

    db = null;
    notfound = null;
    indexOfSQLField = -1;
    skipPreviousRow = false;
    previousSQL = null;
    previousrowbuffer = new ArrayList<Object[]>();
  }
}
