/*! ******************************************************************************
 *
 *
 * Pentaho Data Integration
 * Copyright (C) 2019 by Hitachi Vantara : http://www.pentaho.com
 *
 *******************************************************************************
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with
 * the License. You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 ******************************************************************************/
package org.pentaho.di.repository;

import org.pentaho.di.core.exception.KettleException;

/**
 * This exception is thrown when repository wasn't found.
 */
public class KettleRepositoryNotFoundException extends KettleException {

  private static final long serialVersionUID = 5920594838763107082L;

  public KettleRepositoryNotFoundException() {
    super();
  }

  /**
   * @param message
   * @param cause
   */
  public KettleRepositoryNotFoundException( String message, Throwable cause ) {
    super( message, cause );
  }

  /**
   * @param message
   */
  public KettleRepositoryNotFoundException( String message ) {
    super( message );
  }

  /**
   * @param cause
   */
  public KettleRepositoryNotFoundException( Throwable cause ) {
    super( cause );
  }

}
