/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.batch.item.data;

import java.util.Iterator;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.springframework.batch.item.support.AbstractItemCountingItemStreamItemReader;
import org.springframework.lang.Nullable;
import org.springframework.util.Assert;

public abstract class AbstractPaginatedDataItemReader<T>
extends AbstractItemCountingItemStreamItemReader<T> {
    protected volatile int page = 0;
    protected int pageSize = 10;
    protected Iterator<T> results;
    private final Lock lock = new ReentrantLock();

    public void setPageSize(int pageSize) {
        Assert.isTrue((pageSize > 0 ? 1 : 0) != 0, (String)"pageSize must be greater than zero");
        this.pageSize = pageSize;
    }

    @Override
    @Nullable
    protected T doRead() throws Exception {
        this.lock.lock();
        try {
            if (this.results == null || !this.results.hasNext()) {
                this.results = this.doPageRead();
                ++this.page;
                if (this.results == null || !this.results.hasNext()) {
                    T t = null;
                    return t;
                }
            }
            if (this.results.hasNext()) {
                T t = this.results.next();
                return t;
            }
            T t = null;
            return t;
        }
        finally {
            this.lock.unlock();
        }
    }

    protected abstract Iterator<T> doPageRead();

    @Override
    protected void doOpen() throws Exception {
    }

    @Override
    protected void doClose() throws Exception {
        this.lock.lock();
        try {
            this.page = 0;
            this.results = null;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void jumpToItem(int itemLastIndex) throws Exception {
        this.lock.lock();
        try {
            this.page = itemLastIndex / this.pageSize;
            Iterator<T> initialPage = this.doPageRead();
            for (int current = itemLastIndex % this.pageSize; current >= 0; --current) {
                initialPage.next();
            }
        }
        finally {
            this.lock.unlock();
        }
    }
}

