/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.ui.swing.checkboxtree;

import de.werum.sis.ui.swing.checkboxtree.CheckBoxNodeRenderer;
import de.werum.sis.ui.swing.checkboxtree.CheckBoxTreeModelListener;
import de.werum.sis.ui.swing.checkboxtree.CheckObject;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;

public class CheckBoxTree
extends JTree
implements ChangeListener {
    private CheckBoxTreeModelListener checkBoxModelListener = null;

    public CheckBoxTree(DefaultMutableTreeNode root, TreeCellRenderer objectCellRenderer) {
        super(root);
        this.setEditable(false);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.getSelectionModel().setSelectionMode(1);
        this.setCellRenderer(new CheckBoxNodeRenderer(objectCellRenderer));
        this.addMouseListener(new MouseAdapter(){
            private DefaultMutableTreeNode mousePressedCheckBoxNode = null;

            @Override
            public void mousePressed(MouseEvent e) {
                DefaultMutableTreeNode node;
                Object userObject;
                JTree tree;
                TreePath path;
                this.mousePressedCheckBoxNode = null;
                if (e.getButton() == 1 && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof CheckObject) {
                    int hotspot = ((CheckBoxNodeRenderer)tree.getCellRenderer()).getCheckBox().getPreferredSize().width;
                    if (e.getX() <= tree.getPathBounds((TreePath)path).x + hotspot) {
                        this.mousePressedCheckBoxNode = node;
                    }
                }
            }

            @Override
            public void mouseReleased(MouseEvent e) {
                DefaultMutableTreeNode node;
                Object userObject;
                JTree tree;
                TreePath path;
                if (this.mousePressedCheckBoxNode != null && e.getButton() == 1 && (path = (tree = (JTree)e.getSource()).getPathForLocation(e.getX(), e.getY())) != null && (userObject = (node = (DefaultMutableTreeNode)path.getLastPathComponent()).getUserObject()) instanceof CheckObject) {
                    int hotspot = ((CheckBoxNodeRenderer)tree.getCellRenderer()).getCheckBox().getPreferredSize().width;
                    if (e.getX() <= tree.getPathBounds((TreePath)path).x + hotspot && node == this.mousePressedCheckBoxNode) {
                        CheckObject checkObject;
                        checkObject.setSelected(!(checkObject = (CheckObject)userObject).isSelected());
                        ((DefaultTreeModel)tree.getModel()).nodeChanged(node);
                    }
                }
                this.mousePressedCheckBoxNode = null;
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                this.mousePressedCheckBoxNode = null;
            }
        });
        String spaceActionKey = "switchSelection";
        ActionMap actionMap = this.getActionMap();
        InputMap inputMap = this.getInputMap();
        inputMap.put(KeyStroke.getKeyStroke(32, 0), "switchSelection");
        actionMap.put("switchSelection", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                DefaultMutableTreeNode node;
                Object userObject;
                TreePath treePath = CheckBoxTree.this.getSelectionPath();
                if (treePath != null && (userObject = (node = (DefaultMutableTreeNode)treePath.getLastPathComponent()).getUserObject()) instanceof CheckObject) {
                    CheckObject checkObject;
                    checkObject.setSelected(!(checkObject = (CheckObject)userObject).isSelected());
                    ((DefaultTreeModel)CheckBoxTree.this.getModel()).nodeChanged(node);
                }
            }
        });
    }

    public void addChangeListener(ChangeListener changeListener) {
        this.getCheckBoxTreeModelListener().addChangeListener(changeListener);
    }

    public void removeChangeListener(ChangeListener changeListener) {
        this.getCheckBoxTreeModelListener().removeChangeListener(changeListener);
    }

    private CheckBoxTreeModelListener getCheckBoxTreeModelListener() {
        if (this.checkBoxModelListener == null) {
            this.checkBoxModelListener = new CheckBoxTreeModelListener();
            this.checkBoxModelListener.addChangeListener(this);
        }
        return this.checkBoxModelListener;
    }

    public void setRootNode(Object root) {
        DefaultTreeModel model = null;
        if (root instanceof DefaultTreeModel) {
            model = (DefaultTreeModel)root;
        } else if (root instanceof DefaultMutableTreeNode) {
            model = new DefaultTreeModel((DefaultMutableTreeNode)root);
        }
        if (model != null) {
            this.setModel(model);
        }
    }

    @Override
    public void setModel(TreeModel newModel) {
        TreeModel oldModel = this.getModel();
        if (oldModel != null && this.checkBoxModelListener != null) {
            oldModel.removeTreeModelListener(this.checkBoxModelListener);
        }
        super.setModel(newModel);
        TreeModel model = this.getModel();
        if (model != null) {
            model.addTreeModelListener(this.getCheckBoxTreeModelListener());
        }
    }

    public List<CheckObject> getAllCheckObjects() {
        return this.getCheckObjects(false, true);
    }

    public List<CheckObject> getAllSelectedCheckObjects() {
        return this.getCheckObjects(true, true);
    }

    public List<CheckObject> getAllUnSelectedCheckObjects() {
        return this.getCheckObjects(true, false);
    }

    private List<CheckObject> getCheckObjects(boolean filterSelection, boolean selected) {
        Object root;
        ArrayList<CheckObject> result = new ArrayList<CheckObject>();
        TreeModel model = this.getModel();
        if (model != null && (root = model.getRoot()) instanceof DefaultMutableTreeNode) {
            this.collectAllCheckObjects((DefaultMutableTreeNode)root, result, filterSelection, selected);
        }
        return result;
    }

    private void collectAllCheckObjects(DefaultMutableTreeNode root, List<CheckObject> resultList, boolean filterSelection, boolean selected) {
        Object userObj = root.getUserObject();
        if (userObj instanceof CheckObject) {
            CheckObject checkObject = (CheckObject)userObj;
            if (!filterSelection || checkObject.isSelected() == selected) {
                resultList.add(checkObject);
            }
        }
        if (root.getChildCount() > 0) {
            Enumeration<TreeNode> children = root.children();
            while (children.hasMoreElements()) {
                this.collectAllCheckObjects((DefaultMutableTreeNode)children.nextElement(), resultList, filterSelection, selected);
            }
        }
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        this.repaint();
    }
}

