/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.csv.filter;

import de.werum.sis.csv.filter.FilterField;
import de.werum.sis.csv.filter.FilterFieldGroup;
import de.werum.sis.csv.filter.FilterFieldSetInstance;

public class FilterPath {
    private FilterPath parent;
    private Object element;

    public FilterPath(Object root) {
        this(null, root);
    }

    public FilterPath(FilterPath parent, Object element) {
        this.parent = parent;
        this.element = element;
    }

    public FilterPath getParent() {
        return this.parent;
    }

    public Object getElement() {
        return this.element;
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.parent != null) {
            buffer.append(this.parent.toString());
        }
        if (buffer.length() > 0) {
            buffer.append(".");
        }
        if (this.element instanceof FilterFieldSetInstance) {
            FilterFieldSetInstance fieldSetInstance = (FilterFieldSetInstance)this.element;
            buffer.append(fieldSetInstance.getFieldSet().getName());
            buffer.append('(');
            buffer.append(fieldSetInstance.getName());
            buffer.append(')');
        } else if (this.element instanceof FilterFieldGroup) {
            FilterFieldGroup fieldGroup = (FilterFieldGroup)this.element;
            buffer.append(fieldGroup.getName());
        } else if (this.element instanceof FilterField) {
            FilterField field = (FilterField)this.element;
            buffer.append(field.getName());
        }
        return buffer.toString();
    }
}

