/*
 * Decompiled with CFR 0.152.
 */
package de.werum.sis.crypt;

import de.werum.sis.crypt.CryptKeyData;
import de.werum.sis.crypt.SymKeyData;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.SecureRandom;
import java.security.Security;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManagerFactory;

public class CryptProperties {
    private static final String DEFAULT_RESOURCE = "sis_crypt";
    private SecureRandom secureRandom = null;
    private static final String PROP_USER_IDS = "userIds";
    private static final String PROP_ENCRYPT_PACKAGING_USER_ID = "encryptPackagingUserId";
    private static final String PROP_PROVIDER_NAME = "providerName";
    private static final String PROP_PROVIDER_CLASS = "providerClass";
    private static final String PROP_SYMMETRIC_ALGORITHM = "symmetricAlgorithm";
    private static final String PROP_SYMMETRIC_OP_MODE = "symmetricOpMode";
    private static final String PROP_SYMMETRIC_PADDING = "symmetricPadding";
    private static final String PROP_SYMMETRIC_KEY_SIZE = "symmetricKeySize";
    private static final String PROP_PBE_ALGORITHM = "pbeAlgorithm";
    private static final String PROP_PBE_ITERATIONS = "pbeIterations";
    private static final String PROP_PBE_SALT_SIZE = "pbeSaltSize";
    private static final String PROP_ASYMMETRIC_ALGORITHM = "asymmetricAlgorithm";
    private static final String PROP_ASYMMETRIC_OP_MODE = "asymmetricOpMode";
    private static final String PROP_ASYMMETRIC_PADDING = "asymmetricPadding";
    private static final String DEFAULT_PROVIDER_NAME = "IAIK";
    private static final String DEFAULT_PROVIDER_CLASS = "iaik.security.provider.IAIK";
    private static final String DEFAULT_SYMMETRIC_ALGORITHM = "DESede";
    private static final String DEFAULT_SYMMETRIC_OP_MODE = "CBC";
    private static final String DEFAULT_SYMMETRIC_PADDING = "PKCS5Padding";
    private static final Integer DEFAULT_SYMMETRIC_KEY_SIZE = null;
    private static final String DEFAULT_PBE_ALGORITHM = "PBEWITHSHA256AND128BITAES-CBC-BC";
    private static final Integer DEFAULT_PBE_SALT_SIZE = new Integer(32);
    private static final Integer DEFAULT_PBE_ITERATIONS = new Integer(1000);
    private static final String DEFAULT_ASYMMETRIC_ALGORITHM = "RSA";
    private static final String DEFAULT_ASYMMETRIC_OP_MODE = "2";
    private static final String DEFAULT_ASYMMETRIC_PADDING = "PKCS1Padding";
    private static Set registeredProviderClasses = Collections.synchronizedSet(new HashSet());
    private Integer encryptPackagingUserId;
    private Set userIds;
    private Map paramsByUserId;
    private String keyStart = "w";
    private String keyEndPrivate = ".prk";
    private String keyEndPublic = ".puk";
    private String keyRepositoryUrl = "http://localhost:6080/";
    private String isRandomKeyRepository = "false";
    private String isSSLRepository = "false";
    private String sslKeyStoreFile = "/internalClientKeys";
    private String sslKeyStorePass = "client";
    private String sslTrustStoreFile = "/internalClientTrust";
    private String sslTrustStorePass = "client";
    private String sslProtocol = "SSL";
    private String dbDriver = "org.gjt.mm.mysql.Driver";
    private String dbUser = "adesadm";
    private String dbPasswort = "adesadm";
    private String dbTableName = "melder";
    private String dbColumnRef = "MELDER_ID";
    private String dbColumnPrivate = "KEY_PRIVATE";
    private String dbColumnPublic = "KEY_PUBLIC";
    private CryptKeyData keyData = null;
    private HashMap symmetricKeyData = null;
    private SSLContext sslContext = null;

    public CryptProperties() {
        this(DEFAULT_RESOURCE, CryptProperties.class.getClassLoader());
    }

    public CryptProperties(String resourceName, ClassLoader classLoader) {
        ResourceBundle resource = null;
        try {
            resource = ResourceBundle.getBundle(resourceName, Locale.getDefault(), classLoader);
        }
        catch (MissingResourceException e) {
            // empty catch block
        }
        this.userIds = new HashSet();
        this.paramsByUserId = new HashMap();
        if (resource != null) {
            boolean customUserIdsDefined = false;
            if (resource.containsKey(PROP_USER_IDS)) {
                String[] userIds;
                String userIdsStr = resource.getString(PROP_USER_IDS);
                if ((userIdsStr = userIdsStr.trim()).length() > 0 && (userIds = userIdsStr.split(",")).length > 0) {
                    customUserIdsDefined = true;
                    for (String userId : userIds) {
                        userId = userId.trim();
                        int userIdInt = Integer.parseInt(userId);
                        this.userIds.add(new Integer(userIdInt));
                    }
                }
            }
            if (resource.containsKey(PROP_ENCRYPT_PACKAGING_USER_ID)) {
                String encryptPackagingUserIdStr = resource.getString(PROP_ENCRYPT_PACKAGING_USER_ID);
                if ((encryptPackagingUserIdStr = encryptPackagingUserIdStr.trim()).length() > 0) {
                    customUserIdsDefined = true;
                    this.encryptPackagingUserId = new Integer(Integer.parseInt(encryptPackagingUserIdStr));
                }
            }
            if (this.encryptPackagingUserId == null) {
                this.encryptPackagingUserId = new Integer(402);
            }
            if (!this.userIds.contains(this.encryptPackagingUserId)) {
                this.userIds.add(this.encryptPackagingUserId);
            }
            for (Integer userId : this.userIds) {
                HashMap<String, Object> userIdParams = new HashMap<String, Object>();
                String providerName = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_PROVIDER_NAME, userId) : PROP_PROVIDER_NAME, DEFAULT_PROVIDER_NAME);
                userIdParams.put(PROP_PROVIDER_NAME, providerName);
                String providerClass = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_PROVIDER_CLASS, userId) : PROP_PROVIDER_CLASS, DEFAULT_PROVIDER_CLASS);
                userIdParams.put(PROP_PROVIDER_CLASS, providerClass);
                String symmetricAlgorithm = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_SYMMETRIC_ALGORITHM, userId) : PROP_SYMMETRIC_ALGORITHM, DEFAULT_SYMMETRIC_ALGORITHM);
                userIdParams.put(PROP_SYMMETRIC_ALGORITHM, symmetricAlgorithm);
                String symmetricOpMode = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_SYMMETRIC_OP_MODE, userId) : PROP_SYMMETRIC_OP_MODE, DEFAULT_SYMMETRIC_OP_MODE);
                userIdParams.put(PROP_SYMMETRIC_OP_MODE, symmetricOpMode);
                String symmetricPadding = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_SYMMETRIC_PADDING, userId) : PROP_SYMMETRIC_PADDING, DEFAULT_SYMMETRIC_PADDING);
                userIdParams.put(PROP_SYMMETRIC_PADDING, symmetricPadding);
                Integer symmetricKeySize = this.getIntegerProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_SYMMETRIC_KEY_SIZE, userId) : PROP_SYMMETRIC_KEY_SIZE, DEFAULT_SYMMETRIC_KEY_SIZE);
                userIdParams.put(PROP_SYMMETRIC_KEY_SIZE, symmetricKeySize);
                String pbeAlgorithm = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_PBE_ALGORITHM, userId) : PROP_PBE_ALGORITHM, DEFAULT_PBE_ALGORITHM);
                userIdParams.put(PROP_PBE_ALGORITHM, pbeAlgorithm);
                Integer pbeIterations = this.getIntegerProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_PBE_ITERATIONS, userId) : PROP_PBE_ITERATIONS, DEFAULT_PBE_ITERATIONS);
                userIdParams.put(PROP_PBE_ITERATIONS, pbeIterations);
                Integer pbeSaltSize = this.getIntegerProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_PBE_SALT_SIZE, userId) : PROP_PBE_SALT_SIZE, DEFAULT_PBE_SALT_SIZE);
                userIdParams.put(PROP_PBE_SALT_SIZE, pbeSaltSize);
                String asymmetricAlgorithm = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_ASYMMETRIC_ALGORITHM, userId) : PROP_ASYMMETRIC_ALGORITHM, DEFAULT_ASYMMETRIC_ALGORITHM);
                userIdParams.put(PROP_ASYMMETRIC_ALGORITHM, asymmetricAlgorithm);
                String asymmetricOpMode = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_ASYMMETRIC_OP_MODE, userId) : PROP_ASYMMETRIC_OP_MODE, DEFAULT_ASYMMETRIC_OP_MODE);
                userIdParams.put(PROP_ASYMMETRIC_OP_MODE, asymmetricOpMode);
                String asymmetricPadding = this.getStringProperty(resource, customUserIdsDefined ? this.getUserIdPropertyName(PROP_ASYMMETRIC_PADDING, userId) : PROP_ASYMMETRIC_PADDING, DEFAULT_ASYMMETRIC_PADDING);
                userIdParams.put(PROP_ASYMMETRIC_PADDING, asymmetricPadding);
                this.paramsByUserId.put(userId, userIdParams);
            }
            this.keyStart = this.getStringProperty(resource, "keyStart", this.keyStart);
            this.keyEndPrivate = this.getStringProperty(resource, "keyEndPrivate", this.keyEndPrivate);
            this.keyEndPublic = this.getStringProperty(resource, "keyEndPublic", this.keyEndPublic);
            this.keyRepositoryUrl = this.getStringProperty(resource, "keyRepositoryUrl", this.keyRepositoryUrl);
            this.isRandomKeyRepository = this.getStringProperty(resource, "isRandomKeyRepository", this.isRandomKeyRepository);
            this.isSSLRepository = this.getStringProperty(resource, "isSSLRepository", this.isSSLRepository);
            this.sslKeyStoreFile = this.getStringProperty(resource, "sslKeyStoreFile", this.sslKeyStoreFile);
            this.sslKeyStorePass = this.getStringProperty(resource, "sslKeyStorePass", this.sslKeyStorePass);
            this.sslTrustStoreFile = this.getStringProperty(resource, "sslTrustStoreFile", this.sslTrustStoreFile);
            this.sslTrustStorePass = this.getStringProperty(resource, "sslTrustStorePass", this.sslTrustStorePass);
            this.sslProtocol = this.getStringProperty(resource, "sslProtocol", this.sslProtocol);
            this.dbDriver = this.getStringProperty(resource, "dbDriver", this.dbDriver);
            this.dbUser = this.getStringProperty(resource, "dbUser", this.dbUser);
            this.dbPasswort = this.getStringProperty(resource, "dbPasswort", this.dbPasswort);
            this.dbTableName = this.getStringProperty(resource, "dbTableName", this.dbTableName);
            this.dbColumnRef = this.getStringProperty(resource, "dbColumnRef", this.dbColumnRef);
            this.dbColumnPrivate = this.getStringProperty(resource, "dbColumnPrivate", this.dbColumnPrivate);
            this.dbColumnPublic = this.getStringProperty(resource, "dbColumnPublic", this.dbColumnPublic);
        } else {
            this.encryptPackagingUserId = new Integer(402);
            this.userIds.add(this.encryptPackagingUserId);
            HashMap userIdParams = new HashMap();
            this.initDefaults(userIdParams);
            this.paramsByUserId.put(this.encryptPackagingUserId, userIdParams);
        }
        for (Integer userId : this.userIds) {
            Map userIdParams = (Map)this.paramsByUserId.get(userId);
            String providerClass = (String)userIdParams.get(PROP_PROVIDER_CLASS);
            this.addProvider(providerClass);
        }
        if (this.isSSLRepository.equalsIgnoreCase("true")) {
            InputStream in = null;
            try {
                SSLContext sslContext = SSLContext.getInstance(this.sslProtocol);
                KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
                KeyStore ks = KeyStore.getInstance("JKS");
                in = CryptProperties.class.getResourceAsStream(this.sslKeyStoreFile);
                if (in == null) {
                    throw new RuntimeException("key Store '" + this.sslKeyStoreFile + "' nicht gefunden!");
                }
                ks.load(in, this.sslKeyStorePass.toCharArray());
                kmf.init(ks, this.sslKeyStorePass.toCharArray());
                try {
                    in.close();
                    in = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                KeyStore trustedKeyStore = KeyStore.getInstance("JKS");
                in = CryptProperties.class.getResourceAsStream(this.sslTrustStoreFile);
                if (in == null) {
                    throw new RuntimeException("trusted Store File '" + this.sslTrustStoreFile + "' nicht gefunden!");
                }
                trustedKeyStore.load(in, this.sslTrustStorePass.toCharArray());
                TrustManagerFactory trustedKmf = TrustManagerFactory.getInstance("SunX509");
                trustedKmf.init(trustedKeyStore);
                try {
                    in.close();
                    in = null;
                }
                catch (Exception e) {
                    // empty catch block
                }
                sslContext.init(kmf.getKeyManagers(), trustedKmf.getTrustManagers(), null);
                this.sslContext = sslContext;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            catch (GeneralSecurityException e) {
                throw new RuntimeException(e);
            }
            finally {
                if (in != null) {
                    try {
                        in.close();
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    public CryptProperties(String resourceName) {
        this(resourceName, CryptProperties.class.getClassLoader());
    }

    private void addProvider(String providerClass) {
        if (registeredProviderClasses.contains(providerClass)) {
            return;
        }
        try {
            Class<?> provider = Class.forName(providerClass);
            Security.addProvider((Provider)provider.getConstructor(null).newInstance(null));
            registeredProviderClasses.add(providerClass);
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
    }

    public Integer getEncryptPackagingUserId() {
        return this.encryptPackagingUserId;
    }

    public boolean containsUserId(Integer userId) {
        return this.userIds.contains(userId);
    }

    public void setSecureRandom(SecureRandom secureRandom) {
        this.secureRandom = secureRandom;
    }

    public SecureRandom getSecureRandom() {
        return this.secureRandom;
    }

    public void setProviderName(String providerName, Integer userId) {
        this.setUserIdParam(PROP_PROVIDER_NAME, userId, providerName);
    }

    public void setProviderClass(String providerClass, Integer userId) {
        this.setUserIdParam(PROP_PROVIDER_CLASS, userId, providerClass);
    }

    public void setSymetricAlgorithm(String symetricAlgorithm, Integer userId) {
        this.setUserIdParam(PROP_SYMMETRIC_ALGORITHM, userId, symetricAlgorithm);
    }

    public void setSymetricOpMode(String symetricOpMode, Integer userId) {
        this.setUserIdParam(PROP_SYMMETRIC_OP_MODE, userId, symetricOpMode);
    }

    public void setSymetricPadding(String symetricPadding, Integer userId) {
        this.setUserIdParam(PROP_SYMMETRIC_PADDING, userId, symetricPadding);
    }

    public void setAsymetricAlgorithm(String asymetricAlgorithm, Integer userId) {
        this.setUserIdParam(PROP_ASYMMETRIC_ALGORITHM, userId, asymetricAlgorithm);
    }

    public void setAsymetricOpMode(String asymetricOpMode, Integer userId) {
        this.setUserIdParam(PROP_ASYMMETRIC_OP_MODE, userId, asymetricOpMode);
    }

    public void setAsymetricPadding(String asymetricPadding, Integer userId) {
        this.setUserIdParam(PROP_ASYMMETRIC_PADDING, userId, asymetricPadding);
    }

    public void setKeyStart(String keyStart) {
        this.keyStart = keyStart;
    }

    public void setKeyEndPrivate(String keyEndPrivate) {
        this.keyEndPrivate = keyEndPrivate;
    }

    public void setKeyEndPublic(String keyEndPublic) {
        this.keyEndPublic = keyEndPublic;
    }

    public void setKeyRepositoryUrl(String keyRepositoryUrl) {
        this.keyRepositoryUrl = keyRepositoryUrl;
    }

    public void setDbDriver(String dbDriver) {
        this.dbDriver = dbDriver;
    }

    public void setDbUser(String dbUser) {
        this.dbUser = dbUser;
    }

    public void setDbPasswort(String dbPasswort) {
        this.dbPasswort = dbPasswort;
    }

    public void setDbTableName(String dbTableName) {
        this.dbTableName = dbTableName;
    }

    public void setDbColumnRef(String dbColumnRef) {
        this.dbColumnRef = dbColumnRef;
    }

    public void setDbColumnPrivate(String dbColumnPrivate) {
        this.dbColumnPrivate = dbColumnPrivate;
    }

    public void setDbColumnPublic(String dbColumnPublic) {
        this.dbColumnPublic = dbColumnPublic;
    }

    public void setKeyData(CryptKeyData keyData) {
        this.keyData = keyData;
    }

    public String getSymetricPadding(Integer userId) {
        return (String)this.getUserIdParam(PROP_SYMMETRIC_PADDING, userId);
    }

    public String getSymetricOpMode(Integer userId) {
        return (String)this.getUserIdParam(PROP_SYMMETRIC_OP_MODE, userId);
    }

    public String getSymetricAlgorithm(Integer userId) {
        return (String)this.getUserIdParam(PROP_SYMMETRIC_ALGORITHM, userId);
    }

    public String getProviderName(Integer userId) {
        return (String)this.getUserIdParam(PROP_PROVIDER_NAME, userId);
    }

    public String getKeyStart() {
        return this.keyStart;
    }

    public String getProviderClass(Integer userId) {
        return (String)this.getUserIdParam(PROP_PROVIDER_CLASS, userId);
    }

    public String getKeyEndPrivate() {
        return this.keyEndPrivate;
    }

    public String getAsymetricPadding(Integer userId) {
        return (String)this.getUserIdParam(PROP_ASYMMETRIC_PADDING, userId);
    }

    public String getAsymetricOpMode(Integer userId) {
        return (String)this.getUserIdParam(PROP_ASYMMETRIC_OP_MODE, userId);
    }

    public String getAsymetricAlgorithm(Integer userId) {
        return (String)this.getUserIdParam(PROP_ASYMMETRIC_ALGORITHM, userId);
    }

    public String getKeyRepositoryUrl() {
        return this.keyRepositoryUrl;
    }

    public String getKeyEndPublic() {
        return this.keyEndPublic;
    }

    public String getDbUser() {
        return this.dbUser;
    }

    public String getDbTableName() {
        return this.dbTableName;
    }

    public String getDbPasswort() {
        return this.dbPasswort;
    }

    public String getDbDriver() {
        return this.dbDriver;
    }

    public String getDbColumnRef() {
        return this.dbColumnRef;
    }

    public String getDbColumnPublic() {
        return this.dbColumnPublic;
    }

    public String getDbColumnPrivate() {
        return this.dbColumnPrivate;
    }

    public CryptKeyData getKeyData() {
        return this.keyData;
    }

    public String getIsRandomKeyRepository() {
        return this.isRandomKeyRepository;
    }

    public void setIsRandomKeyRepository(String string) {
        this.isRandomKeyRepository = string;
    }

    public String getSymetricAlgorithmComplete(Integer userId) {
        return this.getSymetricAlgorithm(userId) + "/" + this.getSymetricOpMode(userId) + "/" + this.getSymetricPadding(userId);
    }

    public SymKeyData getSymetricKeyData(Object key) {
        if (this.symmetricKeyData != null) {
            return (SymKeyData)this.symmetricKeyData.get(key);
        }
        return null;
    }

    public void setSymetricKeyData(Object key, SymKeyData keyData) {
        if (this.symmetricKeyData == null) {
            this.symmetricKeyData = new HashMap();
        }
        this.symmetricKeyData.put(key, keyData);
    }

    public String getIsSSLRepository() {
        return this.isSSLRepository;
    }

    public String getSslKeyStoreFile() {
        return this.sslKeyStoreFile;
    }

    public String getSslKeyStorePass() {
        return this.sslKeyStorePass;
    }

    public String getSslTrustStoreFile() {
        return this.sslTrustStoreFile;
    }

    public String getSslTrustStorePass() {
        return this.sslTrustStorePass;
    }

    public HashMap getSymmetricKeyData() {
        return this.symmetricKeyData;
    }

    public void setIsSSLRepository(String string) {
        this.isSSLRepository = string;
    }

    public void setSslKeyStoreFile(String string) {
        this.sslKeyStoreFile = string;
    }

    public void setSslKeyStorePass(String string) {
        this.sslKeyStorePass = string;
    }

    public void setSslTrustStoreFile(String string) {
        this.sslTrustStoreFile = string;
    }

    public void setSslTrustStorePass(String string) {
        this.sslTrustStorePass = string;
    }

    public void setSymmetricKeyData(HashMap map) {
        this.symmetricKeyData = map;
    }

    public SSLContext getSslContext() {
        return this.sslContext;
    }

    public void setSslContext(SSLContext context) {
        this.sslContext = context;
    }

    public String getPbeAlgorithm(Integer userId) {
        return (String)this.getUserIdParam(PROP_PBE_ALGORITHM, userId);
    }

    public int getPbeSaltSize(Integer userId) {
        return (Integer)this.getUserIdParam(PROP_PBE_SALT_SIZE, userId);
    }

    public int getPbeIterations(Integer userId) {
        return (Integer)this.getUserIdParam(PROP_PBE_ITERATIONS, userId);
    }

    public Integer getSymmetricKeySize(Integer userId) {
        return (Integer)this.getUserIdParam(PROP_SYMMETRIC_KEY_SIZE, userId);
    }

    private String getStringProperty(ResourceBundle bundle, String property, String defaultValue) {
        String value;
        try {
            value = bundle.getString(property);
        }
        catch (MissingResourceException e) {
            value = defaultValue;
        }
        return value;
    }

    private Integer getIntegerProperty(ResourceBundle bundle, String property, Integer defaultValue) {
        Integer value;
        try {
            value = new Integer(Integer.parseInt(bundle.getString(property).trim()));
        }
        catch (MissingResourceException e) {
            value = defaultValue;
        }
        return value;
    }

    private String getUserIdPropertyName(String property, Integer userId) {
        return property + "." + String.valueOf(userId);
    }

    private Object getUserIdParam(String property, Integer userId) {
        Map userIdParams = (Map)this.paramsByUserId.get(userId);
        return userIdParams.get(property);
    }

    private void setUserIdParam(String property, Integer userId, Object value) {
        HashMap<String, Object> userIdParams;
        if (!this.userIds.contains(userId)) {
            this.userIds.add(userId);
        }
        if ((userIdParams = (HashMap<String, Object>)this.paramsByUserId.get(userId)) == null) {
            userIdParams = new HashMap<String, Object>();
            this.initDefaults(userIdParams);
            this.paramsByUserId.put(userId, userIdParams);
        }
        userIdParams.put(property, value);
    }

    private void initDefaults(Map userIdParams) {
        userIdParams.put(PROP_PROVIDER_NAME, DEFAULT_PROVIDER_NAME);
        userIdParams.put(PROP_PROVIDER_CLASS, DEFAULT_PROVIDER_CLASS);
        userIdParams.put(PROP_SYMMETRIC_ALGORITHM, DEFAULT_SYMMETRIC_ALGORITHM);
        userIdParams.put(PROP_SYMMETRIC_OP_MODE, DEFAULT_SYMMETRIC_OP_MODE);
        userIdParams.put(PROP_SYMMETRIC_PADDING, DEFAULT_SYMMETRIC_PADDING);
        userIdParams.put(PROP_SYMMETRIC_KEY_SIZE, DEFAULT_SYMMETRIC_KEY_SIZE);
        userIdParams.put(PROP_PBE_ALGORITHM, DEFAULT_PBE_ALGORITHM);
        userIdParams.put(PROP_PBE_ITERATIONS, DEFAULT_PBE_ITERATIONS);
        userIdParams.put(PROP_PBE_SALT_SIZE, DEFAULT_PBE_SALT_SIZE);
        userIdParams.put(PROP_ASYMMETRIC_ALGORITHM, DEFAULT_ASYMMETRIC_ALGORITHM);
        userIdParams.put(PROP_ASYMMETRIC_OP_MODE, DEFAULT_ASYMMETRIC_OP_MODE);
        userIdParams.put(PROP_ASYMMETRIC_PADDING, DEFAULT_ASYMMETRIC_PADDING);
    }
}

