/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.svg;

import java.io.InputStream;
import java.io.OutputStream;
import org.apache.batik.transcoder.SVGAbstractTranscoder;
import org.apache.batik.transcoder.Transcoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderInput;
import org.apache.batik.transcoder.TranscoderOutput;
import org.saiku.web.svg.Converter;

abstract class BatikConverter
extends Converter {
    BatikConverter(String extension) {
        super("image/" + extension, extension);
    }

    BatikConverter(String contentType, String extension) {
        super(contentType, extension);
    }

    @Override
    public void convert(InputStream in, OutputStream out, Integer size) throws TranscoderException {
        Transcoder t = this.createTranscoder();
        if (size != null) {
            float sizeBound = Math.max(Math.min((float)size.intValue(), 2000.0f), 32.0f);
            t.addTranscodingHint(SVGAbstractTranscoder.KEY_WIDTH, (Object)Float.valueOf(sizeBound));
        }
        t.transcode(new TranscoderInput(in), new TranscoderOutput(out));
    }

    protected abstract Transcoder createTranscoder();
}

