/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.web.rest.resources;

import com.his.jackson.databind.JavaType;
import com.his.jackson.databind.ObjectMapper;
import com.his.jackson.databind.type.CollectionType;
import com.qmino.miredot.annotations.ReturnType;
import jakarta.servlet.ServletException;
import java.io.InputStream;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.FormParam;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.MultivaluedMap;
import javax.ws.rs.core.Response;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.saiku.olap.dto.SimpleCubeElement;
import org.saiku.olap.dto.resultset.CellDataSet;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.olap.util.SaikuProperties;
import org.saiku.service.olap.ThinQueryService;
import org.saiku.service.olap.drillthrough.DrillThroughResult;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.web.export.JSConverter;
import org.saiku.web.export.PdfReport;
import org.saiku.web.rest.objects.resultset.QueryResult;
import org.saiku.web.rest.resources.ISaikuRepository;
import org.saiku.web.rest.util.RestUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Path(value="/saiku/api/query")
@XmlAccessorType(value=XmlAccessType.NONE)
public class Query2Resource {
    private static final Logger log = LoggerFactory.getLogger(Query2Resource.class);
    private ThinQueryService thinQueryService;
    private ISaikuRepository repository;

    public void setThinQueryService(ThinQueryService tqs) {
        this.thinQueryService = tqs;
    }

    public void setRepository(ISaikuRepository repository) {
        this.repository = repository;
    }

    @DELETE
    @Path(value="/{queryname}")
    public Response.Status deleteQuery(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "\tDELETE");
        }
        try {
            this.thinQueryService.deleteQuery(queryName);
            return Response.Status.GONE;
        }
        catch (Exception e) {
            log.error("Cannot delete query (" + queryName + ")", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}")
    public ThinQuery createQuery(@PathParam(value="queryname") String queryName, @FormParam(value="json") String jsonFormParam, @FormParam(value="file") String fileFormParam, MultivaluedMap<String, String> formParams) throws ServletException {
        try {
            ThinQuery tq;
            String file = fileFormParam;
            String json = jsonFormParam;
            if (formParams != null) {
                json = formParams.containsKey((Object)"json") ? (String)formParams.getFirst((Object)"json") : jsonFormParam;
                file = formParams.containsKey((Object)"file") ? (String)formParams.getFirst((Object)"file") : fileFormParam;
            }
            String filecontent = null;
            if (StringUtils.isNotBlank((String)json)) {
                filecontent = json;
            } else if (StringUtils.isNotBlank((String)file)) {
                Response f = this.repository.getResource(file);
                filecontent = new String((byte[])f.getEntity());
            }
            if (StringUtils.isBlank((String)filecontent)) {
                throw new SaikuServiceException("Cannot create new query. Empty file content " + StringUtils.isNotBlank((String)json) + " or read from file:" + file);
            }
            if (this.thinQueryService.isOldQuery(filecontent)) {
                tq = this.thinQueryService.convertQuery(filecontent);
            } else {
                ObjectMapper om = new ObjectMapper();
                tq = (ThinQuery)om.readValue(filecontent, ThinQuery.class);
            }
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "\tPOST\t tq:" + (tq == null) + " file:" + file);
            }
            if (tq == null) {
                throw new SaikuServiceException("Cannot create blank query (ThinQuery object = null)");
            }
            tq.setName(queryName);
            return this.thinQueryService.createQuery(tq);
        }
        catch (Exception e) {
            log.error("Error creating new query", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/execute")
    public QueryResult execute(ThinQuery tq) {
        try {
            if (this.thinQueryService.isMdxDrillthrough(tq)) {
                Long start = new Date().getTime();
                ResultSet rs = this.thinQueryService.drillthrough(tq);
                QueryResult rsc = RestUtil.convert(rs);
                rsc.setQuery(tq);
                Long runtime = new Date().getTime() - start;
                rsc.setRuntime(runtime.intValue());
                return rsc;
            }
            QueryResult qr = RestUtil.convert(this.thinQueryService.execute(tq));
            ThinQuery tqAfter = this.thinQueryService.getContext(tq.getName()).getOlapQuery();
            qr.setQuery(tqAfter);
            return qr;
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + tq + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            return new QueryResult(error);
        }
    }

    @DELETE
    @Path(value="/{queryname}/cancel")
    public Response cancel(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "\tDELETE");
        }
        try {
            this.thinQueryService.cancel(queryName);
            return Response.ok((Object)Response.Status.GONE).build();
        }
        catch (Exception e) {
            log.error("Cannot cancel query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    @POST
    @Consumes(value={"application/json"})
    @Path(value="/enrich")
    public ThinQuery enrich(ThinQuery tq) {
        try {
            return this.thinQueryService.updateQuery(tq);
        }
        catch (Exception e) {
            log.error("Cannot enrich query (" + tq + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/result/metadata/hierarchies/{hierarchy}/levels/{level}")
    public List<SimpleCubeElement> getLevelMembers(@PathParam(value="queryname") String queryName, @PathParam(value="hierarchy") String hierarchyName, @PathParam(value="level") String levelName, @QueryParam(value="result") @DefaultValue(value="true") boolean result, @QueryParam(value="search") String searchString, @QueryParam(value="searchlimit") @DefaultValue(value="-1") int searchLimit) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/result/metadata/hierarchies/" + hierarchyName + "/levels/" + levelName + "\tGET");
        }
        try {
            return this.thinQueryService.getResultMetadataMembers(queryName, result, hierarchyName, levelName, searchString, searchLimit);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    @GET
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="/{queryname}/export/xls")
    public Response getQueryExcelExport(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/xls/\tGET");
        }
        return this.getQueryExcelExport(queryName, "flattened", null);
    }

    @GET
    @Produces(value={"application/vnd.ms-excel"})
    @Path(value="/{queryname}/export/xls/{format}")
    public Response getQueryExcelExport(@PathParam(value="queryname") String queryName, @PathParam(value="format") @DefaultValue(value="flattened") String format, @QueryParam(value="exportname") @DefaultValue(value="") String name) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/xls/" + format + "\tGET");
        }
        try {
            byte[] doc = this.thinQueryService.getExport(queryName, "xls", format);
            if (name == null || name.equals("")) {
                name = SaikuProperties.webExportExcelName + "." + SaikuProperties.webExportExcelFormat;
            }
            return Response.ok((Object)doc, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name)).header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Cannot get excel for query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{queryname}/export/csv")
    public Response getQueryCsvExport(@PathParam(value="queryname") String queryName) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/csv\tGET");
        }
        return this.getQueryCsvExport(queryName, "flattened", null);
    }

    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{queryname}/export/csv/{format}")
    public Response getQueryCsvExport(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format, @QueryParam(value="exportname") @DefaultValue(value="") String name) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/export/csv/" + format + "\tGET");
        }
        try {
            byte[] doc = this.thinQueryService.getExport(queryName, "csv", format);
            if (name == null || name.equals("")) {
                name = SaikuProperties.webExportCsvName;
            }
            return Response.ok((Object)doc, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name + ".csv")).header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Cannot get csv for query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    @POST
    @Consumes(value={"application/x-www-form-urlencoded"})
    @Path(value="/{queryname}/zoomin")
    public ThinQuery zoomIn(@PathParam(value="queryname") String queryName, @FormParam(value="selections") String positionListString) {
        try {
            ObjectMapper mapper;
            String[] positions;
            if (log.isDebugEnabled()) {
                log.debug("TRACK\t\t/query/" + queryName + "/zoomIn\tPUT");
            }
            ArrayList realPositions = new ArrayList();
            if (StringUtils.isNotBlank((String)positionListString) && (positions = (String[])(mapper = new ObjectMapper()).readValue(positionListString, (JavaType)mapper.getTypeFactory().constructArrayType(String.class))) != null && positions.length > 0) {
                for (String position : positions) {
                    String[] rPos = position.split(":");
                    ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                    for (String p : rPos) {
                        Integer pInt = Integer.parseInt(p);
                        cellPosition.add(pInt);
                    }
                    realPositions.add(cellPosition);
                }
            }
            return this.thinQueryService.zoomIn(queryName, realPositions);
        }
        catch (Exception e) {
            log.error("Cannot zoom in on query (" + queryName + ")", (Throwable)e);
            throw new WebApplicationException((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @GET
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/drillthrough")
    public QueryResult drillthrough(@PathParam(value="queryname") String queryName, @QueryParam(value="maxrows") @DefaultValue(value="100") Integer maxrows, @QueryParam(value="position") String position, @QueryParam(value="returns") String returns) {
        QueryResult rsc;
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/drillthrough\tGET");
        }
        ResultSet rs = null;
        try {
            Long start = new Date().getTime();
            if (position == null) {
                rs = this.thinQueryService.drillthrough(queryName, maxrows.intValue(), returns);
                rsc = RestUtil.convert(rs);
            } else {
                String[] positions = position.split(":");
                ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                for (String p : positions) {
                    Integer pInt = Integer.parseInt(p);
                    cellPosition.add(pInt);
                }
                DrillThroughResult drillthrough = this.thinQueryService.drillthroughWithCaptions(queryName, cellPosition, maxrows, returns);
                rsc = RestUtil.convert(drillthrough);
            }
            Long runtime = new Date().getTime() - start;
            rsc.setRuntime(runtime.intValue());
            return rsc;
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            rsc = new QueryResult(error);
            return rsc;
        }
        finally {
            block34: {
                if (rs == null) break block34;
                Statement statement = null;
                try {
                    statement = rs.getStatement();
                }
                catch (Exception e) {
                    try {
                        throw new SaikuServiceException((Throwable)e);
                    }
                    catch (Throwable throwable) {
                        try {
                            rs.close();
                            if (statement == null) throw throwable;
                            statement.close();
                            throw throwable;
                        }
                        catch (Exception exception) {}
                    }
                }
                try {
                    rs.close();
                    if (statement != null) {
                        statement.close();
                    }
                }
                catch (Exception error) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @GET
    @Produces(value={"text/csv"})
    @Path(value="/{queryname}/drillthrough/export/csv")
    public Response getDrillthroughExport(@PathParam(value="queryname") String queryName, @QueryParam(value="maxrows") @DefaultValue(value="100") Integer maxrows, @QueryParam(value="position") String position, @QueryParam(value="returns") String returns) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/drillthrough/export/csv (maxrows:" + maxrows + " position" + position + ")\tGET");
        }
        ResultSet rs = null;
        try {
            if (position == null) {
                rs = this.thinQueryService.drillthrough(queryName, maxrows.intValue(), returns);
            } else {
                Response positions = position.split(":");
                ArrayList<Integer> cellPosition = new ArrayList<Integer>();
                for (String p : positions) {
                    Integer pInt = Integer.parseInt(p);
                    cellPosition.add(pInt);
                }
                rs = this.thinQueryService.drillthrough(queryName, cellPosition, maxrows, returns);
            }
            byte[] doc = this.thinQueryService.exportResultSetCsv(rs);
            String name = SaikuProperties.webExportCsvName;
            Response response = Response.ok((Object)doc, (String)"application/octet-stream").header("content-disposition", (Object)("attachment; filename = " + name + "-drillthrough.csv")).header("content-length", (Object)doc.length).build();
            return response;
        }
        catch (Exception e) {
            log.error("Cannot export drillthrough query (" + queryName + ")", (Throwable)e);
            Response response = Response.serverError().build();
            return response;
        }
        finally {
            if (rs != null) {
                try {
                    Statement statement = rs.getStatement();
                    statement.close();
                    rs.close();
                }
                catch (SQLException e) {
                    throw new SaikuServiceException((Throwable)e);
                }
            }
        }
    }

    @POST
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf")
    public Response exportPdfWithChart(@PathParam(value="queryname") String queryName, @PathParam(value="svg") @DefaultValue(value="") String svg) {
        return this.exportPdfWithChartAndFormat(queryName, null, svg, null);
    }

    @GET
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf")
    public Response exportPdf(@PathParam(value="queryname") String queryName) {
        return this.exportPdfWithChartAndFormat(queryName, null, null, null);
    }

    @GET
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf/{format}")
    public Response exportPdfWithFormat(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format, @QueryParam(value="exportname") String name) {
        return this.exportPdfWithChartAndFormat(queryName, format, null, name);
    }

    @POST
    @Produces(value={"application/pdf"})
    @Path(value="/{queryname}/export/pdf/{format}")
    public Response exportPdfWithChartAndFormat(@PathParam(value="queryname") String queryName, @PathParam(value="format") String format, @FormParam(value="svg") @DefaultValue(value="") String svg, @QueryParam(value="name") String name) {
        try {
            CellDataSet cellData = this.thinQueryService.getFormattedResult(queryName, format);
            QueryResult queryResult = RestUtil.convert(cellData);
            PdfReport pdf = new PdfReport();
            byte[] doc = pdf.createPdf(queryResult, svg);
            if (name == null || name.equals("")) {
                name = "export";
            }
            return Response.ok((Object)doc).type("application/pdf").header("content-disposition", (Object)("attachment; filename = " + name + ".pdf")).header("content-length", (Object)doc.length).build();
        }
        catch (Exception e) {
            log.error("Error exporting query to  PDF", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @GET
    @Produces(value={"text/html"})
    @Path(value="/{queryname}/export/html")
    @ReturnType(value="java.lang.String")
    public Response exportHtml(@PathParam(value="queryname") String queryname, @QueryParam(value="format") String format, @QueryParam(value="css") @DefaultValue(value="false") Boolean css, @QueryParam(value="tableonly") @DefaultValue(value="false") Boolean tableonly, @QueryParam(value="wrapcontent") @DefaultValue(value="true") Boolean wrapcontent) {
        ThinQuery tq = this.thinQueryService.getContext(queryname).getOlapQuery();
        return this.exportHtml(tq, format, css, tableonly, wrapcontent);
    }

    @POST
    @Produces(value={"text/html"})
    @Path(value="/export/html")
    @ReturnType(value="java.lang.String")
    public Response exportHtml(ThinQuery tq, @QueryParam(value="format") String format, @QueryParam(value="css") @DefaultValue(value="false") Boolean css, @QueryParam(value="tableonly") @DefaultValue(value="false") Boolean tableonly, @QueryParam(value="wrapcontent") @DefaultValue(value="true") Boolean wrapcontent) {
        try {
            CellDataSet cs = StringUtils.isNotBlank((String)format) ? this.thinQueryService.execute(tq, format) : this.thinQueryService.execute(tq);
            QueryResult qr = RestUtil.convert(cs);
            String content = JSConverter.convertToHtml(qr, wrapcontent);
            String html = "";
            if (!tableonly.booleanValue()) {
                html = html + "<!DOCTYPE html><html><head><meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">\n";
                if (css.booleanValue()) {
                    html = html + "<style>\n";
                    InputStream is = JSConverter.class.getResourceAsStream("saiku.table.full.css");
                    String cssContent = IOUtils.toString((InputStream)is);
                    html = html + cssContent;
                    html = html + "</style>\n";
                }
                html = html + "</head>\n<body><div class='workspace_results'>\n";
            }
            html = html + content;
            if (!tableonly.booleanValue()) {
                html = html + "\n</div></body></html>";
            }
            return Response.ok((Object)html).build();
        }
        catch (Exception e) {
            log.error("Error exporting query to  HTML", (Throwable)e);
            return Response.serverError().entity((Object)e.getMessage()).status(Response.Status.INTERNAL_SERVER_ERROR).build();
        }
    }

    @POST
    @Produces(value={"application/json"})
    @Path(value="/{queryname}/drillacross")
    public ThinQuery drillacross(@PathParam(value="queryname") String queryName, @FormParam(value="position") String position, @FormParam(value="drill") String returns) {
        if (log.isDebugEnabled()) {
            log.debug("TRACK\t\t/query/" + queryName + "/drillacross\tPOST");
        }
        try {
            String[] positions = position.split(":");
            ArrayList<Integer> cellPosition = new ArrayList<Integer>();
            for (String p : positions) {
                Integer pInt = Integer.parseInt(p);
                cellPosition.add(pInt);
            }
            ObjectMapper mapper = new ObjectMapper();
            CollectionType ct = mapper.getTypeFactory().constructCollectionType(ArrayList.class, String.class);
            JavaType st = mapper.getTypeFactory().uncheckedSimpleType(String.class);
            Map levels = (Map)mapper.readValue(returns, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, st, (JavaType)ct));
            return this.thinQueryService.drillacross(queryName, cellPosition, levels);
        }
        catch (Exception e) {
            log.error("Cannot execute query (" + queryName + ")", (Throwable)e);
            String error = ExceptionUtils.getRootCauseMessage((Throwable)e);
            throw new WebApplicationException(Response.serverError().entity((Object)error).build());
        }
    }

    public ThinQueryService getThinQueryService() {
        return this.thinQueryService;
    }
}

