/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.olap.totals;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Member;

public class AxisInfo {
    public List<Integer>[] levels;
    public final List<String> uniqueLevelNames = new ArrayList<String>();
    public int maxDepth;
    public int measuresMember;
    public List<Position> fullPositions;
    public final CellSetAxis axis;

    public AxisInfo(CellSetAxis axis) {
        this.axis = axis;
        this.calcAxisInfo(axis);
    }

    private void calcAxisInfo(CellSetAxis axis) {
        AxisInfo.calcAxisInfo(this, axis);
    }

    private static void calcAxisInfo(AxisInfo axisInfo, CellSetAxis axis) {
        List hierarchies = axis.getAxisMetaData().getHierarchies();
        int hCount = hierarchies.size();
        List[] levels = new List[hCount];
        HashSet[][] usedLevels = new HashSet[hCount][];
        int[] maxDepth = new int[hCount];
        for (int i = 0; i < hCount; ++i) {
            maxDepth[i] = -1;
            levels[i] = new ArrayList();
            usedLevels[i] = new HashSet[((Hierarchy)hierarchies.get(i)).getLevels().size()];
            for (int j = 0; j < usedLevels[i].length; ++j) {
                usedLevels[i][j] = new HashSet();
            }
        }
        axisInfo.measuresMember = Integer.MIN_VALUE;
        for (Position p : axis.getPositions()) {
            int mI = 0;
            for (Member m : p.getMembers()) {
                if ("Measures".equals(m.getDimension().getName())) {
                    axisInfo.measuresMember = mI;
                }
                usedLevels[mI][m.getLevel().getDepth()].add(m.getDepth());
                ++mI;
            }
        }
        for (int i = 0; i < usedLevels.length; ++i) {
            for (int j = 0; j < usedLevels[i].length; ++j) {
                if (usedLevels[i][j].size() <= 0) continue;
                HashSet obj = usedLevels[i][j];
                Iterator it = obj.iterator();
                while (it.hasNext()) {
                    levels[i].add(it.next());
                }
                axisInfo.uniqueLevelNames.add(((Level)((Hierarchy)hierarchies.get(i)).getLevels().get(j)).getUniqueName());
            }
        }
        int maxAxisDepth = 0;
        for (int i = 0; i < hCount; ++i) {
            maxAxisDepth += levels[i].size();
        }
        axisInfo.levels = levels;
        axisInfo.maxDepth = maxAxisDepth;
        AxisInfo.findFullPositions(axisInfo, axis);
    }

    private static void findFullPositions(AxisInfo axisInfo, CellSetAxis axis) {
        axisInfo.fullPositions = new ArrayList<Position>(axis.getPositionCount());
        List<Integer>[] levels = axisInfo.levels;
        block0: for (Position p : axis.getPositions()) {
            int mI = 0;
            for (Member m : p.getMembers()) {
                int maxDepth = levels[mI].get(levels[mI].size() - 1);
                if (m.getDepth() < maxDepth) continue block0;
                ++mI;
            }
            axisInfo.fullPositions.add(p);
        }
    }
}

