/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.importer;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.UUID;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.jcr.RepositoryException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSystemManager;
import org.apache.commons.vfs.VFS;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.importer.JujuSource;
import org.saiku.service.importer.LegacyImporter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LegacyImporterImpl
implements LegacyImporter {
    private static final Logger log = LoggerFactory.getLogger(LegacyImporter.class);
    private final IDatasourceManager dsm;
    private URL repoURL;

    public LegacyImporterImpl(IDatasourceManager dsm) {
        this.dsm = dsm;
    }

    @Override
    public void importUsers() {
        this.setPath("res:");
    }

    @Override
    public void importSchema() {
        block6: {
            this.setPath("res:legacy-schema");
            try {
                File[] files;
                if (this.repoURL == null || (files = new File(this.repoURL.getFile()).listFiles()) == null) break block6;
                for (File file : files) {
                    if (file.isHidden() || file.getName().equals("README")) continue;
                    byte[] encoded = null;
                    try {
                        encoded = IOUtils.toByteArray((InputStream)new FileInputStream(file));
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    String str = null;
                    if (encoded != null) {
                        str = new String(encoded, Charset.forName("UTF8"));
                    }
                    this.dsm.addSchema(str, "/datasources/" + file.getName(), "admin");
                }
            }
            catch (Exception e1) {
                e1.printStackTrace();
            }
        }
    }

    @Override
    public void importDatasources() {
        block8: {
            this.setPath("res:legacy-datasources");
            try {
                File[] files;
                if (this.repoURL == null || (files = new File(this.repoURL.getFile()).listFiles()) == null) break block8;
                for (File file : files) {
                    if (file.isHidden() || file.getName().equals("README")) continue;
                    Properties props = new Properties();
                    try {
                        props.load(new FileInputStream(file));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String name = props.getProperty("name");
                    String type = props.getProperty("type");
                    if (props.getProperty("location") != null) {
                        String toSplit = props.getProperty("location");
                        String[] split = toSplit.split(";");
                        for (int i = 0; i < split.length; ++i) {
                            String fixedString;
                            String s = split[i];
                            if (!s.startsWith("Catalog=")) continue;
                            Path p = Paths.get(s.substring(8, s.length()), new String[0]);
                            String f = p.getFileName().toString();
                            split[i] = fixedString = "Catalog=mondrian:///datasources/" + f;
                            StringBuilder builder = new StringBuilder();
                            for (String str : split) {
                                builder.append(str).append(";");
                            }
                            props.setProperty("location", builder.toString());
                        }
                    }
                    if (name == null || type == null) continue;
                    props.put("id", UUID.randomUUID().toString());
                    props.put("advanced", "true");
                    SaikuDatasource.Type t = SaikuDatasource.Type.valueOf(type.toUpperCase());
                    SaikuDatasource ds = new SaikuDatasource(name, t, props);
                    this.dsm.addDatasource(ds);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private void setPath(String path) {
        try {
            FileSystemManager fileSystemManager = VFS.getManager();
            FileObject fileObject = fileSystemManager.resolveFile(path);
            if (fileObject == null) {
                throw new IOException("File cannot be resolved: " + path);
            }
            if (!fileObject.exists()) {
                throw new IOException("File does not exist: " + path);
            }
            this.repoURL = fileObject.getURL();
            if (this.repoURL == null) {
                throw new Exception("Cannot load connection repository from path: " + path);
            }
        }
        catch (Exception e) {
            log.error("Exception", (Throwable)e);
        }
    }

    @Override
    public void importLegacyReports(IRepositoryManager repositoryManager, byte[] file) {
        ZipInputStream zis = new ZipInputStream(new ByteArrayInputStream(file));
        ZipEntry ze = null;
        try {
            ze = zis.getNextEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String strUnzipped = "";
        while (ze != null) {
            String fileName = ze.getName();
            byte[] buffer = new byte[2048];
            FileOutputStream fos = null;
            try {
                fos = new FileOutputStream(fileName);
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
            }
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            try {
                int size;
                while ((size = zis.read(buffer, 0, buffer.length)) != -1) {
                    bos.write(buffer, 0, size);
                }
                bos.flush();
                bos.close();
                strUnzipped = new String(bos.toByteArray(), "UTF-8");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            try {
                repositoryManager.saveInternalFile(strUnzipped, "/etc/legacyreports/" + fileName, "nt:saikufiles");
            }
            catch (RepositoryException e) {
                e.printStackTrace();
            }
            try {
                ze = zis.getNextEntry();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        try {
            zis.closeEntry();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        try {
            zis.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<JujuSource> importJujuDatasources() {
        ArrayList<JujuSource> sources;
        block5: {
            this.setPath("res:juju-datasources");
            sources = new ArrayList<JujuSource>();
            try {
                File[] files;
                if (this.repoURL == null || (files = new File(this.repoURL.getFile()).listFiles()) == null) break block5;
                for (File file : files) {
                    if (file.isHidden() || file.getName().equals("README")) continue;
                    Properties props = new Properties();
                    try {
                        props.load(new FileInputStream(file));
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    String name = props.getProperty("name");
                    String jdbcurl = props.getProperty("jdbcurl");
                    String username = props.getProperty("username");
                    String password = props.getProperty("password");
                    String driver = props.getProperty("driver");
                    JujuSource s = new JujuSource(name, jdbcurl, username, password, driver);
                    sources.add(s);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return sources;
    }
}

