/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.service.datasource;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.jcr.PathNotFoundException;
import javax.jcr.RepositoryException;
import org.saiku.database.dto.MondrianSchema;
import org.saiku.datasources.connection.RepositoryFile;
import org.saiku.datasources.datasource.SaikuDatasource;
import org.saiku.repository.AclEntry;
import org.saiku.repository.DataSource;
import org.saiku.repository.IRepositoryManager;
import org.saiku.repository.IRepositoryObject;
import org.saiku.service.datasource.IDatasourceManager;
import org.saiku.service.datasource.RepositoryDatasourceManager;
import org.saiku.service.importer.JujuSource;
import org.saiku.service.importer.LegacyImporterImpl;
import org.saiku.service.user.UserService;
import org.saiku.service.util.exception.SaikuServiceException;
import org.saiku.service.util.security.authentication.PasswordProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ClassPathResourceDatasourceManager
implements IDatasourceManager {
    private final Map<String, SaikuDatasource> datasources = Collections.synchronizedMap(new HashMap());
    private UserService userService;
    private static final Logger log = LoggerFactory.getLogger(RepositoryDatasourceManager.class);
    private String configurationpath;
    private String datadir;
    private IRepositoryManager irm;
    private String foodmartdir;
    private String foodmartschema;
    private String foodmarturl;
    private PasswordProvider repopasswordprovider;
    private String oldpassword;
    private String earthquakeurl;
    private String earthquakedir;
    private String earthquakeschema;
    private String defaultRole;
    private String externalparameters;

    @Override
    public void load() {
        Properties ext = this.checkForExternalDataSourceProperties();
        this.datasources.clear();
        try {
            List<DataSource> exporteddatasources = null;
            try {
                exporteddatasources = this.irm.getAllDataSources();
            }
            catch (RepositoryException e1) {
                log.error("Could not export data sources", (Throwable)e1);
            }
            if (exporteddatasources != null) {
                for (DataSource file : exporteddatasources) {
                    String p;
                    if (file.getName() == null || file.getType() == null) continue;
                    Properties props = new Properties();
                    if (file.getDriver() != null) {
                        props.put("driver", file.getDriver());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".driver")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".driver");
                        props.put("driver", p);
                    }
                    if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".location")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".location");
                        if (ext.containsKey("datasource." + file.getPropertyKey() + ".schemaoverride")) {
                            String[] spl = p.split(";");
                            spl[1] = "Catalog=mondrian://" + file.getSchema();
                            StringBuilder sb = new StringBuilder();
                            for (String str : spl) {
                                sb.append(str + ";");
                            }
                            props.put("location", sb.toString());
                        } else {
                            props.put("location", p);
                        }
                    } else if (file.getLocation() != null) {
                        props.put("location", file.getLocation());
                    }
                    if (file.getUsername() != null && file.getPropertyKey() == null) {
                        props.put("username", file.getUsername());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".username")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".username");
                        props.put("username", p);
                    }
                    if (file.getPassword() != null && file.getPropertyKey() == null) {
                        props.put("password", file.getPassword());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".password")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".password");
                        props.put("password", p);
                    }
                    if (file.getPath() != null) {
                        props.put("path", file.getPath());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".path")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".path");
                        props.put("path", p);
                    }
                    if (file.getId() != null) {
                        props.put("id", file.getId());
                    }
                    if (file.getSecurityenabled() != null) {
                        props.put("security.enabled", file.getSecurityenabled());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.enabled")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.enabled");
                        props.put("security.enabled", p);
                    }
                    if (file.getSecuritytype() != null) {
                        props.put("security.type", file.getSecuritytype());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.type")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.type");
                        props.put("security.type", p);
                    }
                    if (file.getSecuritymapping() != null) {
                        props.put("security.mapping", file.getSecuritymapping());
                    } else if (file.getPropertyKey() != null && ext.containsKey("datasource." + file.getPropertyKey() + ".security.mapping")) {
                        p = ext.getProperty("datasource." + file.getPropertyKey() + ".security.mapping");
                        props.put("security.mapping", p);
                    }
                    if (file.getAdvanced() != null) {
                        props.put("advanced", file.getAdvanced());
                    }
                    if (file.getPropertyKey() != null) {
                        props.put("propertykey", file.getPropertyKey());
                    }
                    SaikuDatasource.Type t = SaikuDatasource.Type.valueOf(file.getType().toUpperCase());
                    SaikuDatasource ds = new SaikuDatasource(file.getName(), t, props);
                    this.datasources.put(file.getName(), ds);
                }
            }
        }
        catch (Exception e) {
            throw new SaikuServiceException(e.getMessage(), e);
        }
    }

    public Properties checkForExternalDataSourceProperties() {
        Properties p = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.externalparameters);
            p.load(input);
        }
        catch (IOException e) {
            log.debug("file did not exist");
        }
        return p;
    }

    @Override
    public String[] getAvailablePropertiesKeys() {
        Properties p = new Properties();
        try {
            FileInputStream input = new FileInputStream(this.externalparameters);
            p.load(input);
        }
        catch (IOException e) {
            log.debug("file did not exist");
        }
        String[] arr = p.keySet().toArray(new String[p.keySet().size()]);
        ArrayList<String> newlist = new ArrayList<String>();
        for (String str : arr) {
            String[] s = str.split("\\.");
            newlist.add(s[1]);
        }
        HashSet unique = new HashSet(newlist);
        return unique.toArray(new String[unique.size()]);
    }

    @Override
    public List<JujuSource> getJujuDatasources() {
        return null;
    }

    @Override
    public void unload() {
        this.irm.shutdown();
    }

    @Override
    public SaikuDatasource addDatasource(SaikuDatasource datasource) throws Exception {
        DataSource ds = new DataSource(datasource);
        this.irm.saveDataSource(ds, "/datasources/" + ds.getName() + ".sds", "fixme");
        this.datasources.put(datasource.getName(), datasource);
        return datasource;
    }

    @Override
    public SaikuDatasource setDatasource(SaikuDatasource datasource) throws Exception {
        return this.addDatasource(datasource);
    }

    @Override
    public List<SaikuDatasource> addDatasources(List<SaikuDatasource> dsources) {
        for (SaikuDatasource datasource : dsources) {
            DataSource ds = new DataSource(datasource);
            try {
                this.irm.saveDataSource(ds, "/datasources/" + ds.getName() + ".sds", "fixme");
                this.datasources.put(datasource.getName(), datasource);
            }
            catch (RepositoryException e) {
                log.error("Could not add data source" + datasource.getName(), (Throwable)e);
            }
        }
        return dsources;
    }

    @Override
    public boolean removeDatasource(String datasourceId) {
        List<DataSource> ds = null;
        try {
            ds = this.irm.getAllDataSources();
        }
        catch (RepositoryException e) {
            log.error("Could not get all data sources");
        }
        if (ds != null) {
            for (DataSource data : ds) {
                if (!data.getId().equals(datasourceId)) continue;
                this.datasources.remove(data.getName());
                this.irm.deleteFile(data.getPath());
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean removeSchema(String schemaName) {
        List<MondrianSchema> s = null;
        try {
            s = this.irm.getAllSchema();
        }
        catch (RepositoryException e) {
            log.error("Could not get All Schema", (Throwable)e);
        }
        if (s != null) {
            for (MondrianSchema data : s) {
                if (!data.getName().equals(schemaName)) continue;
                this.irm.deleteFile(data.getPath());
                break;
            }
            return true;
        }
        return false;
    }

    @Override
    public Map<String, SaikuDatasource> getDatasources(String[] roles) {
        return this.datasources;
    }

    @Override
    public SaikuDatasource getDatasource(String datasourceName) {
        return this.datasources.get(datasourceName);
    }

    @Override
    public SaikuDatasource getDatasource(String datasourceName, boolean refresh) {
        if (!refresh) {
            if (this.datasources.size() > 0) {
                return this.datasources.get(datasourceName);
            }
        } else {
            return this.getDatasource(datasourceName);
        }
        return null;
    }

    @Override
    public void addSchema(String file, String path, String name) throws Exception {
        this.irm.saveInternalFile(file, path, "nt:mondrianschema");
    }

    @Override
    public List<MondrianSchema> getMondrianSchema() {
        try {
            return this.irm.getAllSchema();
        }
        catch (RepositoryException e) {
            log.error("Could not get all Schema", (Throwable)e);
            return null;
        }
    }

    @Override
    public MondrianSchema getMondrianSchema(String catalog) {
        return null;
    }

    @Override
    public RepositoryFile getFile(String file) {
        return this.irm.getFile(file);
    }

    @Override
    public String getFileData(String file, String username, List<String> roles) {
        try {
            return this.irm.getFile(file, username, roles);
        }
        catch (RepositoryException e) {
            log.error("Could not get file " + file, (Throwable)e);
            return null;
        }
    }

    @Override
    public String getInternalFileData(String file) throws RepositoryException {
        return this.irm.getInternalFile(file);
    }

    @Override
    public InputStream getBinaryInternalFileData(String file) throws RepositoryException {
        return this.irm.getBinaryInternalFile(file);
    }

    @Override
    public String saveFile(String path, Object content, String user, List<String> roles) {
        try {
            this.irm.saveFile(content, path, user, "nt:saikufiles", roles);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            log.error("Save Failed", (Throwable)e);
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String removeFile(String path, String user, List<String> roles) {
        try {
            this.irm.removeFile(path, user, roles);
            return "Remove Okay";
        }
        catch (RepositoryException e) {
            log.error("Save Failed", (Throwable)e);
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String moveFile(String source, String target, String user, List<String> roles) {
        try {
            this.irm.moveFile(source, target, user, roles);
            return "Move Okay";
        }
        catch (RepositoryException e) {
            log.error("Move Failed", (Throwable)e);
            return "Move Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String saveInternalFile(String path, Object content, String type) {
        try {
            this.irm.saveInternalFile(content, path, type);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public String saveBinaryInternalFile(String path, InputStream content, String type) {
        try {
            this.irm.saveBinaryInternalFile(content, path, type);
            return "Save Okay";
        }
        catch (RepositoryException e) {
            e.printStackTrace();
            return "Save Failed: " + e.getLocalizedMessage();
        }
    }

    @Override
    public void removeInternalFile(String filePath) {
        try {
            this.irm.removeInternalFile(filePath);
        }
        catch (RepositoryException e) {
            log.error("Remove file failed: " + filePath);
            e.printStackTrace();
        }
    }

    @Override
    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles) {
        return this.irm.getAllFiles(type, username, roles);
    }

    @Override
    public List<IRepositoryObject> getFiles(List<String> type, String username, List<String> roles, String path) {
        try {
            return this.irm.getAllFiles(type, username, roles, path);
        }
        catch (RepositoryException e) {
            log.error("Get failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public void createUser(String username) {
        try {
            this.irm.createUser(username);
        }
        catch (RepositoryException e) {
            log.error("Create User Failed", (Throwable)e);
        }
    }

    @Override
    public void deleteFolder(String folder) {
        try {
            this.irm.deleteFolder(folder);
        }
        catch (RepositoryException e) {
            log.error("Delete User Failed", (Throwable)e);
        }
    }

    @Override
    public AclEntry getACL(String object, String username, List<String> roles) {
        return this.irm.getACL(object, username, roles);
    }

    @Override
    public void setACL(String object, String acl, String username, List<String> roles) {
        try {
            this.irm.setACL(object, acl, username, roles);
        }
        catch (RepositoryException e) {
            log.error("Set ACL Failed", (Throwable)e);
        }
    }

    @Override
    public void setUserService(UserService userService) {
        this.userService = userService;
    }

    @Override
    public List<MondrianSchema> getInternalFilesOfFileType(String type) {
        try {
            return this.irm.getInternalFilesOfFileType(type);
        }
        catch (RepositoryException e) {
            log.error("Get internal file failed", (Throwable)e);
            return null;
        }
    }

    @Override
    public void createFileMixin(String type) throws RepositoryException {
        this.irm.createFileMixin(type);
    }

    @Override
    public byte[] exportRepository() {
        try {
            return this.irm.exportRepository();
        }
        catch (RepositoryException e) {
            log.error("could not export repository", (Throwable)e);
        }
        catch (IOException e) {
            log.error("could not export repository IO issue", (Throwable)e);
        }
        return null;
    }

    @Override
    public void restoreRepository(byte[] data) {
        try {
            this.irm.restoreRepository(data);
        }
        catch (Exception e) {
            log.error("Could not restore export", (Throwable)e);
        }
    }

    @Override
    public boolean hasHomeDirectory(String name) {
        try {
            Object eturn = this.irm.getHomeFolder(name);
            return eturn != null;
        }
        catch (PathNotFoundException e) {
            return false;
        }
        catch (RepositoryException e) {
            log.error("could not get home directory");
            return false;
        }
    }

    @Override
    public void restoreLegacyFiles(byte[] data) {
        LegacyImporterImpl l = new LegacyImporterImpl(null);
        l.importLegacyReports(this.irm, data);
    }

    public Object getRepository() {
        return this.irm.getRepositoryObject();
    }

    public void setConfigurationpath(String configurationpath) {
        this.configurationpath = configurationpath;
    }

    public String getConfigurationpath() {
        return this.configurationpath;
    }

    @Override
    public void setDatadir(String datadir) {
        this.datadir = datadir;
    }

    @Override
    public String getDatadir() {
        return this.datadir;
    }

    @Override
    public void setFoodmartdir(String foodmartdir) {
        this.foodmartdir = foodmartdir;
    }

    @Override
    public String getFoodmartdir() {
        return this.foodmartdir;
    }

    @Override
    public void setFoodmartschema(String foodmartschema) {
        this.foodmartschema = foodmartschema;
    }

    @Override
    public String getFoodmartschema() {
        return this.foodmartschema;
    }

    @Override
    public void setFoodmarturl(String foodmarturl) {
        this.foodmarturl = foodmarturl;
    }

    @Override
    public String getFoodmarturl() {
        return this.foodmarturl;
    }

    @Override
    public String getEarthquakeUrl() {
        return this.earthquakeurl;
    }

    @Override
    public String getEarthquakeDir() {
        return this.earthquakedir;
    }

    @Override
    public String getEarthquakeSchema() {
        return this.earthquakeschema;
    }

    @Override
    public void setEarthquakeUrl(String earthquakeurl) {
        this.earthquakeurl = earthquakeurl;
    }

    @Override
    public void setEarthquakeDir(String earthquakedir) {
        this.earthquakedir = earthquakedir;
    }

    @Override
    public void setEarthquakeSchema(String earthquakeschema) {
        this.earthquakeschema = earthquakeschema;
    }

    @Override
    public void setExternalPropertiesFile(String file) {
        this.externalparameters = file;
    }

    public void setRepoPasswordProvider(PasswordProvider passwordProvider) {
        this.repopasswordprovider = passwordProvider;
    }

    public PasswordProvider getRepopasswordprovider() {
        return this.repopasswordprovider;
    }

    public void setOldRepoPassword(String password) {
        this.oldpassword = password;
    }

    public String getOldRepopassword() {
        return this.oldpassword;
    }

    public void setDefaultRole(String defaultRole) {
        this.defaultRole = defaultRole;
    }

    @Override
    public String getType() {
        return "classpath";
    }
}

