/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query2.util;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap4j.SaikuMondrianHelper;
import org.apache.commons.lang.StringUtils;
import org.olap4j.Axis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.impl.IdentifierParser;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Cube;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.saiku.olap.query2.ThinAxis;
import org.saiku.olap.query2.ThinCalculatedMeasure;
import org.saiku.olap.query2.ThinCalculatedMember;
import org.saiku.olap.query2.ThinDetails;
import org.saiku.olap.query2.ThinHierarchy;
import org.saiku.olap.query2.ThinLevel;
import org.saiku.olap.query2.ThinMeasure;
import org.saiku.olap.query2.ThinMember;
import org.saiku.olap.query2.ThinQuery;
import org.saiku.olap.query2.ThinQueryModel;
import org.saiku.olap.query2.common.ThinQuerySet;
import org.saiku.olap.query2.common.ThinSortableQuerySet;
import org.saiku.olap.query2.filter.ThinFilter;
import org.saiku.query.IQuerySet;
import org.saiku.query.ISortableQuerySet;
import org.saiku.query.Parameter;
import org.saiku.query.Query;
import org.saiku.query.QueryAxis;
import org.saiku.query.QueryDetails;
import org.saiku.query.QueryHierarchy;
import org.saiku.query.QueryLevel;
import org.saiku.query.SortOrder;
import org.saiku.query.mdx.GenericFilter;
import org.saiku.query.mdx.IFilterFunction;
import org.saiku.query.mdx.NFilter;
import org.saiku.query.mdx.NameFilter;
import org.saiku.query.mdx.NameLikeFilter;
import org.saiku.query.metadata.CalculatedMeasure;
import org.saiku.query.metadata.CalculatedMember;

public class Fat {
    public static Query convert(ThinQuery tq, Cube cube) throws SQLException {
        Query q = new Query(tq.getName(), cube);
        if (tq.getParameters() != null) {
            q.setParameters(tq.getParameters());
        }
        if (tq.getQueryModel() == null) {
            return q;
        }
        ThinQueryModel model = tq.getQueryModel();
        Fat.convertCalculatedMembers(q, model.getCalculatedMembers());
        Fat.convertAxes(q, tq.getQueryModel().getAxes(), tq);
        Fat.convertCalculatedMeasures(q, model.getCalculatedMeasures());
        Fat.convertDetails(q, model.getDetails());
        q.setVisualTotals(model.isVisualTotals());
        q.setVisualTotalsPattern(model.getVisualTotalsPattern());
        return q;
    }

    private static void convertCalculatedMembers(Query q, List<ThinCalculatedMember> thinCms) {
        if (thinCms != null && thinCms.size() > 0) {
            for (ThinCalculatedMember qcm : thinCms) {
                String name = qcm.getHierarchyName();
                boolean mondrian3 = false;
                if (SaikuMondrianHelper.getMondrianServer((OlapConnection)q.getConnection()).getVersion().getMajorVersion() == 3) {
                    name = qcm.getHierarchyName().replaceAll("\\[", "");
                    name = name.replaceAll("]", "");
                    mondrian3 = true;
                }
                NamedList hs = q.getCube().getHierarchies();
                Hierarchy h = null;
                for (Hierarchy h2 : hs) {
                    if (h2.getUniqueName().equals(qcm.getHierarchyName())) {
                        h = h2;
                        continue;
                    }
                    if (!h2.getUniqueName().equals(name)) continue;
                    h = h2;
                    break;
                }
                Member parent = null;
                if (qcm.getParentMember() != null) {
                    try {
                        parent = q.getCube().lookupMember(IdentifierParser.parseIdentifier((String)qcm.getParentMember()));
                    }
                    catch (OlapException e) {
                        e.printStackTrace();
                    }
                }
                CalculatedMember cm = new CalculatedMember(h.getDimension(), h, qcm.getName(), null, parent, Member.Type.FORMULA, qcm.getFormula(), qcm.getProperties(), mondrian3);
                q.addCalculatedMember(q.getHierarchy(h), cm);
            }
        }
    }

    private static void convertCalculatedMeasures(Query q, List<ThinCalculatedMeasure> thinCms) {
        if (thinCms != null && thinCms.size() > 0) {
            for (ThinCalculatedMeasure qcm : thinCms) {
                Hierarchy h = (Hierarchy)q.getCube().getHierarchies().get("Measures");
                CalculatedMeasure cm = new CalculatedMeasure(h, qcm.getName(), null, qcm.getFormula(), qcm.getProperties());
                q.addCalculatedMeasure(cm);
            }
        }
    }

    private static void convertDetails(Query query, ThinDetails details) {
        QueryDetails.Location loc = QueryDetails.Location.valueOf((String)details.getLocation().toString());
        query.getDetails().setLocation(loc);
        Axis ax = Fat.getLocation(details.getAxis());
        query.getDetails().setAxis(ax);
        if (details.getMeasures().size() > 0) {
            for (ThinMeasure m : details.getMeasures()) {
                Object measure;
                if (ThinMeasure.Type.CALCULATED.equals((Object)m.getType())) {
                    measure = query.getCalculatedMeasure(m.getName());
                    query.getDetails().add((Measure)measure);
                    continue;
                }
                if (!ThinMeasure.Type.EXACT.equals((Object)m.getType())) continue;
                measure = new MeasureAdapter(query.getMeasure(m.getName()), m);
                query.getDetails().add((Measure)measure);
            }
        }
    }

    private static void convertAxes(Query q, Map<ThinQueryModel.AxisLocation, ThinAxis> axes, ThinQuery tq) throws OlapException {
        if (axes != null) {
            for (ThinQueryModel.AxisLocation axis : Fat.sortAxes(axes.keySet())) {
                if (axis == null) continue;
                Fat.convertAxis(q, axes.get((Object)axis), tq);
            }
        }
    }

    private static List<ThinQueryModel.AxisLocation> sortAxes(Set<ThinQueryModel.AxisLocation> axes) {
        ArrayList<ThinQueryModel.AxisLocation> ax = new ArrayList<ThinQueryModel.AxisLocation>();
        for (ThinQueryModel.AxisLocation a : ThinQueryModel.AxisLocation.values()) {
            if (!axes.contains((Object)a)) continue;
            ax.add(a);
        }
        return ax;
    }

    private static void convertAxis(Query query, ThinAxis thinAxis, ThinQuery tq) throws OlapException {
        Axis loc = Fat.getLocation(thinAxis.getLocation());
        QueryAxis qaxis = query.getAxis(loc);
        for (ThinHierarchy hierarchy : thinAxis.getHierarchies()) {
            QueryHierarchy qh = query.getHierarchy(hierarchy.getName());
            if (qh == null) continue;
            Fat.convertHierarchy(query, qh, hierarchy, tq);
            qaxis.addHierarchy(qh);
        }
        qaxis.setNonEmpty(thinAxis.isNonEmpty());
        List<String> aggs = thinAxis.getAggregators();
        qaxis.getQuery().setAggregators(qaxis.getLocation().toString(), aggs);
        Fat.extendSortableQuerySet(query, (ISortableQuerySet)qaxis, thinAxis);
    }

    private static void convertHierarchy(Query q, QueryHierarchy qh, ThinHierarchy th, ThinQuery tq) throws OlapException {
        for (ThinLevel thinLevel : th.getLevels().values()) {
            QueryLevel ql = qh.includeLevel(thinLevel.getName());
            if (ql == null) {
                qh.includeMember(th.getName() + ".[" + thinLevel.getName() + "]");
            } else {
                List<String> aggs = thinLevel.getAggregators();
                qh.getQuery().setAggregators(ql.getUniqueName(), aggs);
                if (thinLevel.getSelection() != null) {
                    String parameter = thinLevel.getSelection().getParameterName();
                    if (StringUtils.isNotBlank((String)parameter)) {
                        ql.setParameterName(parameter);
                        ql.setParameterSelectionType(Parameter.SelectionType.INCLUSION);
                    }
                    switch (thinLevel.getSelection().getType()) {
                        case INCLUSION: {
                            for (ThinMember tm : thinLevel.getSelection().getMembers()) {
                                if (tm.getType() != null && tm.getType().equals("calculatedmember")) continue;
                                qh.includeMember(tm.getUniqueName());
                            }
                            ql.setParameterSelectionType(Parameter.SelectionType.INCLUSION);
                            break;
                        }
                        case EXCLUSION: {
                            for (ThinMember tm : thinLevel.getSelection().getMembers()) {
                                if (tm.getType() != null && tm.getType().equals("calculatedmember")) continue;
                                qh.excludeMember(tm.getUniqueName());
                            }
                            ql.setParameterSelectionType(Parameter.SelectionType.EXCLUSION);
                            break;
                        }
                        case RANGE: {
                            int n = thinLevel.getSelection().getMembers().size();
                            int iterations = thinLevel.getSelection().getMembers().size() / 2;
                            if (n <= 2 || n % 2 != 0) break;
                            for (int i = 0; i < iterations; ++i) {
                                ThinMember start = thinLevel.getSelection().getMembers().get(iterations * 2 + i);
                                ThinMember end = thinLevel.getSelection().getMembers().get(iterations * 2 + i + 1);
                                qh.includeRange(start.getUniqueName(), end.getUniqueName());
                            }
                            break;
                        }
                    }
                }
                Fat.extendQuerySet(qh.getQuery(), (IQuerySet)ql, thinLevel);
            }
            Fat.extendSortableQuerySet(qh.getQuery(), (ISortableQuerySet)qh, th);
        }
        for (Object object : th.getCmembers().entrySet()) {
            int ord;
            String cname;
            Map.Entry pair = (Map.Entry)object;
            ThinCalculatedMember cres = null;
            for (ThinCalculatedMember thinCalculatedMember : tq.getQueryModel().getCalculatedMembers()) {
                if (!thinCalculatedMember.getUniqueName().equals(pair.getValue())) continue;
                cres = thinCalculatedMember;
                break;
            }
            if (cres == null) {
                for (ThinCalculatedMember thinCalculatedMember : tq.getQueryModel().getCalculatedMembers()) {
                    cname = thinCalculatedMember.getUniqueName();
                    ord = StringUtils.ordinalIndexOf((String)cname, (String)"[", (int)2);
                    if (!(cname = cname.substring(ord, cname.length())).equals(pair.getValue())) continue;
                    cres = thinCalculatedMember;
                    break;
                }
            }
            if (cres == null) {
                for (ThinCalculatedMember thinCalculatedMember : tq.getQueryModel().getCalculatedMembers()) {
                    cname = thinCalculatedMember.getUniqueName();
                    ord = StringUtils.ordinalIndexOf((String)((String)pair.getValue()), (String)"[", (int)2);
                    String v = ((String)pair.getValue()).substring(ord, ((String)pair.getValue()).length());
                    if (!cname.equals(v)) continue;
                    cres = thinCalculatedMember;
                    break;
                }
            }
            Hierarchy h2 = null;
            for (Hierarchy h : q.getCube().getHierarchies()) {
                if (!h.getUniqueName().equals(cres.getHierarchyName())) continue;
                h2 = h;
                break;
            }
            Member member = null;
            if (cres.getParentMember() != null) {
                List nameParts = IdentifierParser.parseIdentifier((String)cres.getParentMember());
                member = q.getCube().lookupMember(nameParts);
            }
            boolean mondrian3 = false;
            if (SaikuMondrianHelper.getMondrianServer((OlapConnection)q.getConnection()).getVersion().getMajorVersion() == 3) {
                mondrian3 = true;
            }
            CalculatedMember calculatedMember = new CalculatedMember((Dimension)q.getCube().getDimensions().get(cres.getDimension()), h2, cres.getName(), cres.getName(), member, Member.Type.FORMULA, cres.getFormula(), null, cres.getAssignedLevel(), mondrian3);
            String level = null;
            if (cres.getAssignedLevel() != null && !cres.getAssignedLevel().equals("")) {
                String[] split = cres.getAssignedLevel().split("\\.\\[");
                level = split[split.length - 1];
                level = level.substring(0, level.length() - 1);
            } else {
                level = ((Level)h2.getLevels().get(0)).getName();
            }
            for (ThinLevel tl : th.getLevels().values()) {
                if (tl.getName().equals(level) && (tl.getSelection() == null || tl.getSelection().getMembers().size() == 0)) {
                    qh.includeCalculatedMember(calculatedMember, false);
                    continue;
                }
                if (!tl.getName().equals(level)) continue;
                for (ThinMember tm : tl.getSelection().getMembers()) {
                    if (tm.getType() == null || !tm.getType().equals("calculatedmember") || !tm.getUniqueName().equals(calculatedMember.getUniqueName())) continue;
                    qh.includeCalculatedMember(calculatedMember, true);
                }
            }
            Fat.extendSortableQuerySet(qh.getQuery(), (ISortableQuerySet)qh, th);
        }
        Fat.extendSortableQuerySet(qh.getQuery(), (ISortableQuerySet)qh, th);
    }

    private static Axis getLocation(ThinQueryModel.AxisLocation axis) {
        String ax = axis.toString();
        if (ThinQueryModel.AxisLocation.ROWS.toString().equals(ax)) {
            return Axis.ROWS;
        }
        if (ThinQueryModel.AxisLocation.COLUMNS.toString().equals(ax)) {
            return Axis.COLUMNS;
        }
        if (ThinQueryModel.AxisLocation.FILTER.toString().equals(ax)) {
            return Axis.FILTER;
        }
        if (ThinQueryModel.AxisLocation.PAGES.toString().equals(ax)) {
            return Axis.PAGES;
        }
        return null;
    }

    private static void extendQuerySet(Query q, IQuerySet qs, ThinQuerySet ts) {
        qs.setMdxSetExpression(ts.getMdx());
        if (ts.getFilters() != null && ts.getFilters().size() > 0) {
            List<IFilterFunction> filters = Fat.convertFilters(q, ts.getFilters());
            qs.getFilters().addAll(filters);
        }
    }

    private static List<IFilterFunction> convertFilters(Query q, List<ThinFilter> filters) {
        ArrayList<IFilterFunction> qfs = new ArrayList<IFilterFunction>();
        for (ThinFilter f : filters) {
            switch (f.getFlavour()) {
                case Name: {
                    List<String> exp = f.getExpressions();
                    if (exp == null || exp.size() <= 1) break;
                    String hierarchyName = exp.remove(0);
                    QueryHierarchy qh = q.getHierarchy(hierarchyName);
                    String op = null;
                    if (f.getOperator() != null) {
                        op = f.getOperator().toString();
                    }
                    NameFilter nf = new NameFilter(qh.getHierarchy(), exp, op);
                    qfs.add((IFilterFunction)nf);
                    break;
                }
                case NameLike: {
                    List<String> exp2 = f.getExpressions();
                    if (exp2 == null || exp2.size() <= 1) break;
                    String hierarchyName = exp2.remove(0);
                    QueryHierarchy qh = q.getHierarchy(hierarchyName);
                    String op = null;
                    if (f.getOperator() != null) {
                        op = f.getOperator().toString();
                    }
                    NameLikeFilter nf = new NameLikeFilter(qh.getHierarchy(), exp2, op);
                    qfs.add((IFilterFunction)nf);
                    break;
                }
                case Generic: {
                    List<String> gexp = f.getExpressions();
                    if (gexp == null || gexp.size() != 1) break;
                    GenericFilter gf = new GenericFilter(gexp.get(0));
                    qfs.add((IFilterFunction)gf);
                    break;
                }
                case Measure: {
                    break;
                }
                case N: {
                    List<String> nexp = f.getExpressions();
                    if (nexp == null || nexp.size() <= 0) break;
                    IFilterFunction.MdxFunctionType mf = IFilterFunction.MdxFunctionType.valueOf((String)f.getFunction().toString());
                    int n = Integer.parseInt(nexp.get(0));
                    String expression = null;
                    if (nexp.size() > 1) {
                        expression = nexp.get(1);
                    }
                    NFilter nf = new NFilter(mf, n, expression);
                    qfs.add((IFilterFunction)nf);
                    break;
                }
            }
        }
        return qfs;
    }

    private static void extendSortableQuerySet(Query q, ISortableQuerySet qs, ThinSortableQuerySet ts) {
        Fat.extendQuerySet(q, (IQuerySet)qs, ts);
        if (ts.getHierarchizeMode() != null) {
            qs.setHierarchizeMode(ISortableQuerySet.HierarchizeMode.valueOf((String)ts.getHierarchizeMode().toString()));
        }
        if (ts.getSortOrder() != null) {
            qs.sort(SortOrder.valueOf((String)ts.getSortOrder().toString()), ts.getSortEvaluationLiteral());
        }
    }

    public static class MeasureAdapter
    implements Measure {
        private Measure measure;
        private ThinMeasure thinMeasure;

        public MeasureAdapter(Measure measure, ThinMeasure thinMeasure) {
            this.measure = measure;
            this.thinMeasure = thinMeasure;
        }

        public ThinMeasure getThinMeasure() {
            return this.thinMeasure;
        }

        public Measure.Aggregator getAggregator() {
            if (this.thinMeasure != null && this.thinMeasure.getAggregators() != null && !this.thinMeasure.getAggregators().isEmpty()) {
                String aggregator = this.thinMeasure.getAggregators().get(0);
                if (aggregator.indexOf("_") > 0) {
                    aggregator = aggregator.substring(0, aggregator.indexOf("_"));
                }
                for (Measure.Aggregator agg : Measure.Aggregator.values()) {
                    if (!aggregator.equalsIgnoreCase(agg.name())) continue;
                    return agg;
                }
            }
            return this.measure.getAggregator();
        }

        public Datatype getDatatype() {
            return this.measure.getDatatype();
        }

        public boolean isVisible() {
            return this.measure.isVisible();
        }

        public NamedList<? extends Member> getChildMembers() throws OlapException {
            return this.measure.getChildMembers();
        }

        public int getChildMemberCount() throws OlapException {
            return this.measure.getChildMemberCount();
        }

        public Member getParentMember() {
            return this.measure.getParentMember();
        }

        public Level getLevel() {
            return this.measure.getLevel();
        }

        public Hierarchy getHierarchy() {
            return this.measure.getHierarchy();
        }

        public Dimension getDimension() {
            return this.measure.getDimension();
        }

        public Member.Type getMemberType() {
            return this.measure.getMemberType();
        }

        public boolean isAll() {
            return this.measure.isAll();
        }

        public boolean isChildOrEqualTo(Member member) {
            return this.measure.isChildOrEqualTo(member);
        }

        public boolean isCalculated() {
            return this.measure.isCalculated();
        }

        public int getSolveOrder() {
            return this.measure.getSolveOrder();
        }

        public ParseTreeNode getExpression() {
            return this.measure.getExpression();
        }

        public List<Member> getAncestorMembers() {
            return this.measure.getAncestorMembers();
        }

        public boolean isCalculatedInQuery() {
            return this.measure.isCalculatedInQuery();
        }

        public Object getPropertyValue(Property property) throws OlapException {
            return this.measure.getPropertyValue(property);
        }

        public String getPropertyFormattedValue(Property property) throws OlapException {
            return this.measure.getPropertyFormattedValue(property);
        }

        public void setProperty(Property property, Object o) throws OlapException {
            this.measure.setProperty(property, o);
        }

        public NamedList<Property> getProperties() {
            return this.measure.getProperties();
        }

        public int getOrdinal() {
            return this.measure.getOrdinal();
        }

        public boolean isHidden() {
            return this.measure.isHidden();
        }

        public int getDepth() {
            return this.measure.getDepth();
        }

        public Member getDataMember() {
            return this.measure.getDataMember();
        }

        public String getName() {
            return this.measure.getName();
        }

        public String getUniqueName() {
            return this.measure.getUniqueName();
        }

        public String getCaption() {
            return this.measure.getCaption();
        }

        public String getDescription() {
            return this.measure.getDescription();
        }
    }
}

