/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.olap.query2;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.saiku.olap.query2.ThinAxis;
import org.saiku.olap.query2.ThinCalculatedMeasure;
import org.saiku.olap.query2.ThinCalculatedMember;
import org.saiku.olap.query2.ThinDetails;
import org.saiku.olap.query2.ThinHierarchy;
import org.saiku.olap.query2.ThinLevel;

public class ThinQueryModel {
    private Map<AxisLocation, ThinAxis> axes = new HashMap<AxisLocation, ThinAxis>();
    private boolean visualTotals = false;
    private String visualTotalsPattern;
    private boolean lowestLevelsOnly = false;
    private ThinDetails details;
    private List<ThinCalculatedMeasure> calculatedMeasures = new ArrayList<ThinCalculatedMeasure>();
    private List<ThinCalculatedMember> calculatedMembers = new ArrayList<ThinCalculatedMember>();

    public Map<AxisLocation, ThinAxis> getAxes() {
        return this.axes;
    }

    public ThinAxis getAxis(AxisLocation axis) {
        return this.axes.get((Object)axis);
    }

    public void setAxes(Map<AxisLocation, ThinAxis> axes) {
        this.axes = axes;
    }

    public boolean isVisualTotals() {
        return this.visualTotals;
    }

    public void setVisualTotals(boolean visualTotals) {
        this.visualTotals = visualTotals;
    }

    public String getVisualTotalsPattern() {
        return this.visualTotalsPattern;
    }

    public void setVisualTotalsPattern(String visualTotalsPattern) {
        this.visualTotalsPattern = visualTotalsPattern;
    }

    public boolean isLowestLevelsOnly() {
        return this.lowestLevelsOnly;
    }

    public void setLowestLevelsOnly(boolean lowest) {
        this.lowestLevelsOnly = lowest;
    }

    public List<ThinCalculatedMeasure> getCalculatedMeasures() {
        return this.calculatedMeasures;
    }

    public void setCalculatedMeasures(List<ThinCalculatedMeasure> calculatedMeasures) {
        this.calculatedMeasures = calculatedMeasures;
    }

    public List<ThinCalculatedMember> getCalculatedMembers() {
        return this.calculatedMembers;
    }

    public void setCalculatedMembers(List<ThinCalculatedMember> calculatedMembers) {
        this.calculatedMembers = calculatedMembers;
    }

    public ThinDetails getDetails() {
        return this.details;
    }

    public void setDetails(ThinDetails details) {
        this.details = details;
    }

    public boolean hasAggregators() {
        if (this.axes != null) {
            for (ThinAxis ta : this.axes.values()) {
                if (ta.getAggregators().size() > 0) {
                    return true;
                }
                if (ta.getHierarchies() == null) continue;
                for (ThinHierarchy th : ta.getHierarchies()) {
                    for (ThinLevel tl : th.getLevels().values()) {
                        if (tl.getAggregators() == null || tl.getAggregators().size() <= 0) continue;
                        return true;
                    }
                }
            }
        }
        return false;
    }

    public ThinLevel getLevel(String name) {
        for (ThinAxis ta : this.axes.values()) {
            if (ta.getHierarchies() == null) continue;
            for (ThinHierarchy th : ta.getHierarchies()) {
                for (ThinLevel level : th.getLevels().values()) {
                    String uniqueName = th.getName() + ".[" + level.getName() + "]";
                    if (name == null || !name.equals(uniqueName)) continue;
                    return level;
                }
            }
        }
        return null;
    }

    public static enum AxisLocation {
        FILTER,
        COLUMNS,
        ROWS,
        PAGES;

    }
}

