/*
 * Decompiled with CFR 0.152.
 */
package org.saiku.query.metadata;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.olap4j.OlapException;
import org.olap4j.impl.Named;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.metadata.Datatype;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.NamedList;
import org.olap4j.metadata.Property;
import org.saiku.query.metadata.Calculated;

public class CalculatedMeasure
implements Measure,
Named,
Calculated {
    private Dimension dimension;
    private Hierarchy hierarchy;
    private String name;
    private String uniqueName;
    private String formula;
    private Map<String, String> properties = new HashMap<String, String>();
    private String description;
    private Level level;
    private Datatype datatype;

    public CalculatedMeasure(Hierarchy hierarchy, String name, String description, String formula, Map<String, String> properties) {
        this.dimension = hierarchy.getDimension();
        this.hierarchy = hierarchy;
        this.level = (Level)hierarchy.getLevels().get(0);
        this.name = name;
        this.description = description;
        this.formula = formula;
        this.uniqueName = IdentifierNode.ofNames((String[])new String[]{hierarchy.getName(), name}).toString();
        if (properties != null) {
            this.properties.putAll(properties);
        }
    }

    public Dimension getDimension() {
        return this.dimension;
    }

    public Hierarchy getHierarchy() {
        return this.hierarchy;
    }

    @Override
    public String getFormula() {
        return this.formula;
    }

    public Member.Type getMemberType() {
        return Member.Type.FORMULA;
    }

    @Override
    public Map<String, String> getFormatProperties() {
        return this.properties;
    }

    public String getFormatPropertyValue(String key) throws OlapException {
        if (this.properties.containsKey(key)) {
            return this.properties.get(key);
        }
        return null;
    }

    public void setFormatProperty(String key, String value) throws OlapException {
        this.properties.put(key, value);
    }

    public String getCaption() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getName() {
        return this.name;
    }

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    public Measure.Aggregator getAggregator() {
        return Measure.Aggregator.CALCULATED;
    }

    public boolean isVisible() {
        return true;
    }

    public List<Member> getAncestorMembers() {
        throw new UnsupportedOperationException();
    }

    public int getChildMemberCount() throws OlapException {
        throw new UnsupportedOperationException();
    }

    public NamedList<? extends Member> getChildMembers() throws OlapException {
        throw new UnsupportedOperationException();
    }

    public Member getDataMember() {
        throw new UnsupportedOperationException();
    }

    public int getDepth() {
        throw new UnsupportedOperationException();
    }

    public ParseTreeNode getExpression() {
        throw new UnsupportedOperationException();
    }

    public Level getLevel() {
        return this.level;
    }

    public int getOrdinal() {
        throw new UnsupportedOperationException();
    }

    public Member getParentMember() {
        throw new UnsupportedOperationException();
    }

    public String getPropertyFormattedValue(Property property) throws OlapException {
        return String.valueOf(this.getPropertyValue(property));
    }

    @Override
    public int getSolveOrder() {
        throw new UnsupportedOperationException();
    }

    public boolean isAll() {
        return false;
    }

    public boolean isCalculated() {
        return true;
    }

    public boolean isCalculatedInQuery() {
        return true;
    }

    public boolean isChildOrEqualTo(Member arg0) {
        return false;
    }

    public boolean isHidden() {
        return false;
    }

    public Datatype getDatatype() {
        if (this.datatype != null) {
            return this.datatype;
        }
        return Datatype.STRING;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.uniqueName == null ? 0 : this.uniqueName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CalculatedMeasure other = (CalculatedMeasure)obj;
        return !(this.uniqueName == null ? other.uniqueName != null : !this.uniqueName.equals(other.uniqueName));
    }

    @Deprecated
    public NamedList<Property> getProperties() {
        NamedListImpl l = new NamedListImpl();
        return l;
    }

    @Deprecated
    public Object getPropertyValue(Property p) throws OlapException {
        if (this.properties.containsKey(p.getName())) {
            return this.properties.get(p.getName());
        }
        return null;
    }

    @Deprecated
    public void setProperty(Property arg0, Object arg1) throws OlapException {
    }
}

