/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap4j;

import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.Annotation;
import mondrian.olap.DrillThrough;
import mondrian.olap.Level;
import mondrian.olap.MondrianServer;
import mondrian.olap.OlapElement;
import mondrian.olap.QueryPart;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Util;
import mondrian.olap4j.MondrianOlap4jDimension;
import mondrian.olap4j.MondrianOlap4jLevel;
import mondrian.olap4j.MondrianOlap4jMeasure;
import mondrian.olap4j.MondrianOlap4jMetadataElement;
import mondrian.rolap.DimensionLookup;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapSchema;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.OlapConnection;
import org.olap4j.OlapException;
import org.olap4j.OlapStatement;
import org.olap4j.Position;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Measure;
import org.olap4j.metadata.Member;
import org.olap4j.metadata.MetadataElement;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SaikuMondrianHelper {
    private static final Logger log = LoggerFactory.getLogger(SaikuMondrianHelper.class);

    private static RolapConnection getMondrianConnection(OlapConnection con) {
        try {
            if (!SaikuMondrianHelper.isMondrianConnection(con)) {
                throw new IllegalArgumentException("Connection has to wrap RolapConnection");
            }
            return (RolapConnection)con.unwrap(RolapConnection.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static MondrianServer getMondrianServer(OlapConnection con) {
        RolapConnection rcon = SaikuMondrianHelper.getMondrianConnection(con);
        return rcon != null ? rcon.getServer() : null;
    }

    public static boolean isMondrianConnection(OlapConnection con) {
        try {
            return con.isWrapperFor(RolapConnection.class);
        }
        catch (SQLException e) {
            e.printStackTrace();
            return false;
        }
    }

    public static boolean isMondrianDrillthrough(OlapConnection con, String mdx) {
        boolean isMondrian = SaikuMondrianHelper.isMondrianConnection(con);
        if (isMondrian) {
            RolapConnection rcon = SaikuMondrianHelper.getMondrianConnection(con);
            QueryPart qp = rcon.parseStatement(mdx);
            return qp != null && qp instanceof DrillThrough;
        }
        return false;
    }

    public static void setRoles(OlapConnection con, String[] roleNames) throws Exception {
        Role role;
        RolapConnection rcon = SaikuMondrianHelper.getMondrianConnection(con);
        if (roleNames == null) {
            con.setRoleName(null);
            return;
        }
        RolapSchema schema = rcon.getSchema();
        ArrayList<Role> roleList = new ArrayList<Role>();
        for (String roleName : roleNames) {
            Role role1 = schema.lookupRole(roleName);
            if (role1 == null) {
                throw Util.newError((String)("Role '" + roleName + "' not found"));
            }
            roleList.add(role1);
        }
        switch (roleList.size()) {
            case 0: {
                role = null;
                break;
            }
            case 1: {
                role = (Role)roleList.get(0);
                break;
            }
            default: {
                role = RoleImpl.union(roleList);
            }
        }
        rcon.setRole(role);
    }

    private static boolean isMondrian(MetadataElement element) {
        return element instanceof MondrianOlap4jMetadataElement;
    }

    private static Map<String, Annotation> getAnnotations(org.olap4j.metadata.Level level) {
        if (SaikuMondrianHelper.isMondrian((MetadataElement)level)) {
            MondrianOlap4jLevel mlevel = (MondrianOlap4jLevel)level;
            Level rvl = mlevel.level;
            return rvl.getAnnotationMap();
        }
        return new HashMap<String, Annotation>();
    }

    public static boolean hasAnnotation(org.olap4j.metadata.Level level, String key) {
        Map<String, Annotation> a = SaikuMondrianHelper.getAnnotations(level);
        return a.containsKey(key);
    }

    public boolean isHanger(Dimension dimension) {
        if (SaikuMondrianHelper.isMondrian((MetadataElement)dimension)) {
            RolapCubeDimension dim = (RolapCubeDimension)dimension;
            return DimensionLookup.getHanger(dim);
        }
        return false;
    }

    public static String getMeasureGroup(Measure measure) {
        if (SaikuMondrianHelper.isMondrian((MetadataElement)measure)) {
            MondrianOlap4jMeasure m = (MondrianOlap4jMeasure)measure;
            try {
                return ((RolapBaseCubeMeasure)m.member).getMeasureGroup().getName();
            }
            catch (Exception e) {
                return "";
            }
            catch (Error e2) {
                return "";
            }
        }
        return null;
    }

    private static boolean isHanger(RolapCubeDimension dimension) {
        return DimensionLookup.getHanger(dimension);
    }

    public static ResultSet getSQLMemberLookup(OlapConnection con, String annotation, org.olap4j.metadata.Level level, String search) throws SQLException {
        if (SaikuMondrianHelper.hasAnnotation(level, annotation)) {
            Map<String, Annotation> ann = SaikuMondrianHelper.getAnnotations(level);
            Annotation a = ann.get(annotation);
            String sql = a.getValue().toString();
            log.debug("Level SQLMember Lookup for " + level.getName() + " sql:[" + sql + "] parameter [" + search + "]");
            RolapConnection rcon = (RolapConnection)con.unwrap(RolapConnection.class);
            DataSource ds = rcon.getDataSource();
            Connection sqlcon = ds.getConnection();
            CallableStatement stmt = sqlcon.prepareCall(sql);
            stmt.setString(1, search);
            return stmt.executeQuery();
        }
        return null;
    }

    public static List<Member> getMDXMemberLookup(OlapConnection con, String cube, org.olap4j.metadata.Level level) {
        OlapStatement statement = null;
        try {
            statement = con.createStatement();
        }
        catch (OlapException e) {
            e.printStackTrace();
        }
        try {
            String l = null;
            RolapCubeDimension o = (RolapCubeDimension)((MondrianOlap4jDimension)level.getDimension()).getOlapElement();
            l = SaikuMondrianHelper.isHanger(o) ? level.getHierarchy().getUniqueName() : level.getUniqueName();
            CellSet cellSet = statement.executeOlapQuery("with member [Measures].[Zero] as 0\n select AddCalculatedMembers(" + l + ".Members) on 0\n from [" + cube + "]\n where [Measures].[Zero]");
            ArrayList<Member> members = new ArrayList<Member>();
            List cellSetAxes = cellSet.getAxes();
            CellSetAxis columnsAxis = (CellSetAxis)cellSetAxes.get(0);
            System.out.print("\t");
            for (Position position : columnsAxis.getPositions()) {
                Member m = (Member)position.getMembers().get(0);
                members.add(m);
            }
            return members;
        }
        catch (OlapException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static OlapElement getChildLevel(org.olap4j.metadata.Level l) {
        if (l instanceof MondrianOlap4jLevel) {
            return ((RolapCubeLevel)((MondrianOlap4jLevel)l).getOlapElement()).getChildLevel();
        }
        return null;
    }
}

