/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hslf.examples;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.hslf.record.InteractiveInfoAtom;
import org.apache.poi.hslf.record.RecordTypes;
import org.apache.poi.hslf.usermodel.HSLFShape;
import org.apache.poi.hslf.usermodel.HSLFSlide;
import org.apache.poi.hslf.usermodel.HSLFSlideShow;
import org.apache.poi.hslf.usermodel.HSLFSoundData;

public class SoundFinder {
    public static void main(String[] args) throws IOException {
        try (FileInputStream fis = new FileInputStream(args[0]);
             HSLFSlideShow ppt = new HSLFSlideShow((InputStream)fis);){
            HSLFSoundData[] sounds = ppt.getSoundData();
            for (HSLFSlide slide : ppt.getSlides()) {
                for (HSLFShape shape : slide.getShapes()) {
                    int soundRef = SoundFinder.getSoundReference(shape);
                    if (soundRef == -1) continue;
                    System.out.println("Slide[" + slide.getSlideNumber() + "], shape[" + shape.getShapeId() + "], soundRef: " + soundRef);
                    System.out.println("  " + sounds[soundRef].getSoundName());
                    System.out.println("  " + sounds[soundRef].getSoundType());
                }
            }
        }
    }

    protected static int getSoundReference(HSLFShape shape) {
        int soundRef = -1;
        InteractiveInfoAtom info = (InteractiveInfoAtom)shape.getClientDataRecord((int)RecordTypes.InteractiveInfo.typeID);
        if (info != null && info.getAction() == 6) {
            soundRef = info.getSoundRef();
        }
        return soundRef;
    }
}

