/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.driver.xmla;

import java.sql.Connection;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.DriverPropertyInfo;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Logger;
import org.olap4j.driver.xmla.Factory;
import org.olap4j.driver.xmla.XmlaOlap4jConnection;
import org.olap4j.driver.xmla.XmlaOlap4jDriverVersion;
import org.olap4j.driver.xmla.XmlaOlap4jServerInfos;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jHttpProxy;
import org.olap4j.driver.xmla.proxy.XmlaOlap4jProxy;
import org.olap4j.impl.Olap4jUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlaOlap4jDriver
implements Driver {
    private final Factory factory = XmlaOlap4jDriver.createFactory();
    private static final ExecutorService executor = Executors.newCachedThreadPool(new ThreadFactory(){

        public Thread newThread(Runnable r) {
            Thread t = Executors.defaultThreadFactory().newThread(r);
            t.setDaemon(true);
            return t;
        }
    });
    private static int nextCookie;
    public static final Map<String, XmlaOlap4jProxy> PROXY_MAP;

    private static Factory createFactory() {
        String factoryClassName = XmlaOlap4jDriver.getFactoryClassName();
        try {
            Class<?> clazz = Class.forName(factoryClassName);
            return (Factory)clazz.newInstance();
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String getFactoryClassName() {
        try {
            Class.forName("java.sql.PseudoColumnUsage");
            return "org.olap4j.driver.xmla.FactoryJdbc41Impl";
        }
        catch (ClassNotFoundException e) {
            try {
                Class.forName("java.sql.Wrapper");
                return "org.olap4j.driver.xmla.FactoryJdbc4Impl";
            }
            catch (ClassNotFoundException e2) {
                return "org.olap4j.driver.xmla.FactoryJdbc3Impl";
            }
        }
    }

    private static void register() throws SQLException {
        DriverManager.registerDriver(new XmlaOlap4jDriver());
    }

    @Override
    public Connection connect(String url, Properties info) throws SQLException {
        if (!XmlaOlap4jConnection.acceptsURL(url)) {
            return null;
        }
        Map<String, String> map = XmlaOlap4jConnection.parseConnectString(url, info);
        XmlaOlap4jProxy proxy = this.createProxy(map);
        return this.factory.newConnection(this, proxy, url, info);
    }

    @Override
    public boolean acceptsURL(String url) throws SQLException {
        return XmlaOlap4jConnection.acceptsURL(url);
    }

    @Override
    public DriverPropertyInfo[] getPropertyInfo(String url, Properties info) throws SQLException {
        ArrayList<DriverPropertyInfo> list = new ArrayList<DriverPropertyInfo>();
        for (Map.Entry<Object, Object> entry : info.entrySet()) {
            list.add(new DriverPropertyInfo((String)entry.getKey(), (String)entry.getValue()));
        }
        return list.toArray(new DriverPropertyInfo[list.size()]);
    }

    String getName() {
        return "olap4j driver for XML/A";
    }

    public String getVersion() {
        return "TRUNK-SNAPSHOT";
    }

    @Override
    public int getMajorVersion() {
        return XmlaOlap4jDriverVersion.MAJOR_VERSION;
    }

    @Override
    public int getMinorVersion() {
        return XmlaOlap4jDriverVersion.MINOR_VERSION;
    }

    @Override
    public boolean jdbcCompliant() {
        return false;
    }

    @Override
    public Logger getParentLogger() {
        return Logger.getLogger("");
    }

    protected XmlaOlap4jProxy createProxy(Map<String, String> map) {
        XmlaOlap4jProxy proxy;
        String cookie = map.get(Property.TESTPROXYCOOKIE.name());
        if (cookie != null && (proxy = PROXY_MAP.get(cookie)) != null) {
            return proxy;
        }
        return new XmlaOlap4jHttpProxy(this);
    }

    public static Future<byte[]> getFuture(final XmlaOlap4jProxy proxy, final XmlaOlap4jServerInfos serverInfos, final String request) {
        return executor.submit(new Callable<byte[]>(){

            @Override
            public byte[] call() throws Exception {
                return proxy.get(serverInfos, request);
            }
        });
    }

    public static synchronized String nextCookie() {
        return "cookie" + nextCookie++;
    }

    static {
        try {
            XmlaOlap4jDriver.register();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
        PROXY_MAP = Collections.synchronizedMap(new WeakHashMap());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        TESTPROXYCOOKIE("String that uniquely identifies a proxy object via which to send XMLA requests for testing purposes."),
        SERVER("URL of HTTP server"),
        DATABASE("Name of the database"),
        CATALOG("Catalog name"),
        SCHEMA("Name of the schema"),
        CACHE("Class name of the SOAP cache implementation"),
        ROLE("Comma separated list of roles this connection impersonates"),
        USER("Username to use when creating connections to the server."),
        PASSWORD("Password to use when creating connections to the server.");


        private Property(String description) {
            Olap4jUtil.discard((Object)description);
        }
    }
}

