/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.mdx;

import java.io.PrintWriter;
import java.util.List;
import org.olap4j.mdx.IdentifierNode;
import org.olap4j.mdx.MdxUtil;
import org.olap4j.mdx.ParseRegion;
import org.olap4j.mdx.ParseTreeNode;
import org.olap4j.mdx.ParseTreeVisitor;
import org.olap4j.mdx.ParseTreeWriter;
import org.olap4j.mdx.PropertyValueNode;
import org.olap4j.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WithMemberNode
implements ParseTreeNode {
    private final ParseRegion region;
    private final IdentifierNode name;
    private ParseTreeNode expression;
    private final List<PropertyValueNode> memberPropertyList;

    public WithMemberNode(ParseRegion region, IdentifierNode name, ParseTreeNode exp, List<PropertyValueNode> memberPropertyList) {
        this.region = region;
        this.name = name;
        this.expression = exp;
        this.memberPropertyList = memberPropertyList;
    }

    @Override
    public ParseRegion getRegion() {
        return this.region;
    }

    @Override
    public void unparse(ParseTreeWriter writer) {
        PrintWriter pw = writer.getPrintWriter();
        pw.print("MEMBER ");
        this.name.unparse(writer);
        writer.indent();
        pw.println(" AS");
        this.expression.unparse(writer);
        if (this.memberPropertyList != null) {
            for (PropertyValueNode memberProperty : this.memberPropertyList) {
                pw.print(", ");
                memberProperty.unparse(writer);
            }
        }
        writer.outdent();
    }

    public IdentifierNode getIdentifier() {
        return this.name;
    }

    public ParseTreeNode getExpression() {
        return this.expression;
    }

    public void setExpression(ParseTreeNode expression) {
        this.expression = expression;
    }

    @Override
    public <T> T accept(ParseTreeVisitor<T> visitor) {
        T t = visitor.visit(this);
        this.name.accept(visitor);
        this.expression.accept(visitor);
        return t;
    }

    @Override
    public Type getType() {
        throw new UnsupportedOperationException();
    }

    public List<PropertyValueNode> getMemberPropertyList() {
        return this.memberPropertyList;
    }

    @Override
    public WithMemberNode deepCopy() {
        return new WithMemberNode(this.region, this.name.deepCopy(), this.expression.deepCopy(), MdxUtil.deepCopyList(this.memberPropertyList));
    }
}

