/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.layout;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.olap4j.Cell;
import org.olap4j.CellSet;
import org.olap4j.CellSetAxis;
import org.olap4j.Position;
import org.olap4j.layout.CellSetFormatter;
import org.olap4j.metadata.Member;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TraditionalCellSetFormatter
implements CellSetFormatter {
    @Override
    public void format(CellSet cellSet, PrintWriter pw) {
        TraditionalCellSetFormatter.print(cellSet, pw);
    }

    private static void print(CellSet cellSet, PrintWriter pw) {
        pw.println("Axis #0:");
        TraditionalCellSetFormatter.printAxis(pw, cellSet.getFilterAxis());
        List<CellSetAxis> axes = cellSet.getAxes();
        int axisCount = axes.size();
        for (int i = 0; i < axisCount; ++i) {
            CellSetAxis axis = axes.get(i);
            pw.println("Axis #" + (i + 1) + ":");
            TraditionalCellSetFormatter.printAxis(pw, axis);
        }
        ArrayList<Integer> pos = new ArrayList<Integer>(axisCount);
        for (int i = 0; i < axisCount; ++i) {
            pos.add(-1);
        }
        if (axisCount == 0) {
            TraditionalCellSetFormatter.printCell(cellSet, pw, pos);
        } else {
            TraditionalCellSetFormatter.printRows(cellSet, pw, axisCount - 1, pos);
        }
    }

    private static void printRows(CellSet cellSet, PrintWriter pw, int axis, List<Integer> pos) {
        CellSetAxis _axis = cellSet.getAxes().get(axis);
        List<Position> positions = _axis.getPositions();
        int positionCount = positions.size();
        for (int i = 0; i < positionCount; ++i) {
            pos.set(axis, i);
            if (axis == 0) {
                int row = axis + 1 < pos.size() ? pos.get(axis + 1) : 0;
                pw.print("Row #" + row + ": ");
                TraditionalCellSetFormatter.printCell(cellSet, pw, pos);
                pw.println();
                continue;
            }
            TraditionalCellSetFormatter.printRows(cellSet, pw, axis - 1, pos);
        }
    }

    private static void printAxis(PrintWriter pw, CellSetAxis axis) {
        List<Position> positions = axis.getPositions();
        for (Position position : positions) {
            boolean firstTime = true;
            pw.print("{");
            for (Member member : position.getMembers()) {
                if (!firstTime) {
                    pw.print(", ");
                }
                pw.print(member.getUniqueName());
                firstTime = false;
            }
            pw.println("}");
        }
    }

    private static void printCell(CellSet cellSet, PrintWriter pw, List<Integer> pos) {
        Cell cell = cellSet.getCell(pos);
        pw.print(cell.getFormattedValue());
    }
}

