/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.io.Serializable;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.WeakHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CacheMap<S, T>
implements Map<S, T> {
    private LinkedNode head = new LinkedNode<Object>(null, null);
    private LinkedNode tail = new LinkedNode<Object>(this.head, null);
    private final Map<S, Pair<S, T>> map;
    private final int maxSize;

    public CacheMap(int size) {
        this.map = new WeakHashMap<S, Pair<S, T>>(size);
        this.maxSize = size;
    }

    @Override
    public void clear() {
        this.head = new LinkedNode<Object>(null, null);
        this.tail = new LinkedNode<Object>(this.head, null);
        this.map.clear();
    }

    @Override
    public boolean containsKey(Object key) {
        return this.map.containsKey(key);
    }

    @Override
    public boolean containsValue(Object value) {
        return this.values().contains(value);
    }

    @Override
    public Set entrySet() {
        HashSet<1> set = new HashSet<1>();
        for (final Map.Entry<S, Pair<S, T>> entry : this.map.entrySet()) {
            set.add(new Map.Entry<S, T>(){

                @Override
                public boolean equals(Object s) {
                    if (s instanceof Map.Entry) {
                        return ((Map.Entry)s).getKey().equals(entry.getKey()) && ((Map.Entry)s).getValue().equals(((Pair)entry.getValue()).value);
                    }
                    return false;
                }

                @Override
                public S getKey() {
                    return entry.getKey();
                }

                @Override
                public T getValue() {
                    return ((Pair)entry.getValue()).value;
                }

                @Override
                public int hashCode() {
                    return entry.hashCode();
                }

                @Override
                public T setValue(T x) {
                    return entry.setValue(new Pair(x, new LinkedNode(CacheMap.this.head, entry.getKey()))).value;
                }
            });
        }
        return set;
    }

    @Override
    public T get(Object key) {
        Pair<S, T> pair = this.map.get(key);
        if (pair != null) {
            LinkedNode node = ((Pair)pair).getNode();
            if (node == null) {
                this.map.remove(key);
                return null;
            }
            node.moveTo(this.head);
            return (T)((Pair)pair).value;
        }
        return null;
    }

    @Override
    public boolean isEmpty() {
        return this.map.isEmpty();
    }

    @Override
    public Set<S> keySet() {
        return this.map.keySet();
    }

    @Override
    public T put(S key, T value) {
        Pair pair = new Pair(value, new LinkedNode<S>(this.head, key));
        Pair obj = this.map.put(key, pair);
        if (this.map.size() > this.maxSize) {
            this.tail.getPrevious().remove();
            this.map.remove(key);
        }
        if (obj != null) {
            return (T)obj.value;
        }
        return null;
    }

    @Override
    public void putAll(Map t) {
        throw new UnsupportedOperationException();
    }

    @Override
    public T remove(Object key) {
        Pair<S, T> pair = this.map.get(key);
        if (pair == null) {
            return null;
        }
        ((Pair)pair).getNode().remove();
        return (T)((Pair)this.map.remove(key)).value;
    }

    @Override
    public int size() {
        return this.map.size();
    }

    @Override
    public Collection<T> values() {
        ArrayList<Object> vals = new ArrayList<Object>();
        for (Pair<S, T> pair : this.map.values()) {
            vals.add(((Pair)pair).value);
        }
        return vals;
    }

    @Override
    public int hashCode() {
        return this.map.hashCode();
    }

    public String toString() {
        return "Ordered keys: " + this.head.toString() + "\n" + "Map:" + this.map.toString();
    }

    @Override
    public boolean equals(Object o) {
        CacheMap c = (CacheMap)o;
        return this.map.equals(c.map);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkedNode<S>
    implements Serializable {
        private LinkedNode<S> next;
        private LinkedNode<S> prev;
        private S key;

        public LinkedNode(LinkedNode<S> prev, S key) {
            this.key = key;
            this.insertAfter(prev);
        }

        public void remove() {
            if (this.prev != null) {
                this.prev.next = this.next;
            }
            if (this.next != null) {
                this.next.prev = this.prev;
            }
        }

        public void moveTo(LinkedNode<S> prev) {
            this.remove();
            this.insertAfter(prev);
        }

        public LinkedNode<S> getPrevious() {
            return this.prev;
        }

        public String toString() {
            if (this.next != null) {
                if (this.key != null) {
                    return this.key.toString() + ", " + this.next.toString();
                }
                return "<null>, " + this.next.toString();
            }
            if (this.key != null) {
                return this.key.toString();
            }
            return "<null>";
        }

        private void insertAfter(LinkedNode<S> prev) {
            if (prev != null) {
                this.next = prev.next;
            } else {
                this.prev = null;
            }
            this.prev = prev;
            if (prev != null) {
                if (prev.next != null) {
                    prev.next.prev = this;
                }
                prev.next = this;
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class Pair<S, T>
    implements Serializable {
        private final T value;
        private final WeakReference<LinkedNode<S>> node;

        private Pair(T value, LinkedNode<S> node) {
            this.node = new WeakReference<LinkedNode<S>>(node);
            this.value = value;
        }

        private LinkedNode<S> getNode() {
            return (LinkedNode)this.node.get();
        }

        public boolean equals(Object o) {
            return o != null && o.equals(this.value);
        }
    }
}

